/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityArtilleryRocket;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockMutatorDebris;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.explosion.vanillant.standard.ExplosionEffectStandard;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public class ItemAmmoHIMARS
extends Item {
    public static HIMARSRocket[] itemTypes = new HIMARSRocket[8];
    public static final int SMALL = 0;
    public static final int LARGE = 1;
    public static final int SMALL_HE = 2;
    public static final int SMALL_WP = 3;
    public static final int SMALL_TB = 4;
    public static final int LARGE_TB = 5;
    public static final int SMALL_MINI_NUKE = 6;
    public static final int SMALL_LAVA = 7;

    public ItemAmmoHIMARS() {
        this.func_77627_a(true);
        this.func_77637_a(MainRegistry.weaponTab);
        this.func_111206_d("hbm:ammo_rocket");
        this.func_77625_d(1);
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 7));
        list.add(new ItemStack(item, 1, 6));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 5));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        String r = EnumChatFormatting.RED + "";
        String y = EnumChatFormatting.YELLOW + "";
        String b = EnumChatFormatting.BLUE + "";
        switch (stack.func_77960_j()) {
            case 0: {
                list.add(y + "Strength: 20");
                list.add(y + "Damage modifier: 3x");
                list.add(b + "Does not destroy blocks");
                break;
            }
            case 2: {
                list.add(y + "Strength: 20");
                list.add(y + "Damage modifier: 3x");
                list.add(r + "Destroys blocks");
                break;
            }
            case 3: {
                list.add(y + "Strength: 20");
                list.add(y + "Damage modifier: 3x");
                list.add(r + "Phosphorus splash");
                list.add(b + "Does not destroy blocks");
                break;
            }
            case 4: {
                list.add(y + "Strength: 20");
                list.add(y + "Damage modifier: 10x");
                list.add(r + "Destroys blocks");
                break;
            }
            case 6: {
                list.add(y + "Strength: 20");
                list.add(r + "Deals nuclear damage");
                list.add(r + "Destroys blocks");
                break;
            }
            case 7: {
                list.add(y + "Strength: 20");
                list.add(r + "Creates volcanic lava");
                list.add(r + "Destroys blocks");
                break;
            }
            case 1: {
                list.add(y + "Strength: 50");
                list.add(y + "Damage modifier: 5x");
                list.add(r + "Destroys blocks");
                break;
            }
            case 5: {
                list.add(y + "Strength: 50");
                list.add(y + "Damage modifier: 12x");
                list.add(r + "Destroys blocks");
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item.ammo_himars_" + ItemAmmoHIMARS.itemTypes[Math.abs((int)stack.func_77960_j()) % ItemAmmoHIMARS.itemTypes.length].name;
    }

    public static void standardExplosion(EntityArtilleryRocket rocket, MovingObjectPosition mop, float size, float rangeMod, boolean breaksBlocks, Block slag, int slagMeta) {
        rocket.field_70170_p.func_72908_a(rocket.field_70165_t, rocket.field_70163_u, rocket.field_70161_v, "hbm:weapon.explosionMedium", 20.0f, 0.9f + rocket.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        Vec3 vec = Vec3.func_72443_a((double)rocket.field_70159_w, (double)rocket.field_70181_x, (double)rocket.field_70179_y).func_72432_b();
        ExplosionVNT xnt = new ExplosionVNT(rocket.field_70170_p, mop.field_72307_f.field_72450_a - vec.field_72450_a, mop.field_72307_f.field_72448_b - vec.field_72448_b, mop.field_72307_f.field_72449_c - vec.field_72449_c, size);
        if (breaksBlocks) {
            xnt.setBlockAllocator(new BlockAllocatorStandard(48));
            xnt.setBlockProcessor(new BlockProcessorStandard().setNoDrop().withBlockEffect(new BlockMutatorDebris(slag, slagMeta)));
        }
        xnt.setEntityProcessor(new EntityProcessorCross(7.5).withRangeMod(rangeMod));
        xnt.setPlayerProcessor(new PlayerProcessorStandard());
        xnt.setSFX(new ExplosionEffectStandard());
        xnt.explode();
        rocket.killAndClear();
    }

    public static void standardMush(EntityArtilleryRocket rocket, MovingObjectPosition mop, float size) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "rbmkmush");
        data.func_74776_a("scale", size);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c), new NetworkRegistry.TargetPoint(rocket.field_71093_bK, rocket.field_70165_t, rocket.field_70163_u, rocket.field_70161_v, 250.0));
    }

    private void init() {
        ItemAmmoHIMARS.itemTypes[0] = new HIMARSRocket("standard", "himars_standard", 0){

            @Override
            public void onImpact(EntityArtilleryRocket rocket, MovingObjectPosition mop) {
                ItemAmmoHIMARS.standardExplosion(rocket, mop, 20.0f, 3.0f, false, ModBlocks.block_slag, 1);
            }
        };
        ItemAmmoHIMARS.itemTypes[2] = new HIMARSRocket("standard_he", "himars_standard_he", 0){

            @Override
            public void onImpact(EntityArtilleryRocket rocket, MovingObjectPosition mop) {
                ItemAmmoHIMARS.standardExplosion(rocket, mop, 20.0f, 3.0f, true, ModBlocks.block_slag, 1);
            }
        };
        ItemAmmoHIMARS.itemTypes[7] = new HIMARSRocket("standard_lava", "himars_standard_lava", 0){

            @Override
            public void onImpact(EntityArtilleryRocket rocket, MovingObjectPosition mop) {
                ItemAmmoHIMARS.standardExplosion(rocket, mop, 20.0f, 3.0f, true, ModBlocks.volcanic_lava_block, 0);
            }
        };
        ItemAmmoHIMARS.itemTypes[1] = new HIMARSRocket("single", "himars_single", 1){

            @Override
            public void onImpact(EntityArtilleryRocket rocket, MovingObjectPosition mop) {
                ItemAmmoHIMARS.standardExplosion(rocket, mop, 50.0f, 5.0f, true, ModBlocks.block_slag, 1);
            }
        };
        ItemAmmoHIMARS.itemTypes[6] = new HIMARSRocket("standard_mini_nuke", "himars_standard_mini_nuke", 0){

            @Override
            public void onImpact(EntityArtilleryRocket rocket, MovingObjectPosition mop) {
                rocket.killAndClear();
                Vec3 vec = Vec3.func_72443_a((double)rocket.field_70159_w, (double)rocket.field_70181_x, (double)rocket.field_70179_y).func_72432_b();
                ExplosionNukeSmall.explode(rocket.field_70170_p, mop.field_72307_f.field_72450_a - vec.field_72450_a, mop.field_72307_f.field_72448_b - vec.field_72448_b, mop.field_72307_f.field_72449_c - vec.field_72449_c, ExplosionNukeSmall.PARAMS_MEDIUM);
            }
        };
        ItemAmmoHIMARS.itemTypes[3] = new HIMARSRocket("standard_wp", "himars_standard_wp", 0){

            @Override
            public void onImpact(EntityArtilleryRocket rocket, MovingObjectPosition mop) {
                ItemAmmoHIMARS.standardExplosion(rocket, mop, 20.0f, 3.0f, false, ModBlocks.block_slag, 1);
                ExplosionLarge.spawnShrapnels(rocket.field_70170_p, (int)mop.field_72307_f.field_72450_a, (int)mop.field_72307_f.field_72448_b, (int)mop.field_72307_f.field_72449_c, 30);
                ExplosionChaos.burn(rocket.field_70170_p, (int)mop.field_72307_f.field_72450_a, (int)mop.field_72307_f.field_72448_b, (int)mop.field_72307_f.field_72449_c, 20);
                int radius = 30;
                List hit = rocket.field_70170_p.func_72839_b((Entity)rocket, AxisAlignedBB.func_72330_a((double)(rocket.field_70165_t - (double)radius), (double)(rocket.field_70163_u - (double)radius), (double)(rocket.field_70161_v - (double)radius), (double)(rocket.field_70165_t + (double)radius), (double)(rocket.field_70163_u + (double)radius), (double)(rocket.field_70161_v + (double)radius)));
                for (Entity e : hit) {
                    e.func_70015_d(5);
                    if (!(e instanceof EntityLivingBase)) continue;
                    PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 600, 0, true);
                    eff.getCurativeItems().clear();
                    ((EntityLivingBase)e).func_70690_d(eff);
                }
                for (int i = 0; i < 10; ++i) {
                    NBTTagCompound haze = new NBTTagCompound();
                    haze.func_74778_a("type", "haze");
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(haze, mop.field_72307_f.field_72450_a + rocket.field_70170_p.field_73012_v.nextGaussian() * 15.0, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c + rocket.field_70170_p.field_73012_v.nextGaussian() * 15.0), new NetworkRegistry.TargetPoint(rocket.field_71093_bK, rocket.field_70165_t, rocket.field_70163_u, rocket.field_70161_v, 150.0));
                }
                ItemAmmoHIMARS.standardMush(rocket, mop, 15.0f);
            }
        };
        ItemAmmoHIMARS.itemTypes[4] = new HIMARSRocket("standard_tb", "himars_standard_tb", 0){

            @Override
            public void onImpact(EntityArtilleryRocket rocket, MovingObjectPosition mop) {
                ItemAmmoHIMARS.standardExplosion(rocket, mop, 20.0f, 10.0f, true, ModBlocks.block_slag, 1);
                ExplosionLarge.spawnShrapnels(rocket.field_70170_p, (int)mop.field_72307_f.field_72450_a, (int)mop.field_72307_f.field_72448_b, (int)mop.field_72307_f.field_72449_c, 30);
                ItemAmmoHIMARS.standardMush(rocket, mop, 20.0f);
            }
        };
        ItemAmmoHIMARS.itemTypes[5] = new HIMARSRocket("single_tb", "himars_single_tb", 1){

            @Override
            public void onImpact(EntityArtilleryRocket rocket, MovingObjectPosition mop) {
                ItemAmmoHIMARS.standardExplosion(rocket, mop, 50.0f, 12.0f, true, ModBlocks.slag, 1);
                ExplosionLarge.spawnShrapnels(rocket.field_70170_p, (int)mop.field_72307_f.field_72450_a, (int)mop.field_72307_f.field_72448_b, (int)mop.field_72307_f.field_72449_c, 30);
                ItemAmmoHIMARS.standardMush(rocket, mop, 35.0f);
            }
        };
    }

    public abstract class HIMARSRocket {
        public final String name;
        public final ResourceLocation texture;
        public final int amount;
        public final int modelType;

        public HIMARSRocket(String name, String texture, int type) {
            this.name = name;
            this.texture = new ResourceLocation("hbm:textures/models/projectiles/" + texture + ".png");
            this.amount = type == 0 ? 6 : 1;
            this.modelType = type;
        }

        public abstract void onImpact(EntityArtilleryRocket var1, MovingObjectPosition var2);

        public void onUpdate(EntityArtilleryRocket rocket) {
        }
    }
}

