/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityMist;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.entity.projectile.EntityArtilleryShell;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockMutatorDebris;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.explosion.vanillant.standard.ExplosionEffectStandard;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.SpentCasing;
import com.hbm.potion.HbmPotion;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class ItemAmmoArty
extends Item {
    public static Random rand = new Random();
    public static ArtilleryShell[] itemTypes = new ArtilleryShell[12];
    public final int NORMAL = 0;
    public final int CLASSIC = 1;
    public final int EXPLOSIVE = 2;
    public final int MINI_NUKE = 3;
    public final int NUKE = 4;
    public final int PHOSPHORUS = 5;
    public final int MINI_NUKE_MULTI = 6;
    public final int PHOSPHORUS_MULTI = 7;
    public final int CARGO = 8;
    public final int CHLORINE = 9;
    public final int PHOSGENE = 10;
    public final int MUSTARD = 11;
    private IIcon[] icons = new IIcon[itemTypes.length];
    private IIcon iconCargo;
    protected static SpentCasing SIXTEEN_INCH_CASE = new SpentCasing(SpentCasing.CasingType.STRAIGHT).setScale(15.0f, 15.0f, 10.0f).setupSmoke(1.0f, 1.0, 200, 60).setMaxAge(300);

    public ItemAmmoArty() {
        this.func_77627_a(true);
        this.func_77637_a(MainRegistry.weaponTab);
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 5));
        list.add(new ItemStack(item, 1, 7));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 6));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 8));
        list.add(new ItemStack(item, 1, 9));
        list.add(new ItemStack(item, 1, 10));
        list.add(new ItemStack(item, 1, 11));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        String r = EnumChatFormatting.RED + "";
        String y = EnumChatFormatting.YELLOW + "";
        String b = EnumChatFormatting.BLUE + "";
        switch (stack.func_77960_j()) {
            case 0: {
                list.add(y + "Strength: 10");
                list.add(y + "Damage modifier: 3x");
                list.add(b + "Does not destroy blocks");
                break;
            }
            case 1: {
                list.add(y + "Strength: 15");
                list.add(y + "Damage modifier: 5x");
                list.add(b + "Does not destroy blocks");
                break;
            }
            case 2: {
                list.add(y + "Strength: 15");
                list.add(y + "Damage modifier: 3x");
                list.add(r + "Destroys blocks");
                break;
            }
            case 5: {
                list.add(y + "Strength: 10");
                list.add(y + "Damage modifier: 3x");
                list.add(r + "Phosphorus splash");
                list.add(b + "Does not destroy blocks");
                break;
            }
            case 7: {
                list.add(r + "Splits x10");
                break;
            }
            case 3: {
                list.add(y + "Strength: 20");
                list.add(r + "Deals nuclear damage");
                list.add(r + "Destroys blocks");
                break;
            }
            case 6: {
                list.add(r + "Splits x5");
                break;
            }
            case 4: {
                list.add(r + "\u2620");
                list.add(r + "(that is the best skull and crossbones");
                list.add(r + "minecraft's unicode has to offer)");
                break;
            }
            case 8: {
                if (stack.func_77942_o() && stack.field_77990_d.func_74775_l("cargo") != null) {
                    ItemStack cargo = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("cargo"));
                    list.add(y + cargo.func_82833_r());
                    break;
                }
                list.add(r + "Empty");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[itemTypes.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = reg.func_94245_a("hbm:" + ItemAmmoArty.itemTypes[i].name);
        }
        this.iconCargo = reg.func_94245_a("hbm:ammo_arty_cargo_full");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77960_j() == 8 && stack.func_77942_o() && stack.field_77990_d.func_74775_l("cargo") != null) {
            return this.iconCargo;
        }
        return this.func_77617_a(stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + ItemAmmoArty.itemTypes[Math.abs((int)stack.func_77960_j()) % ItemAmmoArty.itemTypes.length].name;
    }

    public static void standardExplosion(EntityArtilleryShell shell, MovingObjectPosition mop, float size, float rangeMod, boolean breaksBlocks) {
        shell.field_70170_p.func_72908_a(shell.field_70165_t, shell.field_70163_u, shell.field_70161_v, "hbm:weapon.explosionMedium", 20.0f, 0.9f + rand.nextFloat() * 0.2f);
        Vec3 vec = Vec3.func_72443_a((double)shell.field_70159_w, (double)shell.field_70181_x, (double)shell.field_70179_y).func_72432_b();
        ExplosionVNT xnt = new ExplosionVNT(shell.field_70170_p, mop.field_72307_f.field_72450_a - vec.field_72450_a, mop.field_72307_f.field_72448_b - vec.field_72448_b, mop.field_72307_f.field_72449_c - vec.field_72449_c, size);
        if (breaksBlocks) {
            xnt.setBlockAllocator(new BlockAllocatorStandard(48));
            xnt.setBlockProcessor(new BlockProcessorStandard().setNoDrop().withBlockEffect(new BlockMutatorDebris(ModBlocks.block_slag, 1)));
        }
        xnt.setEntityProcessor(new EntityProcessorCross(7.5).withRangeMod(rangeMod));
        xnt.setPlayerProcessor(new PlayerProcessorStandard());
        xnt.setSFX(new ExplosionEffectStandard());
        xnt.explode();
        shell.killAndClear();
    }

    public static void standardCluster(EntityArtilleryShell shell, int clusterType, int amount, double splitHeight, double deviation) {
        if (!shell.getWhistle() || shell.field_70181_x > 0.0) {
            return;
        }
        if (shell.getTargetHeight() + splitHeight < shell.field_70163_u) {
            return;
        }
        shell.killAndClear();
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "plasmablast");
        data.func_74776_a("r", 1.0f);
        data.func_74776_a("g", 1.0f);
        data.func_74776_a("b", 1.0f);
        data.func_74776_a("scale", 50.0f);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, shell.field_70165_t, shell.field_70163_u, shell.field_70161_v), new NetworkRegistry.TargetPoint(shell.field_71093_bK, shell.field_70165_t, shell.field_70163_u, shell.field_70161_v, 500.0));
        for (int i = 0; i < amount; ++i) {
            EntityArtilleryShell cluster = new EntityArtilleryShell(shell.field_70170_p);
            cluster.setType(clusterType);
            cluster.field_70159_w = i == 0 ? shell.field_70159_w : shell.field_70159_w + rand.nextGaussian() * deviation;
            cluster.field_70181_x = shell.field_70181_x;
            cluster.field_70179_y = i == 0 ? shell.field_70179_y : shell.field_70179_y + rand.nextGaussian() * deviation;
            cluster.func_70080_a(shell.field_70165_t, shell.field_70163_u, shell.field_70161_v, shell.field_70177_z, shell.field_70125_A);
            double[] target = shell.getTarget();
            cluster.setTarget(target[0], target[1], target[2]);
            cluster.setWhistle(shell.getWhistle() && !shell.didWhistle());
            shell.field_70170_p.func_72838_d((Entity)cluster);
        }
    }

    private void init() {
        ItemAmmoArty.itemTypes[0] = new ArtilleryShell("ammo_arty", 14192936){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                ItemAmmoArty.standardExplosion(shell, mop, 10.0f, 3.0f, false);
            }
        };
        ItemAmmoArty.itemTypes[1] = new ArtilleryShell("ammo_arty_classic", 14192936){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                ItemAmmoArty.standardExplosion(shell, mop, 15.0f, 5.0f, false);
            }
        };
        ItemAmmoArty.itemTypes[2] = new ArtilleryShell("ammo_arty_he", 14192936){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                ItemAmmoArty.standardExplosion(shell, mop, 15.0f, 3.0f, true);
            }
        };
        ItemAmmoArty.itemTypes[3] = new ArtilleryShell("ammo_arty_mini_nuke", 4805699){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                shell.killAndClear();
                Vec3 vec = Vec3.func_72443_a((double)shell.field_70159_w, (double)shell.field_70181_x, (double)shell.field_70179_y).func_72432_b();
                ExplosionNukeSmall.explode(shell.field_70170_p, mop.field_72307_f.field_72450_a - vec.field_72450_a, mop.field_72307_f.field_72448_b - vec.field_72448_b, mop.field_72307_f.field_72449_c - vec.field_72449_c, ExplosionNukeSmall.PARAMS_MEDIUM);
            }
        };
        ItemAmmoArty.itemTypes[4] = new ArtilleryShell("ammo_arty_nuke", 4805699){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                shell.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(shell.field_70170_p, BombConfig.missileRadius, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c));
                EntityNukeTorex.statFac(shell.field_70170_p, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, BombConfig.missileRadius);
                shell.func_70106_y();
            }
        };
        ItemAmmoArty.itemTypes[5] = new ArtilleryShell("ammo_arty_phosphorus", 0xC8C8C8){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                ItemAmmoArty.standardExplosion(shell, mop, 10.0f, 3.0f, false);
                ExplosionLarge.spawnShrapnels(shell.field_70170_p, (int)mop.field_72307_f.field_72450_a, (int)mop.field_72307_f.field_72448_b, (int)mop.field_72307_f.field_72449_c, 15);
                ExplosionChaos.burn(shell.field_70170_p, (int)mop.field_72307_f.field_72450_a, (int)mop.field_72307_f.field_72448_b, (int)mop.field_72307_f.field_72449_c, 12);
                int radius = 15;
                List hit = shell.field_70170_p.func_72839_b((Entity)shell, AxisAlignedBB.func_72330_a((double)(shell.field_70165_t - (double)radius), (double)(shell.field_70163_u - (double)radius), (double)(shell.field_70161_v - (double)radius), (double)(shell.field_70165_t + (double)radius), (double)(shell.field_70163_u + (double)radius), (double)(shell.field_70161_v + (double)radius)));
                for (Entity e : hit) {
                    e.func_70015_d(5);
                    if (!(e instanceof EntityLivingBase)) continue;
                    PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 600, 0, true);
                    eff.getCurativeItems().clear();
                    ((EntityLivingBase)e).func_70690_d(eff);
                }
                for (int i = 0; i < 5; ++i) {
                    NBTTagCompound haze = new NBTTagCompound();
                    haze.func_74778_a("type", "haze");
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(haze, mop.field_72307_f.field_72450_a + shell.field_70170_p.field_73012_v.nextGaussian() * 10.0, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c + shell.field_70170_p.field_73012_v.nextGaussian() * 10.0), new NetworkRegistry.TargetPoint(shell.field_71093_bK, shell.field_70165_t, shell.field_70163_u, shell.field_70161_v, 150.0));
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "rbmkmush");
                data.func_74776_a("scale", 10.0f);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c), new NetworkRegistry.TargetPoint(shell.field_71093_bK, shell.field_70165_t, shell.field_70163_u, shell.field_70161_v, 250.0));
            }
        };
        ItemAmmoArty.itemTypes[8] = new ArtilleryShell("ammo_arty_cargo", 14192936){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    shell.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
                    shell.getStuck(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e);
                }
            }
        };
        ItemAmmoArty.itemTypes[9] = new ArtilleryShell("ammo_arty_chlorine", 14192936){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                shell.killAndClear();
                Vec3 vec = Vec3.func_72443_a((double)shell.field_70159_w, (double)shell.field_70181_x, (double)shell.field_70179_y).func_72432_b();
                shell.field_70170_p.func_72876_a((Entity)shell, mop.field_72307_f.field_72450_a - vec.field_72450_a, mop.field_72307_f.field_72448_b - vec.field_72448_b, mop.field_72307_f.field_72449_c - vec.field_72449_c, 5.0f, false);
                EntityMist mist = new EntityMist(shell.field_70170_p);
                mist.setType(Fluids.CHLORINE);
                mist.func_70107_b(mop.field_72307_f.field_72450_a - vec.field_72450_a, mop.field_72307_f.field_72448_b - vec.field_72448_b - 3.0, mop.field_72307_f.field_72449_c - vec.field_72449_c);
                mist.setArea(15.0f, 7.5f);
                shell.field_70170_p.func_72838_d((Entity)mist);
                PollutionHandler.incrementPollution(shell.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, PollutionHandler.PollutionType.HEAVYMETAL, 5.0f);
            }
        };
        ItemAmmoArty.itemTypes[10] = new ArtilleryShell("ammo_arty_phosgene", 4805699){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                shell.killAndClear();
                Vec3 vec = Vec3.func_72443_a((double)shell.field_70159_w, (double)shell.field_70181_x, (double)shell.field_70179_y).func_72432_b();
                shell.field_70170_p.func_72876_a((Entity)shell, mop.field_72307_f.field_72450_a - vec.field_72450_a, mop.field_72307_f.field_72448_b - vec.field_72448_b, mop.field_72307_f.field_72449_c - vec.field_72449_c, 5.0f, false);
                for (int i = 0; i < 3; ++i) {
                    EntityMist mist = new EntityMist(shell.field_70170_p);
                    mist.setType(Fluids.PHOSGENE);
                    double x = mop.field_72307_f.field_72450_a - vec.field_72450_a;
                    double z = mop.field_72307_f.field_72449_c - vec.field_72449_c;
                    if (i > 0) {
                        x += rand.nextGaussian() * 15.0;
                        z += rand.nextGaussian() * 15.0;
                    }
                    mist.func_70107_b(x, mop.field_72307_f.field_72448_b - vec.field_72448_b - 5.0, z);
                    mist.setArea(15.0f, 10.0f);
                    shell.field_70170_p.func_72838_d((Entity)mist);
                }
                PollutionHandler.incrementPollution(shell.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, PollutionHandler.PollutionType.HEAVYMETAL, 10.0f);
                PollutionHandler.incrementPollution(shell.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, PollutionHandler.PollutionType.POISON, 15.0f);
            }
        };
        ItemAmmoArty.itemTypes[11] = new ArtilleryShell("ammo_arty_mustard_gas", 4805699){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                shell.killAndClear();
                Vec3 vec = Vec3.func_72443_a((double)shell.field_70159_w, (double)shell.field_70181_x, (double)shell.field_70179_y).func_72432_b();
                shell.field_70170_p.func_72876_a((Entity)shell, mop.field_72307_f.field_72450_a - vec.field_72450_a, mop.field_72307_f.field_72448_b - vec.field_72448_b, mop.field_72307_f.field_72449_c - vec.field_72449_c, 5.0f, false);
                for (int i = 0; i < 5; ++i) {
                    EntityMist mist = new EntityMist(shell.field_70170_p);
                    mist.setType(Fluids.MUSTARDGAS);
                    double x = mop.field_72307_f.field_72450_a - vec.field_72450_a;
                    double z = mop.field_72307_f.field_72449_c - vec.field_72449_c;
                    if (i > 0) {
                        x += rand.nextGaussian() * 25.0;
                        z += rand.nextGaussian() * 25.0;
                    }
                    mist.func_70107_b(x, mop.field_72307_f.field_72448_b - vec.field_72448_b - 5.0, z);
                    mist.setArea(20.0f, 10.0f);
                    shell.field_70170_p.func_72838_d((Entity)mist);
                }
                PollutionHandler.incrementPollution(shell.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, PollutionHandler.PollutionType.HEAVYMETAL, 15.0f);
                PollutionHandler.incrementPollution(shell.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, PollutionHandler.PollutionType.POISON, 30.0f);
            }
        };
        ItemAmmoArty.itemTypes[7] = new ArtilleryShell("ammo_arty_phosphorus_multi", 0xC8C8C8){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                itemTypes[5].onImpact(shell, mop);
            }

            @Override
            public void onUpdate(EntityArtilleryShell shell) {
                ItemAmmoArty.standardCluster(shell, 5, 10, 300.0, 5.0);
            }
        };
        ItemAmmoArty.itemTypes[6] = new ArtilleryShell("ammo_arty_mini_nuke_multi", 4805699){

            @Override
            public void onImpact(EntityArtilleryShell shell, MovingObjectPosition mop) {
                itemTypes[3].onImpact(shell, mop);
            }

            @Override
            public void onUpdate(EntityArtilleryShell shell) {
                ItemAmmoArty.standardCluster(shell, 3, 5, 300.0, 5.0);
            }
        };
    }

    public abstract class ArtilleryShell {
        String name;
        public SpentCasing casing;

        public ArtilleryShell(String name, int casingColor) {
            this.name = name;
            this.casing = SIXTEEN_INCH_CASE.clone().register(name).setColor(casingColor);
        }

        public abstract void onImpact(EntityArtilleryShell var1, MovingObjectPosition var2);

        public void onUpdate(EntityArtilleryShell shell) {
        }
    }
}

