/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IPowerNet;
import api.hbm.energy.PowerNet;
import com.hbm.blocks.BlockDummyable;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.util.ChatBuilder;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemPowerNetTool
extends Item {
    private static final int radius = 20;

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float fX, float fY, float fZ) {
        int[] pos;
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof BlockDummyable && (pos = ((BlockDummyable)b).findCore(world, x, y, z)) != null) {
            x = pos[0];
            y = pos[1];
            z = pos[2];
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (world.field_72995_K) {
            return true;
        }
        if (te instanceof IEnergyConductor) {
            Vec3 pos2;
            IEnergyConductor con = (IEnergyConductor)te;
            IPowerNet net = con.getPowerNet();
            if (net == null) {
                player.func_146105_b((IChatComponent)ChatBuilder.start("Error: No network found! This should be impossible!").color(EnumChatFormatting.RED).flush());
                return true;
            }
            if (!(net instanceof PowerNet)) {
                player.func_146105_b((IChatComponent)ChatBuilder.start("Error: Cannot print diagnostic for non-standard power net implementation!").color(EnumChatFormatting.RED).flush());
            }
            PowerNet network = (PowerNet)net;
            String id = Integer.toHexString(net.hashCode());
            player.func_146105_b((IChatComponent)ChatBuilder.start("Start of diagnostic for network " + id).color(EnumChatFormatting.GOLD).flush());
            player.func_146105_b((IChatComponent)ChatBuilder.start("Links: " + network.getLinks().size()).color(EnumChatFormatting.YELLOW).flush());
            player.func_146105_b((IChatComponent)ChatBuilder.start("Proxies: " + network.getProxies().size()).color(EnumChatFormatting.YELLOW).flush());
            player.func_146105_b((IChatComponent)ChatBuilder.start("Subscribers: " + network.getSubscribers().size()).color(EnumChatFormatting.YELLOW).flush());
            player.func_146105_b((IChatComponent)ChatBuilder.start("End of diagnostic for network " + id).color(EnumChatFormatting.GOLD).flush());
            for (IEnergyConductor link : network.getLinks()) {
                pos2 = link.getDebugParticlePos();
                boolean errored = link.getPowerNet() != net;
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "debug");
                data.func_74768_a("color", errored ? 0xFF0000 : 0xFFFF00);
                data.func_74776_a("scale", 0.5f);
                data.func_74778_a("text", id);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c, 20.0));
            }
            for (IEnergyConnector subscriber : network.getSubscribers()) {
                pos2 = subscriber.getDebugParticlePos();
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "debug");
                data.func_74768_a("color", 255);
                data.func_74776_a("scale", 1.5f);
                data.func_74778_a("text", id);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c, 20.0));
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.RED + "Right-click cable to analyze the power net.");
        list.add(EnumChatFormatting.RED + "Links (cables, poles, etc.) are YELLOW");
        list.add(EnumChatFormatting.RED + "Subscribers (any receiver) are BLUE");
        list.add(EnumChatFormatting.RED + "Links with mismatching network info (BUGGED!) are RED");
        list.add(EnumChatFormatting.RED + "Displays stats such as link and subscriber count");
        list.add(EnumChatFormatting.RED + "Proxies are connection points for multiblock links (e.g. 4 for substations)");
        list.add(EnumChatFormatting.RED + "Particles only spawn in a " + 20 + " block radius!");
    }
}

