/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.block.IToolable;
import api.hbm.fluid.IFillableItem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemBlowtorch
extends Item
implements IFillableItem {
    public ItemBlowtorch() {
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77637_a(MainRegistry.controlTab);
        IToolable.ToolType.TORCH.register(new ItemStack((Item)this));
    }

    public Item func_77655_b(String unlocalizedName) {
        super.func_77655_b(unlocalizedName);
        this.func_111206_d("hbm:" + unlocalizedName);
        return this;
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        if (this == ModItems.blowtorch) {
            return type == Fluids.GAS;
        }
        if (this == ModItems.acetylene_torch) {
            return type == Fluids.UNSATURATEDS || type == Fluids.OXYGEN;
        }
        return false;
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        if (!this.acceptsFluid(type, stack)) {
            return amount;
        }
        int toFill = Math.min(amount, 50);
        toFill = Math.min(toFill, this.getMaxFill(type) - this.getFill(stack, type));
        this.setFill(stack, type, this.getFill(stack, type) + toFill);
        return amount - toFill;
    }

    public int getFill(ItemStack stack, FluidType type) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        return stack.field_77990_d.func_74762_e(type.getUnlocalizedName());
    }

    public int getMaxFill(FluidType type) {
        if (type == Fluids.GAS) {
            return 4000;
        }
        if (type == Fluids.UNSATURATEDS) {
            return 8000;
        }
        if (type == Fluids.OXYGEN) {
            return 16000;
        }
        return 0;
    }

    public void setFill(ItemStack stack, FluidType type, int fill) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        stack.field_77990_d.func_74768_a(type.getUnlocalizedName(), fill);
    }

    public void initNBT(ItemStack stack) {
        stack.field_77990_d = new NBTTagCompound();
        if (this == ModItems.blowtorch) {
            this.setFill(stack, Fluids.GAS, this.getMaxFill(Fluids.GAS));
        }
        if (this == ModItems.acetylene_torch) {
            this.setFill(stack, Fluids.UNSATURATEDS, this.getMaxFill(Fluids.UNSATURATEDS));
            this.setFill(stack, Fluids.OXYGEN, this.getMaxFill(Fluids.OXYGEN));
        }
    }

    public static ItemStack getEmptyTool(Item item) {
        ItemBlowtorch tool = (ItemBlowtorch)item;
        ItemStack stack = new ItemStack(item);
        if (item == ModItems.blowtorch) {
            tool.setFill(stack, Fluids.GAS, 0);
        }
        if (item == ModItems.acetylene_torch) {
            tool.setFill(stack, Fluids.UNSATURATEDS, 0);
            tool.setFill(stack, Fluids.OXYGEN, 0);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float fX, float fY, float fZ) {
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof IToolable) {
            if (this == ModItems.blowtorch && this.getFill(stack, Fluids.GAS) < 1000) {
                return false;
            }
            if (this == ModItems.acetylene_torch) {
                if (this.getFill(stack, Fluids.UNSATURATEDS) < 20) {
                    return false;
                }
                if (this.getFill(stack, Fluids.OXYGEN) < 10) {
                    return false;
                }
            }
            if (((IToolable)b).onScrew(world, player, x, y, z, side, fX, fY, fZ, IToolable.ToolType.TORCH)) {
                if (!world.field_72995_K) {
                    if (this == ModItems.blowtorch) {
                        this.setFill(stack, Fluids.GAS, this.getFill(stack, Fluids.GAS) - 250);
                    }
                    if (this == ModItems.acetylene_torch) {
                        this.setFill(stack, Fluids.UNSATURATEDS, this.getFill(stack, Fluids.UNSATURATEDS) - 20);
                        this.setFill(stack, Fluids.OXYGEN, this.getFill(stack, Fluids.OXYGEN) - 10);
                    }
                    player.field_71069_bz.func_75142_b();
                    NBTTagCompound dPart = new NBTTagCompound();
                    dPart.func_74778_a("type", "tau");
                    dPart.func_74774_a("count", (byte)10);
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(dPart, (float)x + fX, (float)y + fY, (float)z + fZ), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 50.0));
                }
                return true;
            }
        }
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double frac = 0.0;
        if (this == ModItems.blowtorch) {
            frac = (double)this.getFill(stack, Fluids.GAS) / (double)this.getMaxFill(Fluids.GAS);
        }
        if (this == ModItems.acetylene_torch) {
            frac = Math.min((double)this.getFill(stack, Fluids.UNSATURATEDS) / (double)this.getMaxFill(Fluids.UNSATURATEDS), (double)this.getFill(stack, Fluids.OXYGEN) / (double)this.getMaxFill(Fluids.OXYGEN));
        }
        return 1.0 - frac;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        if (this == ModItems.blowtorch) {
            list.add(EnumChatFormatting.YELLOW + this.getFillGauge(stack, Fluids.GAS));
        }
        if (this == ModItems.acetylene_torch) {
            list.add(EnumChatFormatting.YELLOW + this.getFillGauge(stack, Fluids.UNSATURATEDS));
            list.add(EnumChatFormatting.AQUA + this.getFillGauge(stack, Fluids.OXYGEN));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String getFillGauge(ItemStack stack, FluidType type) {
        return I18nUtil.resolveKey(type.getUnlocalizedName(), new Object[0]) + ": " + String.format("%,d", this.getFill(stack, type)) + " / " + String.format("%,d", this.getMaxFill(type));
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return false;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        return amount;
    }
}

