/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.stats.StatList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.world.BlockEvent;

public interface IItemAbility {
    public boolean canHarvestBlock(Block var1, ItemStack var2);

    public boolean isShears(ItemStack var1);

    default public boolean canShearBlock(Block block, ItemStack stack, World world, int x, int y, int z) {
        return this.isShears(stack) && block instanceof IShearable && ((IShearable)block).isShearable(stack, (IBlockAccess)world, x, y, z);
    }

    default public void breakExtraBlock(World world, int x, int y, int z, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        ItemStack stack = player.func_70694_bm();
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!this.canHarvestBlock(block, stack) && !this.canShearBlock(block, stack, world, x, y, z) || block == Blocks.field_150357_h) {
            return;
        }
        Block refBlock = world.func_147439_a(refX, refY, refZ);
        float refStrength = ForgeHooks.blockStrength((Block)refBlock, (EntityPlayer)player, (World)world, (int)refX, (int)refY, (int)refZ);
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f || refBlock.func_149712_f(world, refX, refY, refZ) < 0.0f) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        player.func_71045_bC().func_150999_a(world, block, x, y, z, (EntityPlayer)player);
        if (!world.field_72995_K) {
            if (this.canShearBlock(block, stack, world, x, y, z)) {
                IItemAbility.shearBlock(world, x, y, z, block, (EntityPlayer)player);
            }
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, (EntityPlayer)player, x, y, z, meta);
                block.func_149657_c(world, x, y, z, event.getExpToDrop());
            }
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack;
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if ((itemstack = player.func_71045_bC()) != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
        }
    }

    public static void shearBlock(World world, int x, int y, int z, Block block, EntityPlayer player) {
        IShearable target = (IShearable)block;
        ItemStack held = player.func_70694_bm();
        if (target.isShearable(held, (IBlockAccess)player.field_70170_p, x, y, z)) {
            ArrayList drops = target.onSheared(held, (IBlockAccess)player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)held));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            held.func_77972_a(1, (EntityLivingBase)player);
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
    }

    public static void standardDigPost(World world, int x, int y, int z, EntityPlayerMP player) {
        Block block = world.func_147439_a(x, y, z);
        int l = world.func_72805_g(x, y, z);
        world.func_72889_a((EntityPlayer)player, 2001, x, y, z, Block.func_149682_b((Block)block) + (world.func_72805_g(x, y, z) << 12));
        boolean flag = false;
        if (player.field_71075_bZ.field_75098_d) {
            flag = IItemAbility.removeBlock(world, x, y, z, false, player);
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack = player.func_71045_bC();
            boolean flag1 = block.canHarvestBlock((EntityPlayer)player, l);
            if (itemstack != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
            }
            if ((flag = IItemAbility.removeBlock(world, x, y, z, flag1, player)) && flag1) {
                block.func_149636_a(world, (EntityPlayer)player, x, y, z, l);
            }
        }
    }

    public static boolean removeBlock(World world, int x, int y, int z, boolean canHarvest, EntityPlayerMP player) {
        Block block = world.func_147439_a(x, y, z);
        int l = world.func_72805_g(x, y, z);
        block.func_149681_a(world, x, y, z, l, (EntityPlayer)player);
        boolean flag = block.removedByPlayer(world, (EntityPlayer)player, x, y, z, canHarvest);
        if (flag) {
            block.func_149664_b(world, x, y, z, l);
        }
        return flag;
    }
}

