/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.blocks.rail.IRailNTM;
import com.hbm.entity.train.EntityRailCarBase;
import com.hbm.entity.train.TrainCargoTram;
import com.hbm.entity.train.TrainCargoTramTrailer;
import com.hbm.entity.train.TrainTunnelBore;
import com.hbm.items.ItemEnumMulti;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemTrain
extends ItemEnumMulti {
    public ItemTrain() {
        super(EnumTrainType.class, true, true);
        this.func_77637_a(CreativeTabs.field_78029_e);
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        EnumTrainType train = (EnumTrainType)((Object)EnumUtil.grabEnumSafely(this.theEnum, stack.func_77960_j()));
        if (train.engine != null) {
            list.add(EnumChatFormatting.GREEN + "Engine: " + EnumChatFormatting.RESET + train.engine);
        }
        list.add(EnumChatFormatting.GREEN + "Gauge: " + EnumChatFormatting.RESET + train.gauge);
        if (train.maxSpeed != null) {
            list.add(EnumChatFormatting.GREEN + "Max Speed: " + EnumChatFormatting.RESET + train.maxSpeed);
        }
        if (train.acceleration != null) {
            list.add(EnumChatFormatting.GREEN + "Acceleration: " + EnumChatFormatting.RESET + train.acceleration);
        }
        if (train.brakeThreshold != null) {
            list.add(EnumChatFormatting.GREEN + "Engine Brake Threshold: " + EnumChatFormatting.RESET + train.brakeThreshold);
        }
        if (train.parkingBrake != null) {
            list.add(EnumChatFormatting.GREEN + "Parking Brake: " + EnumChatFormatting.RESET + train.parkingBrake);
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer entity, World world, int x, int y, int z, int side, float fx, float fy, float fz) {
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof IRailNTM) {
            EnumTrainType type = (EnumTrainType)((Object)EnumUtil.grabEnumSafely(this.theEnum, stack.func_77960_j()));
            EntityRailCarBase train = null;
            try {
                train = type.train.getConstructor(World.class).newInstance(world);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (train != null && train.getGauge() == ((IRailNTM)b).getGauge(world, x, y, z)) {
                if (!world.field_72995_K) {
                    train.func_70107_b((float)x + fx, (float)y + fy, (float)z + fz);
                    BlockPos anchor = train.getCurrentAnchorPos();
                    train.field_70177_z = entity.field_70177_z;
                    Vec3 corePos = train.getRelPosAlongRail(anchor, 0.0, new IRailNTM.MoveContext(IRailNTM.RailCheckType.CORE, 0.0));
                    train.func_70107_b(corePos.field_72450_a, corePos.field_72448_b, corePos.field_72449_c);
                    Vec3 frontPos = train.getRelPosAlongRail(anchor, train.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.FRONT, train.getCollisionSpan() - train.getLengthSpan()));
                    Vec3 backPos = train.getRelPosAlongRail(anchor, -train.getLengthSpan(), new IRailNTM.MoveContext(IRailNTM.RailCheckType.BACK, train.getCollisionSpan() - train.getLengthSpan()));
                    train.field_70177_z = EntityRailCarBase.generateYaw(frontPos, backPos);
                    world.func_72838_d((Entity)train);
                }
                --stack.field_77994_a;
                return true;
            }
        }
        return false;
    }

    public static enum EnumTrainType {
        CARGO_TRAM(TrainCargoTram.class, "Electric", "Standard Gauge", "10m/s", "0.2m/s", "<1m/s", "Yes"),
        CARGO_TRAM_TRAILER(TrainCargoTramTrailer.class, null, "Standard Gauge", "Yes", null, null, "No"),
        TUNNEL_BORE(TrainTunnelBore.class, "NONE", "Standard Gauge", "10m/s", "0.2m/s", "<1m/s", "Yes");

        public Class<? extends EntityRailCarBase> train;
        public String engine;
        public String maxSpeed;
        public String acceleration;
        public String brakeThreshold;
        public String parkingBrake;
        public String gauge;

        private EnumTrainType(Class<? extends EntityRailCarBase> train, String engine, String gauge, String maxSpeed, String acceleration, String brakeThreshold, String parkingBrake) {
            this.train = train;
            this.engine = engine;
            this.maxSpeed = maxSpeed;
            this.acceleration = acceleration;
            this.brakeThreshold = brakeThreshold;
            this.parkingBrake = parkingBrake;
            this.gauge = gauge;
        }
    }
}

