/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.config.VersatileConfig;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemRTGPelletDepleted;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckForNull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemRTGPellet
extends Item {
    private short heat = 0;
    private boolean doesDecay = false;
    private ItemStack decayItem = null;
    private long lifespan = 0L;
    public static final List<ItemRTGPellet> pelletList = new ArrayList<ItemRTGPellet>();
    private static final String[] facts = new String[]{"One gram of Pu-238 costs $8,000.", "One gram of Pu-238 produces just under half a Watt of decay heat.", "The typical plutonium RTG contains close to eight kilograms of Pu-238.", "Pu-238's half life is 87.7 years.", "A plutonium RTG was used to power the New Horizons probe that visited Pluto in 2015.", "Po-210 can also be used for RTGs as it generates 140 W/g of decay heat due to its 138 day half life.", "Pa-231 is an isotope of protactinium that easily fissions, but it isn't quite fissile.", "Muons generated by matter-antimatter reactions can trigger nuclear fusion reactions at room temperature.", "Roughly 20% of U-235 nuclei will fail to fission when hit by a neutron. They become U-236 nuclei instead.", "Thorium reactors are really uranium reactors that convert thorium into U-233.", "Natural uranium consists of 99.284% U-238, 0.711% U-235, and 0.0055% U-234.", "Most nuclear reactors use uranium that has been enriched to 3-5% U-235.", "Uranium-based nuclear weapons require uranium enriched to at least 85-90% U-235.", "Depleted uranium is uranium that has had most of its U-235 removed. It is effectively pure U-238.", "In the 1920s, uranium was considered a useless byproduct of the production of radium.", "The Manhattan Project referred to refined natural uranium as tuballoy, enriched uranium as oralloy, and depleted uranium as depletalloy."};

    public ItemRTGPellet(int heatIn) {
        this.heat = (short)heatIn;
        this.func_77625_d(1);
        pelletList.add(this);
    }

    public ItemRTGPellet setDecays(ItemRTGPelletDepleted.DepletedRTGMaterial mat, long life) {
        this.doesDecay = true;
        this.decayItem = new ItemStack(ModItems.pellet_rtg_depleted, 1, mat.ordinal());
        this.lifespan = life;
        return this;
    }

    public long getMaxLifespan() {
        return this.lifespan;
    }

    public short getHeat() {
        return this.heat;
    }

    @CheckForNull
    public ItemStack getDecayItem() {
        return this.decayItem == null ? null : this.decayItem.func_77946_l();
    }

    public boolean getDoesDecay() {
        return this.doesDecay;
    }

    public static ItemStack handleDecay(ItemStack stack, ItemRTGPellet instance) {
        if (instance.getDoesDecay() && VersatileConfig.rtgDecay()) {
            if (instance.getLifespan(stack) <= 0L) {
                return instance.getDecayItem();
            }
            instance.decay(stack);
        }
        return stack;
    }

    public void decay(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemRTGPellet) {
            if (!((ItemRTGPellet)stack.func_77973_b()).getDoesDecay()) {
                return;
            }
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("PELLET_DEPLETION", this.getLifespan(stack) - 1L);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("PELLET_DEPLETION", this.getMaxLifespan());
            }
        }
    }

    public long getLifespan(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemRTGPellet) {
            if (stack.func_77942_o()) {
                return stack.field_77990_d.func_74763_f("PELLET_DEPLETION");
            }
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("PELLET_DEPLETION", this.getMaxLifespan());
            return this.getMaxLifespan();
        }
        return 0L;
    }

    public static short getScaledPower(ItemRTGPellet fuel, ItemStack stack) {
        return (short)Math.ceil((double)fuel.getHeat() * ((double)fuel.getLifespan(stack) / (double)fuel.getMaxLifespan()));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && this == ModItems.pellet_rtg) {
            player.func_146105_b(new ChatComponentText(facts[world.field_73012_v.nextInt(facts.length)]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
            world.func_72956_a((Entity)player, "random.orb", 1.0f, 1.0f);
        }
        return stack;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDoesDecay() && this.getLifespan(stack) != this.getMaxLifespan();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        ItemRTGPellet instance = (ItemRTGPellet)stack.func_77973_b();
        return 1.0 - (double)instance.getLifespan(stack) / (double)instance.getMaxLifespan();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        list.add(I18nUtil.resolveKey(this.func_77658_a().concat(".desc"), new Object[0]));
        ItemRTGPellet instance = (ItemRTGPellet)stack.func_77973_b();
        list.add(I18nUtil.resolveKey("desc.item.rtgHeat", instance.getDoesDecay() && VersatileConfig.scaleRTGPower() ? ItemRTGPellet.getScaledPower(instance, stack) : instance.getHeat()));
        if (instance.getDoesDecay()) {
            list.add(I18nUtil.resolveKey("desc.item.rtgDecay", I18nUtil.resolveKey(instance.getDecayItem().func_77977_a() + ".name", new Object[0]), instance.getDecayItem().field_77994_a));
            list.add(BobMathUtil.toPercentage(instance.getLifespan(stack), instance.getMaxLifespan()));
            if (bool) {
                list.add("EXTENDED INFO:");
                list.add(String.format("%s / %s ticks", instance.getLifespan(stack), instance.getMaxLifespan()));
                String[] timeLeft = BobMathUtil.ticksToDate(instance.getLifespan(stack));
                String[] maxLife = BobMathUtil.ticksToDate(instance.getMaxLifespan());
                list.add(String.format("Time remaining: %s y, %s d, %s h", timeLeft));
                list.add(String.format("Maximum life: %s y, %s d, %s h", maxLife));
            }
        }
    }

    public String getData() {
        return String.format("%s (%s HE/t) %s", I18nUtil.resolveKey(this.func_77658_a().concat(".name"), new Object[0]), this.getHeat(), this.getDoesDecay() ? " (decays)" : "");
    }

    public static HashMap<ItemStack, ItemStack> getRecipeMap() {
        HashMap<ItemStack, ItemStack> map = new HashMap<ItemStack, ItemStack>();
        for (ItemRTGPellet pellet : pelletList) {
            if (pellet.decayItem == null) continue;
            map.put(new ItemStack((Item)pellet), pellet.decayItem.func_77946_l());
        }
        return map;
    }
}

