/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import api.hbm.energy.IBatteryItem;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.util.BobMathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ArmorFSBPowered
extends ArmorFSB
implements IBatteryItem {
    public long maxPower = 1L;
    public long chargeRate;
    public long consumption;
    public long drain;

    public ArmorFSBPowered(ItemArmor.ArmorMaterial material, int slot, String texture, long maxPower, long chargeRate, long consumption, long drain) {
        super(material, slot, texture);
        this.maxPower = maxPower;
        this.chargeRate = chargeRate;
        this.consumption = consumption;
        this.drain = drain;
        this.func_77656_e(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add("Charge: " + BobMathUtil.getShortNumber(this.getCharge(stack)) + " / " + BobMathUtil.getShortNumber(this.maxPower));
        super.func_77624_a(stack, player, list, ext);
    }

    @Override
    public boolean isArmorEnabled(ItemStack stack) {
        return this.getCharge(stack) > 0L;
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ArmorFSBPowered) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") + i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ArmorFSBPowered) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ArmorFSBPowered) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") - i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", this.maxPower - i);
            }
            if (stack.field_77990_d.func_74763_f("charge") < 0L) {
                stack.field_77990_d.func_74772_a("charge", 0L);
            }
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof ArmorFSBPowered) {
            if (stack.func_77942_o()) {
                return stack.field_77990_d.func_74763_f("charge");
            }
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", ((ArmorFSBPowered)stack.func_77973_b()).maxPower);
            return stack.field_77990_d.func_74763_f("charge");
        }
        return 0L;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCharge(stack) < this.maxPower;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.maxPower;
    }

    @Override
    public long getMaxCharge() {
        return this.maxPower;
    }

    @Override
    public long getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public long getDischargeRate() {
        return 0L;
    }

    public void setDamage(ItemStack stack, int damage) {
        this.dischargeBattery(stack, (long)damage * this.consumption);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (this.drain > 0L && ArmorFSB.hasFSBArmor(player) && !player.field_71075_bZ.field_75098_d) {
            this.dischargeBattery(itemStack, this.drain);
        }
    }
}

