/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import api.hbm.fluid.IFillableItem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ArmorFSBFueled
extends ArmorFSB
implements IFillableItem {
    FluidType fuelType;
    public int maxFuel = 1;
    public int fillRate;
    public int consumption;
    public int drain;

    public ArmorFSBFueled(ItemArmor.ArmorMaterial material, int slot, String texture, FluidType fuelType, int maxFuel, int fillRate, int consumption, int drain) {
        super(material, slot, texture);
        this.fuelType = fuelType;
        this.fillRate = fillRate;
        this.consumption = consumption;
        this.drain = drain;
        this.maxFuel = maxFuel;
    }

    public int getFill(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            this.setFill(stack, this.maxFuel);
            return this.maxFuel;
        }
        return stack.field_77990_d.func_74762_e("fuel");
    }

    public void setFill(ItemStack stack, int fill) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("fuel", fill);
    }

    public int getMaxFill(ItemStack stack) {
        return this.maxFuel;
    }

    public int getLoadSpeed(ItemStack stack) {
        return this.fillRate;
    }

    public int getUnloadSpeed(ItemStack stack) {
        return 0;
    }

    public void setDamage(ItemStack stack, int damage) {
        this.setFill(stack, Math.max(this.getFill(stack) - damage * this.consumption, 0));
    }

    @Override
    public boolean isArmorEnabled(ItemStack stack) {
        return this.getFill(stack) > 0;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this.drain > 0 && ArmorFSB.hasFSBArmor(player) && !player.field_71075_bZ.field_75098_d && world.func_82737_E() % 10L == 0L) {
            this.setFill(stack, Math.max(this.getFill(stack) - this.drain, 0));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add(I18nUtil.resolveKey(this.fuelType.getUnlocalizedName(), new Object[0]) + ": " + BobMathUtil.getShortNumber(this.getFill(stack)) + " / " + BobMathUtil.getShortNumber(this.getMaxFill(stack)));
        super.func_77624_a(stack, player, list, ext);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getFill(stack) < this.getMaxFill(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getFill(stack) / (double)this.getMaxFill(stack);
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        return type == this.fuelType;
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        if (!this.acceptsFluid(type, stack)) {
            return amount;
        }
        int toFill = Math.min(amount, this.fillRate);
        toFill = Math.min(toFill, this.maxFuel - this.getFill(stack));
        this.setFill(stack, this.getFill(stack) + toFill);
        return amount - toFill;
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return false;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        return 0;
    }
}

