/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.Tuple;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class RefineryRecipes {
    public static final int oil_frac_heavy = 50;
    public static final int oil_frac_naph = 25;
    public static final int oil_frac_light = 15;
    public static final int oil_frac_petro = 10;
    public static final int crack_frac_naph = 40;
    public static final int crack_frac_light = 30;
    public static final int crack_frac_aroma = 15;
    public static final int crack_frac_unsat = 15;
    public static final int vac_frac_heavy = 40;
    public static final int vac_frac_reform = 25;
    public static final int vac_frac_light = 20;
    public static final int vac_frac_sour = 15;
    private static Map<FluidType, Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>> refinery = new HashMap<FluidType, Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>>();

    public static Map<Object, Object[]> getRefineryRecipe() {
        HashMap<Object, Object[]> recipes = new HashMap<Object, Object[]>();
        for (Map.Entry<FluidType, Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>> recipe : refinery.entrySet()) {
            Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack> fluids = recipe.getValue();
            recipes.put(ItemFluidIcon.make(recipe.getKey(), 1000), new ItemStack[]{ItemFluidIcon.make(fluids.getV().type, fluids.getV().fill * 10), ItemFluidIcon.make(fluids.getW().type, fluids.getW().fill * 10), ItemFluidIcon.make(fluids.getX().type, fluids.getX().fill * 10), ItemFluidIcon.make(fluids.getY().type, fluids.getY().fill * 10), ItemStackUtil.carefulCopy(fluids.getZ())});
        }
        return recipes;
    }

    public static HashMap<Object, Object[]> getVacuumRecipe() {
        HashMap<Object, Object[]> recipes = new HashMap<Object, Object[]>();
        recipes.put(ItemFluidIcon.make(Fluids.OIL, 1000, 2), new ItemStack[]{ItemFluidIcon.make(Fluids.HEAVYOIL_VACUUM, 400), ItemFluidIcon.make(Fluids.REFORMATE, 250), ItemFluidIcon.make(Fluids.LIGHTOIL_VACUUM, 200), ItemFluidIcon.make(Fluids.SOURGAS, 150)});
        return recipes;
    }

    public static void registerRefinery() {
        refinery.put(Fluids.HOTOIL, new Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>(new FluidStack(Fluids.HEAVYOIL, 50), new FluidStack(Fluids.NAPHTHA, 25), new FluidStack(Fluids.LIGHTOIL, 15), new FluidStack(Fluids.PETROLEUM, 10), new ItemStack(ModItems.sulfur)));
        refinery.put(Fluids.HOTCRACKOIL, new Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>(new FluidStack(Fluids.NAPHTHA_CRACK, 40), new FluidStack(Fluids.LIGHTOIL_CRACK, 30), new FluidStack(Fluids.AROMATICS, 15), new FluidStack(Fluids.UNSATURATEDS, 15), OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRACK)));
    }

    public static Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack> getRefinery(FluidType oil) {
        return refinery.get(oil);
    }
}

