/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemStamp;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PressRecipes
extends SerializableRecipe {
    public static HashMap<Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>, ItemStack> recipes = new HashMap();

    public static ItemStack getOutput(ItemStack ingredient, ItemStack stamp) {
        if (ingredient == null || stamp == null) {
            return null;
        }
        if (!(stamp.func_77973_b() instanceof ItemStamp)) {
            return null;
        }
        ItemStamp.StampType type = ((ItemStamp)stamp.func_77973_b()).type;
        for (Map.Entry<Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>, ItemStack> recipe : recipes.entrySet()) {
            if (recipe.getKey().getValue() != type || !recipe.getKey().getKey().matchesRecipe(ingredient, true)) continue;
            return recipe.getValue();
        }
        return null;
    }

    @Override
    public void registerDefaults() {
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.NETHERQUARTZ.dust()), Items.field_151128_bU);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.LAPIS.dust()), new ItemStack(Items.field_151100_aR, 1, 4));
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust()), Items.field_151045_i);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.EMERALD.dust()), Items.field_151166_bC);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pellet_coal), Items.field_151045_i);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.biomass), ModItems.biomass_compressed);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem()), ModItems.ingot_graphite);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.meteorite_sword_reforged), ModItems.meteorite_sword_hardened);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.COAL.dust()), OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.COAL));
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.LIGNITE.dust()), OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.LIGNITE));
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.powder_sawdust), OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.WOOD));
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot()), ModItems.plate_iron);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), ModItems.plate_gold);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.TI.ingot()), ModItems.plate_titanium);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.ingot()), ModItems.plate_aluminium);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot()), ModItems.plate_steel);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.PB.ingot()), ModItems.plate_lead);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), ModItems.plate_copper);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot()), ModItems.plate_advanced_alloy);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot()), ModItems.plate_schrabidium);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot()), ModItems.plate_combine_steel);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot()), ModItems.plate_saturnite);
        PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.ingot()), new ItemStack(ModItems.wire_aluminium, 8));
        PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), new ItemStack(ModItems.wire_copper, 8));
        PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.W.ingot()), new ItemStack(ModItems.wire_tungsten, 8));
        PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot()), new ItemStack(ModItems.wire_red_copper, 8));
        PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), new ItemStack(ModItems.wire_gold, 8));
        PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot()), new ItemStack(ModItems.wire_schrabidium, 8));
        PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot()), new ItemStack(ModItems.wire_advanced_alloy, 8));
        PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.MAGTUNG.ingot()), new ItemStack(ModItems.wire_magnetized_tungsten, 8));
        PressRecipes.makeRecipe(ItemStamp.StampType.CIRCUIT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_raw), ModItems.circuit_aluminium);
        PressRecipes.makeRecipe(ItemStamp.StampType.CIRCUIT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_bismuth_raw), ModItems.circuit_bismuth);
        PressRecipes.makeRecipe(ItemStamp.StampType.CIRCUIT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_arsenic_raw), ModItems.circuit_arsenic);
        PressRecipes.makeRecipe(ItemStamp.StampType.CIRCUIT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_tantalium_raw), ModItems.circuit_tantalium);
        PressRecipes.makeRecipe(ItemStamp.StampType.C357, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_iron), ModItems.ammo_357.stackFromEnum(24, ItemAmmoEnums.Ammo357Magnum.IRON));
        PressRecipes.makeRecipe(ItemStamp.StampType.C357, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_steel), ModItems.ammo_357.stackFromEnum(24, ItemAmmoEnums.Ammo357Magnum.LEAD));
        PressRecipes.makeRecipe(ItemStamp.StampType.C357, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_lead), ModItems.ammo_357.stackFromEnum(24, ItemAmmoEnums.Ammo357Magnum.NUCLEAR));
        PressRecipes.makeRecipe(ItemStamp.StampType.C357, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_gold), ModItems.ammo_357.stackFromEnum(24, ItemAmmoEnums.Ammo357Magnum.GOLD));
        PressRecipes.makeRecipe(ItemStamp.StampType.C357, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_schrabidium), ModItems.ammo_357.stackFromEnum(6, ItemAmmoEnums.Ammo357Magnum.SCHRABIDIUM));
        PressRecipes.makeRecipe(ItemStamp.StampType.C357, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_nightmare), ModItems.ammo_357.stackFromEnum(24, ItemAmmoEnums.Ammo357Magnum.NIGHTMARE1));
        PressRecipes.makeRecipe(ItemStamp.StampType.C357, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_desh), ModItems.ammo_357.stackFromEnum(24, ItemAmmoEnums.Ammo357Magnum.DESH));
        PressRecipes.makeRecipe(ItemStamp.StampType.C357, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot()), ModItems.ammo_357.stackFromEnum(24, ItemAmmoEnums.Ammo357Magnum.STEEL));
        PressRecipes.makeRecipe(ItemStamp.StampType.C44, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_nopip), new ItemStack((Item)ModItems.ammo_44, 24));
        PressRecipes.makeRecipe(ItemStamp.StampType.C44, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_45), new ItemStack((Item)ModItems.ammo_45, 32));
        PressRecipes.makeRecipe(ItemStamp.StampType.C9, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_smg), new ItemStack((Item)ModItems.ammo_9mm, 32));
        PressRecipes.makeRecipe(ItemStamp.StampType.C9, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_uzi), new ItemStack((Item)ModItems.ammo_22lr, 32));
        PressRecipes.makeRecipe(ItemStamp.StampType.C9, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), ModItems.ammo_556.stackFromEnum(32, ItemAmmoEnums.Ammo556mm.GOLD));
        PressRecipes.makeRecipe(ItemStamp.StampType.C9, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_lacunae), new ItemStack((Item)ModItems.ammo_5mm, 64));
        PressRecipes.makeRecipe(ItemStamp.StampType.C9, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_556), new ItemStack((Item)ModItems.ammo_556, 32));
        PressRecipes.makeRecipe(ItemStamp.StampType.C50, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_calamity), new ItemStack((Item)ModItems.ammo_50bmg, 12));
        PressRecipes.makeRecipe(ItemStamp.StampType.C50, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_actionexpress), new ItemStack((Item)ModItems.ammo_50ae, 12));
        PressRecipes.makeRecipe(ItemStamp.StampType.C50, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_luna), ModItems.ammo_luna_sniper.stackFromEnum(4, ItemAmmoEnums.AmmoLunaticSniper.SABOT));
        PressRecipes.makeRecipe(ItemStamp.StampType.C50, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.assembly_762), new ItemStack((Item)ModItems.ammo_762, 32));
    }

    public static void makeRecipe(ItemStamp.StampType type, RecipesCommon.AStack in, Item out) {
        recipes.put(new Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>(in, type), new ItemStack(out));
    }

    public static void makeRecipe(ItemStamp.StampType type, RecipesCommon.AStack in, ItemStack out) {
        recipes.put(new Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>(in, type), out);
    }

    @Override
    public String getFileName() {
        return "hbmPress.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack input = PressRecipes.readAStack(obj.get("input").getAsJsonArray());
        ItemStamp.StampType stamp = ItemStamp.StampType.valueOf(obj.get("stamp").getAsString().toUpperCase());
        ItemStack output = PressRecipes.readItemStack(obj.get("output").getAsJsonArray());
        if (stamp != null) {
            PressRecipes.makeRecipe(stamp, input, output);
        }
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry entry = (Map.Entry)recipe;
        writer.name("input");
        PressRecipes.writeAStack((RecipesCommon.AStack)((Tuple.Pair)entry.getKey()).getKey(), writer);
        writer.name("stamp").value(((ItemStamp.StampType)((Object)((Tuple.Pair)entry.getKey()).getValue())).name().toLowerCase(Locale.US));
        writer.name("output");
        PressRecipes.writeItemStack((ItemStack)entry.getValue(), writer);
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }
}

