/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class CyclotronRecipes
extends SerializableRecipe {
    public static HashMap<Tuple.Pair<RecipesCommon.ComparableStack, RecipesCommon.AStack>, Tuple.Pair<ItemStack, Integer>> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        int liA = 50;
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustLithium"), new ItemStack(ModItems.powder_beryllium), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustBeryllium"), new ItemStack(ModItems.powder_boron), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustBoron"), new ItemStack(ModItems.powder_coal), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustNetherQuartz"), new ItemStack(ModItems.powder_fire), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustPhosphorus"), new ItemStack(ModItems.sulfur), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustIron"), new ItemStack(ModItems.powder_cobalt), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.ComparableStack(ModItems.powder_strontium), new ItemStack(ModItems.powder_zirconium), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustGold"), new ItemStack(ModItems.ingot_mercury), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustPolonium"), new ItemStack(ModItems.powder_astatine), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustLanthanium"), new ItemStack(ModItems.powder_cerium), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack("dustActinium"), new ItemStack(ModItems.powder_thorium), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack(OreDictManager.U.dust()), new ItemStack(ModItems.powder_neptunium), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.OreDictStack(OreDictManager.NP237.dust()), new ItemStack(ModItems.powder_plutonium), liA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_lithium), new RecipesCommon.ComparableStack(ModItems.powder_reiium), new ItemStack(ModItems.powder_weidanium), liA);
        int beA = 25;
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium), new RecipesCommon.OreDictStack("dustLithium"), new ItemStack(ModItems.powder_boron), beA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium), new RecipesCommon.OreDictStack("dustNetherQuartz"), new ItemStack(ModItems.sulfur), beA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium), new RecipesCommon.OreDictStack("dustTitanium"), new ItemStack(ModItems.powder_iron), beA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium), new RecipesCommon.OreDictStack("dustCobalt"), new ItemStack(ModItems.powder_copper), beA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium), new RecipesCommon.ComparableStack(ModItems.powder_strontium), new ItemStack(ModItems.powder_niobium), beA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium), new RecipesCommon.ComparableStack(ModItems.powder_cerium), new ItemStack(ModItems.powder_neodymium), beA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium), new RecipesCommon.OreDictStack("dustThorium"), new ItemStack(ModItems.powder_uranium), beA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_beryllium), new RecipesCommon.ComparableStack(ModItems.powder_weidanium), new ItemStack(ModItems.powder_australium), beA);
        int caA = 10;
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.OreDictStack("dustBoron"), new ItemStack(ModItems.powder_aluminium), caA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.OreDictStack("dustSulfur"), new ItemStack(ModItems.powder_titanium), caA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.OreDictStack("dustTitanium"), new ItemStack(ModItems.powder_cobalt), caA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.ComparableStack(ModItems.powder_caesium), new ItemStack(ModItems.powder_lanthanium), caA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.ComparableStack(ModItems.powder_neodymium), new ItemStack(ModItems.powder_gold), caA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.ComparableStack(ModItems.ingot_mercury), new ItemStack(ModItems.powder_polonium), caA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.OreDictStack(OreDictManager.PB.dust()), new ItemStack(ModItems.powder_ra226), caA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.ComparableStack(ModItems.powder_astatine), new ItemStack(ModItems.powder_actinium), caA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_carbon), new RecipesCommon.ComparableStack(ModItems.powder_australium), new ItemStack(ModItems.powder_verticium), caA);
        int coA = 15;
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.OreDictStack("dustBeryllium"), new ItemStack(ModItems.powder_quartz), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.OreDictStack("dustCoal"), new ItemStack(ModItems.powder_bromine), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.OreDictStack("dustTitanium"), new ItemStack(ModItems.powder_strontium), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.OreDictStack("dustIron"), new ItemStack(ModItems.powder_niobium), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.ComparableStack(ModItems.powder_bromine), new ItemStack(ModItems.powder_iodine), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.ComparableStack(ModItems.powder_strontium), new ItemStack(ModItems.powder_neodymium), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.ComparableStack(ModItems.powder_niobium), new ItemStack(ModItems.powder_caesium), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.ComparableStack(ModItems.powder_iodine), new ItemStack(ModItems.powder_polonium), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.ComparableStack(ModItems.powder_caesium), new ItemStack(ModItems.powder_actinium), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.OreDictStack("dustGold"), new ItemStack(ModItems.powder_uranium), coA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_copper), new RecipesCommon.ComparableStack(ModItems.powder_verticium), new ItemStack(ModItems.powder_unobtainium), coA);
        int plA = 100;
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_plutonium), new RecipesCommon.OreDictStack("dustPhosphorus"), new ItemStack(ModItems.powder_tennessine), plA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_plutonium), new RecipesCommon.OreDictStack(OreDictManager.PU.dust()), new ItemStack(ModItems.powder_tennessine), plA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_plutonium), new RecipesCommon.ComparableStack(ModItems.powder_tennessine), new ItemStack(ModItems.powder_reiium), plA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_plutonium), new RecipesCommon.ComparableStack(ModItems.pellet_charged), new ItemStack(ModItems.nugget_schrabidium), 1000);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_plutonium), new RecipesCommon.ComparableStack(ModItems.powder_unobtainium), new ItemStack(ModItems.powder_daffergon), plA);
        CyclotronRecipes.makeRecipe(new RecipesCommon.ComparableStack(ModItems.part_plutonium), new RecipesCommon.ComparableStack(ModItems.cell_antimatter), new ItemStack(ModItems.cell_anti_schrabidium), 0);
    }

    private static void makeRecipe(RecipesCommon.ComparableStack part, RecipesCommon.AStack in, ItemStack out, int amat) {
        recipes.put(new Tuple.Pair<RecipesCommon.ComparableStack, RecipesCommon.AStack>(part, in), new Tuple.Pair<ItemStack, Integer>(out, amat));
    }

    public static Object[] getOutput(ItemStack stack, ItemStack box) {
        if (stack == null || stack.func_77973_b() == null || box == null) {
            return null;
        }
        RecipesCommon.ComparableStack boxStack = new RecipesCommon.ComparableStack(box).makeSingular();
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack).makeSingular();
        for (Map.Entry<Tuple.Pair<RecipesCommon.ComparableStack, RecipesCommon.AStack>, Tuple.Pair<ItemStack, Integer>> entry : recipes.entrySet()) {
            if (!entry.getKey().getKey().isApplicable(boxStack) || !entry.getKey().getValue().isApplicable(comp)) continue;
            return new Object[]{entry.getValue().getKey().func_77946_l(), entry.getValue().getValue()};
        }
        return null;
    }

    public static Map<Object[], Object> getRecipes() {
        HashMap<Object[], Object> map = new HashMap<Object[], Object>();
        for (Map.Entry<Tuple.Pair<RecipesCommon.ComparableStack, RecipesCommon.AStack>, Tuple.Pair<ItemStack, Integer>> entry : recipes.entrySet()) {
            List<ItemStack> stack = entry.getKey().getValue().extractForNEI();
            for (ItemStack ingredient : stack) {
                map.put(new ItemStack[]{entry.getKey().getKey().toStack(), ingredient}, entry.getValue().getKey());
            }
        }
        return map;
    }

    @Override
    public String getFileName() {
        return "hbmCyclotron.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonArray particle = ((JsonObject)recipe).get("particle").getAsJsonArray();
        JsonArray input = ((JsonObject)recipe).get("input").getAsJsonArray();
        JsonArray output = ((JsonObject)recipe).get("output").getAsJsonArray();
        int antimatter = ((JsonObject)recipe).get("antimatter").getAsInt();
        ItemStack partStack = CyclotronRecipes.readItemStack(particle);
        RecipesCommon.AStack inStack = CyclotronRecipes.readAStack(input);
        ItemStack outStack = CyclotronRecipes.readItemStack(output);
        recipes.put(new Tuple.Pair<RecipesCommon.ComparableStack, RecipesCommon.AStack>(new RecipesCommon.ComparableStack(partStack), inStack), new Tuple.Pair<ItemStack, Integer>(outStack, antimatter));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        try {
            Map.Entry rec = (Map.Entry)recipe;
            writer.name("particle");
            CyclotronRecipes.writeItemStack(((RecipesCommon.ComparableStack)((Tuple.Pair)rec.getKey()).getKey()).toStack(), writer);
            writer.name("input");
            CyclotronRecipes.writeAStack((RecipesCommon.AStack)((Tuple.Pair)rec.getKey()).getValue(), writer);
            writer.name("output");
            CyclotronRecipes.writeItemStack((ItemStack)((Tuple.Pair)rec.getValue()).getKey(), writer);
            writer.name("antimatter").value((Number)((Tuple.Pair)rec.getValue()).getValue());
        }
        catch (Exception ex) {
            MainRegistry.logger.error((Object)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public String getComment() {
        return "The particle item, while being an input, has to be defined as an item stack without ore dictionary support.";
    }
}

