/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMold;
import com.hbm.items.machine.ItemScraps;
import com.hbm.util.Compat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrucibleRecipes
extends SerializableRecipe {
    public static HashMap<Integer, CrucibleRecipe> indexMapping = new HashMap();
    public static List<CrucibleRecipe> recipes = new ArrayList<CrucibleRecipe>();
    private static List<ItemStack[]> moldRecipes = new ArrayList<ItemStack[]>();

    @Override
    public void registerDefaults() {
        int n = MaterialShapes.NUGGET.q(1);
        int i = MaterialShapes.INGOT.q(1);
        recipes.add(new CrucibleRecipe(0, "crucible.steel", 2, new ItemStack(ModItems.ingot_steel)).inputs(new Mats.MaterialStack(Mats.MAT_IRON, n * 2), new Mats.MaterialStack(Mats.MAT_CARBON, n)).outputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 2)));
        if (Compat.isModLoaded("gregtech")) {
            recipes.add(new CrucibleRecipe(9, "crucible.steelWrought", 2, new ItemStack(ModItems.ingot_steel)).inputs(new Mats.MaterialStack(Mats.MAT_WROUGHTIRON, n * 2), new Mats.MaterialStack(Mats.MAT_CARBON, n)).outputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 2)));
            recipes.add(new CrucibleRecipe(10, "crucible.steelPig", 2, new ItemStack(ModItems.ingot_steel)).inputs(new Mats.MaterialStack(Mats.MAT_PIGIRON, n * 2), new Mats.MaterialStack(Mats.MAT_CARBON, n)).outputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 2)));
            recipes.add(new CrucibleRecipe(11, "crucible.steelMeteoric", 2, new ItemStack(ModItems.ingot_steel)).inputs(new Mats.MaterialStack(Mats.MAT_METEORICIRON, n * 2), new Mats.MaterialStack(Mats.MAT_CARBON, n)).outputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 2)));
        }
        recipes.add(new CrucibleRecipe(7, "crucible.hematite", 6, OreDictManager.DictFrame.fromOne(ModBlocks.stone_resource, (Enum)BlockEnums.EnumStoneType.HEMATITE)).inputs(new Mats.MaterialStack(Mats.MAT_HEMATITE, i * 2), new Mats.MaterialStack(Mats.MAT_FLUX, n * 2)).outputs(new Mats.MaterialStack(Mats.MAT_IRON, i), new Mats.MaterialStack(Mats.MAT_SLAG, n * 3)));
        recipes.add(new CrucibleRecipe(8, "crucible.malachite", 6, OreDictManager.DictFrame.fromOne(ModBlocks.stone_resource, (Enum)BlockEnums.EnumStoneType.MALACHITE)).inputs(new Mats.MaterialStack(Mats.MAT_MALACHITE, i * 2), new Mats.MaterialStack(Mats.MAT_FLUX, n * 2)).outputs(new Mats.MaterialStack(Mats.MAT_COPPER, i), new Mats.MaterialStack(Mats.MAT_SLAG, n * 3)));
        recipes.add(new CrucibleRecipe(1, "crucible.redcopper", 2, new ItemStack(ModItems.ingot_red_copper)).inputs(new Mats.MaterialStack(Mats.MAT_COPPER, n), new Mats.MaterialStack(Mats.MAT_REDSTONE, n)).outputs(new Mats.MaterialStack(Mats.MAT_MINGRADE, n * 2)));
        recipes.add(new CrucibleRecipe(2, "crucible.aa", 2, new ItemStack(ModItems.ingot_advanced_alloy)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n), new Mats.MaterialStack(Mats.MAT_MINGRADE, n)).outputs(new Mats.MaterialStack(Mats.MAT_ALLOY, n * 2)));
        recipes.add(new CrucibleRecipe(3, "crucible.hss", 9, new ItemStack(ModItems.ingot_dura_steel)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 5), new Mats.MaterialStack(Mats.MAT_TUNGSTEN, n * 3), new Mats.MaterialStack(Mats.MAT_COBALT, n * 1)).outputs(new Mats.MaterialStack(Mats.MAT_DURA, n * 9)));
        recipes.add(new CrucibleRecipe(4, "crucible.ferro", 3, new ItemStack(ModItems.ingot_ferrouranium)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 2), new Mats.MaterialStack(Mats.MAT_U238, n)).outputs(new Mats.MaterialStack(Mats.MAT_FERRO, n * 3)));
        recipes.add(new CrucibleRecipe(5, "crucible.tcalloy", 9, new ItemStack(ModItems.ingot_tcalloy)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 8), new Mats.MaterialStack(Mats.MAT_TECHNIETIUM, n)).outputs(new Mats.MaterialStack(Mats.MAT_TCALLOY, i)));
        recipes.add(new CrucibleRecipe(12, "crucible.cdalloy", 9, new ItemStack(ModItems.ingot_cdalloy)).inputs(new Mats.MaterialStack(Mats.MAT_STEEL, n * 8), new Mats.MaterialStack(Mats.MAT_CADMIUM, n)).outputs(new Mats.MaterialStack(Mats.MAT_CDALLOY, i)));
        recipes.add(new CrucibleRecipe(13, "crucible.cmb", 3, new ItemStack(ModItems.ingot_combine_steel)).inputs(new Mats.MaterialStack(Mats.MAT_MAGTUNG, n * 6), new Mats.MaterialStack(Mats.MAT_MUD, n * 3)).outputs(new Mats.MaterialStack(Mats.MAT_CMB, i)));
        CrucibleRecipes.registerMoldsForNEI();
    }

    @Override
    public String getFileName() {
        return "hbmCrucible.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public String getComment() {
        return "ID must be unique, but not sequential. Order in which the recipes are defined determines the order in which they are displayed in-game. Frequency is the amount of ticks between operations, must be at least 1. The names are unlocalized by default, but if they can't be found in the lang files the names will be displayed as-is. The icon is what's being displayed when holding shift on the template.";
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        int id = obj.get("id").getAsInt();
        String name = obj.get("name").getAsString();
        int freq = obj.get("frequency").getAsInt();
        ItemStack icon = CrucibleRecipes.readItemStack(obj.get("icon").getAsJsonArray());
        Mats.MaterialStack[] input = new Mats.MaterialStack[obj.get("input").getAsJsonArray().size()];
        for (int i = 0; i < input.length; ++i) {
            JsonArray entry = obj.get("input").getAsJsonArray().get(i).getAsJsonArray();
            String matname = entry.get(0).getAsString();
            int amount = entry.get(1).getAsInt();
            input[i] = new Mats.MaterialStack(Mats.matByName.get(matname), amount);
        }
        Mats.MaterialStack[] output = new Mats.MaterialStack[obj.get("output").getAsJsonArray().size()];
        for (int i = 0; i < output.length; ++i) {
            JsonArray entry = obj.get("output").getAsJsonArray().get(i).getAsJsonArray();
            String matname = entry.get(0).getAsString();
            int amount = entry.get(1).getAsInt();
            output[i] = new Mats.MaterialStack(Mats.matByName.get(matname), amount);
        }
        recipes.add(new CrucibleRecipe(id, name, freq, icon).inputs(input).outputs(output));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        CrucibleRecipe rec = (CrucibleRecipe)recipe;
        writer.name("id").value((long)rec.id);
        writer.name("name").value(rec.name);
        writer.name("frequency").value((long)rec.frequency);
        writer.name("icon");
        CrucibleRecipes.writeItemStack(rec.icon, writer);
        writer.name("input");
        writer.beginArray();
        for (Mats.MaterialStack mat : rec.input) {
            writer.beginArray();
            writer.setIndent("");
            writer.value(mat.material.names[0]).value((long)mat.amount);
            writer.endArray();
            writer.setIndent("  ");
        }
        writer.endArray();
        writer.name("output");
        writer.beginArray();
        for (Mats.MaterialStack mat : rec.output) {
            writer.beginArray();
            writer.setIndent("");
            writer.value(mat.material.names[0]).value((long)mat.amount);
            writer.endArray();
            writer.setIndent("  ");
        }
        writer.endArray();
    }

    @Override
    public void deleteRecipes() {
        indexMapping.clear();
        recipes.clear();
        moldRecipes.clear();
    }

    public static HashMap<RecipesCommon.AStack, List<ItemStack>> getSmeltingRecipes() {
        HashMap<RecipesCommon.AStack, List<ItemStack>> map = new HashMap<RecipesCommon.AStack, List<ItemStack>>();
        for (NTMMaterial nTMMaterial : Mats.orderedList) {
            int in = nTMMaterial.convIn;
            int out = nTMMaterial.convOut;
            NTMMaterial convert = nTMMaterial.smeltsInto;
            for (MaterialShapes shape : MaterialShapes.allShapes) {
                String name = shape.name() + nTMMaterial.names[0];
                ArrayList ores = OreDictionary.getOres((String)name);
                if (ores.isEmpty()) continue;
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.add(ItemScraps.create(new Mats.MaterialStack(convert, shape.q(1) * out / in), true));
                map.put(new RecipesCommon.OreDictStack(name), stacks);
            }
        }
        for (Map.Entry entry : Mats.materialOreEntries.entrySet()) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Mats.MaterialStack mat : (List)entry.getValue()) {
                stacks.add(ItemScraps.create(mat, true));
            }
            map.put(new RecipesCommon.OreDictStack((String)entry.getKey()), stacks);
        }
        for (Map.Entry entry : Mats.materialEntries.entrySet()) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Mats.MaterialStack mat : (List)entry.getValue()) {
                stacks.add(ItemScraps.create(mat, true));
            }
            map.put(((RecipesCommon.ComparableStack)entry.getKey()).copy(), stacks);
        }
        return map;
    }

    public static List<ItemStack[]> getMoldRecipes() {
        if (moldRecipes.isEmpty()) {
            CrucibleRecipes.registerMoldsForNEI();
        }
        return moldRecipes;
    }

    private static void registerMoldsForNEI() {
        for (NTMMaterial material : Mats.orderedList) {
            if (material.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE) continue;
            for (ItemMold.Mold mold : ItemMold.molds) {
                ItemStack out = mold.getOutput(material);
                if (out == null) continue;
                ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(material, mold.getCost()), true);
                ItemStack shape = new ItemStack(ModItems.mold, 1, mold.id);
                ItemStack basin = new ItemStack((Block)(mold.size == 0 ? ModBlocks.foundry_mold : (mold.size == 1 ? ModBlocks.foundry_basin : Blocks.field_150480_ab)));
                ItemStack[] entry = new ItemStack[]{scrap, shape, basin, out};
                moldRecipes.add(entry);
            }
        }
    }

    public static class CrucibleRecipe {
        public Mats.MaterialStack[] input;
        public Mats.MaterialStack[] output;
        private int id;
        private String name;
        public int frequency = 1;
        public ItemStack icon;

        public CrucibleRecipe(int id, String name, int frequency, ItemStack icon) {
            this.id = id;
            this.name = name;
            this.frequency = frequency;
            this.icon = icon;
            if (indexMapping.containsKey(id)) {
                throw new IllegalStateException("Crucible recipe " + name + " has been registered with duplicate id " + id + " used by " + CrucibleRecipes.indexMapping.get((Object)Integer.valueOf((int)id)).name + "!");
            }
            indexMapping.put(id, this);
        }

        public CrucibleRecipe inputs(Mats.MaterialStack ... input) {
            this.input = input;
            return this;
        }

        public CrucibleRecipe outputs(Mats.MaterialStack ... output) {
            this.output = output;
            return this;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getInputAmount() {
            int content = 0;
            for (Mats.MaterialStack stack : this.input) {
                content += stack.amount;
            }
            return content;
        }
    }
}

