/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemBreedingRod;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BreederRecipes
extends SerializableRecipe {
    private static HashMap<RecipesCommon.ComparableStack, BreederRecipe> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.LITHIUM, ItemBreedingRod.BreedingRodType.TRITIUM, 200);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.CO, ItemBreedingRod.BreedingRodType.CO60, 100);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.RA226, ItemBreedingRod.BreedingRodType.AC227, 300);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.TH232, ItemBreedingRod.BreedingRodType.THF, 500);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.U235, ItemBreedingRod.BreedingRodType.NP237, 300);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.NP237, ItemBreedingRod.BreedingRodType.PU238, 200);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.PU238, ItemBreedingRod.BreedingRodType.PU239, 1000);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.U238, ItemBreedingRod.BreedingRodType.RGP, 300);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.URANIUM, ItemBreedingRod.BreedingRodType.RGP, 200);
        BreederRecipes.setRecipe(ItemBreedingRod.BreedingRodType.RGP, ItemBreedingRod.BreedingRodType.WASTE, 200);
        recipes.put(new RecipesCommon.ComparableStack(ModItems.meteorite_sword_etched), new BreederRecipe(new ItemStack(ModItems.meteorite_sword_bred), 1000));
    }

    public static void setRecipe(ItemBreedingRod.BreedingRodType inputType, ItemBreedingRod.BreedingRodType outputType, int flux) {
        recipes.put(new RecipesCommon.ComparableStack(new ItemStack(ModItems.rod, 1, inputType.ordinal())), new BreederRecipe(new ItemStack(ModItems.rod, 1, outputType.ordinal()), flux));
        recipes.put(new RecipesCommon.ComparableStack(new ItemStack(ModItems.rod_dual, 1, inputType.ordinal())), new BreederRecipe(new ItemStack(ModItems.rod_dual, 1, outputType.ordinal()), flux * 2));
        recipes.put(new RecipesCommon.ComparableStack(new ItemStack(ModItems.rod_quad, 1, inputType.ordinal())), new BreederRecipe(new ItemStack(ModItems.rod_quad, 1, outputType.ordinal()), flux * 3));
    }

    public static HashMap<ItemStack, BreederRecipe> getAllRecipes() {
        HashMap<ItemStack, BreederRecipe> map = new HashMap<ItemStack, BreederRecipe>();
        for (Map.Entry<RecipesCommon.ComparableStack, BreederRecipe> recipe : recipes.entrySet()) {
            map.put(recipe.getKey().toStack(), recipe.getValue());
        }
        return map;
    }

    public static BreederRecipe getOutput(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        RecipesCommon.ComparableStack sta = new RecipesCommon.ComparableStack(stack).makeSingular();
        return recipes.get(sta);
    }

    @Override
    public String getFileName() {
        return "hbmBreeder.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack in = BreederRecipes.readAStack(obj.get("input").getAsJsonArray());
        int flux = obj.get("flux").getAsInt();
        ItemStack out = BreederRecipes.readItemStack(obj.get("output").getAsJsonArray());
        recipes.put((RecipesCommon.ComparableStack)in, new BreederRecipe(out, flux));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        RecipesCommon.ComparableStack in = (RecipesCommon.ComparableStack)rec.getKey();
        writer.name("input");
        BreederRecipes.writeAStack(in, writer);
        writer.name("flux").value((long)((BreederRecipe)rec.getValue()).flux);
        writer.name("output");
        BreederRecipes.writeItemStack(((BreederRecipe)rec.getValue()).output, writer);
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    public static class BreederRecipe {
        public ItemStack output;
        public int flux;

        public BreederRecipe(Item output, int flux) {
            this(new ItemStack(output), flux);
        }

        public BreederRecipe(ItemStack output, int flux) {
            this.output = output;
            this.flux = flux;
        }
    }
}

