/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.material;

import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemScraps;
import com.hbm.util.I18nUtil;
import com.hbm.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class Mats {
    public static List<NTMMaterial> orderedList = new ArrayList<NTMMaterial>();
    public static HashMap<String, MaterialShapes> prefixByName = new HashMap();
    public static HashMap<Integer, NTMMaterial> matById = new HashMap();
    public static HashMap<String, NTMMaterial> matByName = new HashMap();
    public static HashMap<RecipesCommon.ComparableStack, List<MaterialStack>> materialEntries = new HashMap();
    public static HashMap<String, List<MaterialStack>> materialOreEntries = new HashMap();
    public static final int _VS = 0;
    public static final int _AS = 30;
    public static final NTMMaterial MAT_STONE = Mats.makeSmeltable(0, Mats.df("Stone"), 0x7F7F7F, 0x353535, 5058339);
    public static final NTMMaterial MAT_CARBON = Mats.makeAdditive(1499, Mats.df("Carbon"), 0x363636, 197379, 0x404040);
    public static final NTMMaterial MAT_COAL = Mats.make(1400, OreDictManager.COAL).setConversion(MAT_CARBON, 2, 1);
    public static final NTMMaterial MAT_LIGNITE = Mats.make(1401, OreDictManager.LIGNITE).setConversion(MAT_CARBON, 3, 1);
    public static final NTMMaterial MAT_COALCOKE = Mats.make(1410, OreDictManager.COALCOKE).setConversion(MAT_CARBON, 4, 3);
    public static final NTMMaterial MAT_PETCOKE = Mats.make(1411, OreDictManager.PETCOKE).setConversion(MAT_CARBON, 4, 3);
    public static final NTMMaterial MAT_LIGCOKE = Mats.make(1412, OreDictManager.LIGCOKE).setConversion(MAT_CARBON, 4, 3);
    public static final NTMMaterial MAT_GRAPHITE = Mats.make(1420, OreDictManager.GRAPHITE).setConversion(MAT_CARBON, 1, 1);
    public static final NTMMaterial MAT_IRON = Mats.makeSmeltable(2600, OreDictManager.IRON, 0xFFFFFF, 0x353535, 16753241).setShapes(MaterialShapes.CASTPLATE);
    public static final NTMMaterial MAT_GOLD = Mats.makeSmeltable(7900, OreDictManager.GOLD, 0xFFFF8B, 12742144, 15259476).setShapes(MaterialShapes.CASTPLATE);
    public static final NTMMaterial MAT_REDSTONE = Mats.makeSmeltable(1, OreDictManager.REDSTONE, 14886412, 7343622, 0xFF1000);
    public static final NTMMaterial MAT_OBSIDIAN = Mats.makeSmeltable(2, Mats.df("Obsidian"), 4006733);
    public static final NTMMaterial MAT_HEMATITE = Mats.makeAdditive(2601, OreDictManager.HEMATITE, 14661550, 6240046, 7226941);
    public static final NTMMaterial MAT_WROUGHTIRON = Mats.makeSmeltable(2602, Mats.df("WroughtIron"), 16427913);
    public static final NTMMaterial MAT_PIGIRON = Mats.makeSmeltable(2603, Mats.df("PigIron"), 16747353);
    public static final NTMMaterial MAT_METEORICIRON = Mats.makeSmeltable(2604, Mats.df("MeteoricIron"), 7426887);
    public static final NTMMaterial MAT_MALACHITE = Mats.makeAdditive(2901, OreDictManager.MALACHITE, 10678472, 2256968, 6401927);
    public static final NTMMaterial MAT_URANIUM = Mats.makeSmeltable(9200, OreDictManager.U, 12699581, 2830887, 10133910).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_U233 = Mats.makeSmeltable(9233, OreDictManager.U233, 12699581, 2830887, 10133910).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_U235 = Mats.makeSmeltable(9235, OreDictManager.U235, 12699581, 2830887, 10133910).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_U238 = Mats.makeSmeltable(9238, OreDictManager.U238, 12699581, 2830887, 10133910).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_THORIUM = Mats.makeSmeltable(9032, OreDictManager.TH232, 12550751, 0x1C0000, 12550751).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_PLUTONIUM = Mats.makeSmeltable(9400, OreDictManager.PU, 10134432, 0x111A17, 7897470).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_RGP = Mats.makeSmeltable(9401, OreDictManager.PURG, 10134432, 0x111A17, 7897470).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_PU238 = Mats.makeSmeltable(9438, OreDictManager.PU238, 16759897, 16748075, 7897470).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_PU239 = Mats.makeSmeltable(9439, OreDictManager.PU239, 10134432, 0x111A17, 7897470).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_PU240 = Mats.makeSmeltable(9440, OreDictManager.PU240, 10134432, 0x111A17, 7897470).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_PU241 = Mats.makeSmeltable(9441, OreDictManager.PU241, 10134432, 0x111A17, 7897470).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_RGA = Mats.makeSmeltable(9501, OreDictManager.AMRG, 9664123).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_AM241 = Mats.makeSmeltable(9541, OreDictManager.AM241, 9664123).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_AM242 = Mats.makeSmeltable(9542, OreDictManager.AM242, 9664123).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_NEPTUNIUM = Mats.makeSmeltable(9337, OreDictManager.NP237, 6582372).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_POLONIUM = Mats.makeSmeltable(8410, OreDictManager.PO210, 5650982).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_TECHNIETIUM = Mats.makeSmeltable(4399, OreDictManager.TC99, 0xFAFFFF, 5729388, 13295583).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_RADIUM = Mats.makeSmeltable(8826, OreDictManager.RA226, 15334134).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_ACTINIUM = Mats.makeSmeltable(8927, OreDictManager.AC227, 0x958989).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT);
    public static final NTMMaterial MAT_CO60 = Mats.makeSmeltable(2760, OreDictManager.CO60, 12767726, 0x353554, 9401006).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST);
    public static final NTMMaterial MAT_AU198 = Mats.makeSmeltable(7998, OreDictManager.AU198, 0xFFFF8B, 12742144, 15259476).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST);
    public static final NTMMaterial MAT_PB209 = Mats.makeSmeltable(8209, OreDictManager.PB209, 8082269).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST);
    public static final NTMMaterial MAT_SCHRABIDIUM = Mats.makeSmeltable(12626, OreDictManager.SA326, 0x32FFFF, 23644, 0x32FFFF).setShapes(MaterialShapes.NUGGET, MaterialShapes.WIRE, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_SOLINIUM = Mats.makeSmeltable(12627, OreDictManager.SA327, 10675936, 17213, 7517872).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_SCHRABIDATE = Mats.makeSmeltable(12600, OreDictManager.SBD, 7848151, 3735646, 6654388).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_SCHRARANIUM = Mats.makeSmeltable(12601, OreDictManager.SRN, 2830887, 2830887, 2404268).setShapes(MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_GHIORSIUM = Mats.makeSmeltable(12836, OreDictManager.GH336, 16052193, 2765574, 13026977).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_TITANIUM = Mats.makeSmeltable(2200, OreDictManager.TI, 16249842, 5196875, 11116153).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_COPPER = Mats.makeSmeltable(2900, OreDictManager.CU, 16632456, 6299149, 12682038).setShapes(MaterialShapes.WIRE, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_TUNGSTEN = Mats.makeSmeltable(7400, OreDictManager.W, 0x868686, 0, 0x977474).setShapes(MaterialShapes.WIRE, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_ALUMINIUM = Mats.makeSmeltable(1300, OreDictManager.AL, 0xFFFFFF, 3425616, 13678827).setShapes(MaterialShapes.WIRE, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_LEAD = Mats.makeSmeltable(8200, OreDictManager.PB, 10921650, 197391, 6579312).setShapes(MaterialShapes.NUGGET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_BISMUTH = Mats.makeSmeltable(8300, OreDictManager.BI, 11665663).setShapes(MaterialShapes.NUGGET, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_ARSENIC = Mats.makeSmeltable(3300, OreDictManager.AS, 7125690, 0x242525, 0x558080).setShapes(MaterialShapes.NUGGET, MaterialShapes.INGOT);
    public static final NTMMaterial MAT_TANTALIUM = Mats.makeSmeltable(7300, OreDictManager.TA, 0xFFFFFF, 1908022, 11049844).setShapes(MaterialShapes.NUGGET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_NIOBIUM = Mats.makeSmeltable(4100, OreDictManager.NB, 12021449, 3091778, 13989553).setShapes(MaterialShapes.NUGGET, MaterialShapes.DUSTTINY, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_BERYLLIUM = Mats.makeSmeltable(400, OreDictManager.BE, 11711142, 986883, 11441522).setShapes(MaterialShapes.NUGGET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_COBALT = Mats.makeSmeltable(2700, OreDictManager.CO, 12767726, 0x353554, 9401006).setShapes(MaterialShapes.NUGGET, MaterialShapes.DUSTTINY, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_BORON = Mats.makeSmeltable(500, OreDictManager.B, 12437714, 2700350, 11367086).setShapes(MaterialShapes.DUSTTINY, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_ZIRCONIUM = Mats.makeSmeltable(4000, OreDictManager.ZR, 14933182, 4077337, 11380360).setShapes(MaterialShapes.NUGGET, MaterialShapes.DUSTTINY, MaterialShapes.BILLET, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_LITHIUM = Mats.makeSmeltable(300, OreDictManager.LI, 0xFFFFFF, 0x818181, 0xD6D6D6).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_CADMIUM = Mats.makeSmeltable(4800, OreDictManager.CD, 16775902, 0x350000, 11032064).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST);
    public static final NTMMaterial MAT_OSMIRIDIUM = Mats.makeSmeltable(7699, OreDictManager.OSMIRIDIUM, 14410735, 7901630, 11320793).setShapes(MaterialShapes.NUGGET, MaterialShapes.INGOT, MaterialShapes.CASTPLATE);
    public static final NTMMaterial MAT_STEEL = Mats.makeSmeltable(30, OreDictManager.STEEL, 0xAFAFAF, 986895, 0x4A4A4A).setShapes(MaterialShapes.DUSTTINY, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_MINGRADE = Mats.makeSmeltable(31, OreDictManager.MINGRADE, 16759421, 11474688, 14961679).setShapes(MaterialShapes.WIRE, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_ALLOY = Mats.makeSmeltable(32, OreDictManager.ALLOY, 16745264, 0x700000, 16741144).setShapes(MaterialShapes.WIRE, MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_DURA = Mats.makeSmeltable(33, OreDictManager.DURA, 1585209, 199435, 0x376373).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_SATURN = Mats.makeSmeltable(34, OreDictManager.BIGMT, 5088175, 12, 5088175).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_DESH = Mats.makeSmeltable(42, OreDictManager.DESH, 0xFF6D6D, 0x720000, 0xF22929).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_STAR = Mats.makeSmeltable(35, OreDictManager.STAR, 0xCCCCEA, 0x11111A, 10855891).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_FERRO = Mats.makeSmeltable(37, OreDictManager.FERRO, 12040137, 0x101022, 0x6B6B8B).setShapes(MaterialShapes.INGOT);
    public static final NTMMaterial MAT_TCALLOY = Mats.makeSmeltable(36, OreDictManager.TCALLOY, 0xD4D6D6, 0x323D3D, 10266278).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.CASTPLATE);
    public static final NTMMaterial MAT_CDALLOY = Mats.makeSmeltable(43, OreDictManager.CDALLOY, 16244623, 6308616, 16503656).setShapes(MaterialShapes.INGOT, MaterialShapes.CASTPLATE);
    public static final NTMMaterial MAT_MAGTUNG = Mats.makeSmeltable(38, OreDictManager.MAGTUNG, 0x22A2A2, 986895, 0x22A2A2).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_CMB = Mats.makeSmeltable(39, OreDictManager.CMB, 7303092, 17, 7303092).setShapes(MaterialShapes.INGOT, MaterialShapes.DUST, MaterialShapes.PLATE, MaterialShapes.CASTPLATE, MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_FLUX = Mats.makeAdditive(40, Mats.df("Flux"), 15851707, 7299670, 14601389).setShapes(MaterialShapes.DUST);
    public static final NTMMaterial MAT_SLAG = Mats.makeSmeltable(41, OreDictManager.SLAG, 5589312, 3418143, 7103842).setShapes(MaterialShapes.BLOCK);
    public static final NTMMaterial MAT_MUD = Mats.makeSmeltable(44, OreDictManager.MUD, 12367273, 4723219, 9861179).setShapes(MaterialShapes.INGOT);

    @Deprecated
    public static NTMMaterial makeSmeltable(int id, OreDictManager.DictFrame dict, int color) {
        return Mats.makeSmeltable(id, dict, color, color, color);
    }

    @Deprecated
    public static NTMMaterial makeAdditive(int id, OreDictManager.DictFrame dict, int color) {
        return Mats.makeAdditive(id, dict, color, color, color);
    }

    public static NTMMaterial make(int id, OreDictManager.DictFrame dict) {
        return new NTMMaterial(id, dict);
    }

    public static NTMMaterial makeSmeltable(int id, OreDictManager.DictFrame dict, int solidColorLight, int solidColorDark, int moltenColor) {
        return new NTMMaterial(id, dict).smeltable(NTMMaterial.SmeltingBehavior.SMELTABLE).setSolidColor(solidColorLight, solidColorDark).setMoltenColor(moltenColor);
    }

    public static NTMMaterial makeAdditive(int id, OreDictManager.DictFrame dict, int solidColorLight, int solidColorDark, int moltenColor) {
        return new NTMMaterial(id, dict).smeltable(NTMMaterial.SmeltingBehavior.ADDITIVE).setSolidColor(solidColorLight, solidColorDark).setMoltenColor(moltenColor);
    }

    public static OreDictManager.DictFrame df(String string) {
        return new OreDictManager.DictFrame(string);
    }

    public static List<MaterialStack> getMaterialsFromItem(ItemStack stack) {
        List<MaterialStack> entries;
        ArrayList<MaterialStack> list = new ArrayList<MaterialStack>();
        List<String> names = ItemStackUtil.getOreDictNames(stack);
        if (!names.isEmpty()) {
            block0: for (String name : names) {
                List<MaterialStack> oreEntries = materialOreEntries.get(name);
                if (oreEntries != null) {
                    list.addAll(oreEntries);
                    break;
                }
                for (Map.Entry<String, MaterialShapes> prefixEntry : prefixByName.entrySet()) {
                    String materialName;
                    NTMMaterial material;
                    String prefix = prefixEntry.getKey();
                    if (!name.startsWith(prefix) || (material = matByName.get(materialName = name.substring(prefix.length()))) == null) continue;
                    list.add(new MaterialStack(material, prefixEntry.getValue().q(1)));
                    break block0;
                }
            }
        }
        if ((entries = materialEntries.get(new RecipesCommon.ComparableStack(stack).makeSingular())) != null) {
            list.addAll(entries);
        }
        if (stack.func_77973_b() == ModItems.scraps) {
            list.add(ItemScraps.getMats(stack));
        }
        return list;
    }

    public static List<MaterialStack> getSmeltingMaterialsFromItem(ItemStack stack) {
        List<MaterialStack> baseMats = Mats.getMaterialsFromItem(stack);
        ArrayList<MaterialStack> smelting = new ArrayList<MaterialStack>();
        baseMats.forEach(x -> smelting.add(new MaterialStack(x.material.smeltsInto, x.amount * x.material.convOut / x.material.convIn)));
        return smelting;
    }

    public static String formatAmount(int amount, boolean showInMb) {
        if (showInMb) {
            return amount * 2 + "mB";
        }
        String format = "";
        int blocks = amount / MaterialShapes.BLOCK.q(1);
        int ingots = (amount -= MaterialShapes.BLOCK.q(blocks)) / MaterialShapes.INGOT.q(1);
        int nuggets = (amount -= MaterialShapes.INGOT.q(ingots)) / MaterialShapes.NUGGET.q(1);
        int quanta = amount -= MaterialShapes.NUGGET.q(nuggets);
        if (blocks > 0) {
            format = format + (blocks == 1 ? I18nUtil.resolveKey("matshape.block", blocks) : I18nUtil.resolveKey("matshape.blocks", blocks)) + " ";
        }
        if (ingots > 0) {
            format = format + (ingots == 1 ? I18nUtil.resolveKey("matshape.ingot", ingots) : I18nUtil.resolveKey("matshape.ingots", ingots)) + " ";
        }
        if (nuggets > 0) {
            format = format + (nuggets == 1 ? I18nUtil.resolveKey("matshape.nugget", nuggets) : I18nUtil.resolveKey("matshape.nuggets", nuggets)) + " ";
        }
        if (quanta > 0) {
            format = format + (quanta == 1 ? I18nUtil.resolveKey("matshape.quantum", quanta) : I18nUtil.resolveKey("matshape.quanta", quanta)) + " ";
        }
        return format.trim();
    }

    public static class MaterialStack {
        public final NTMMaterial material;
        public int amount;

        public MaterialStack(NTMMaterial material, int amount) {
            this.material = material;
            this.amount = amount;
        }

        public MaterialStack copy() {
            return new MaterialStack(this.material, this.amount);
        }
    }
}

