/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerMachineTurbineGas;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.packet.NBTControlPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.TileEntityMachineTurbineGas;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIMachineTurbineGas
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/generators/gui_turbinegas.png");
    private static ResourceLocation gauge_tex = new ResourceLocation("hbm:textures/gui/gauges/button_big.png");
    private TileEntityMachineTurbineGas turbinegas;
    int yStart;
    int slidStart;
    int numberToDisplay = 0;
    int digitNumber = 0;
    int exponent = 0;

    public GUIMachineTurbineGas(InventoryPlayer invPlayer, TileEntityMachineTurbineGas te) {
        super(new ContainerMachineTurbineGas(invPlayer, te));
        this.turbinegas = te;
        this.field_146999_f = 176;
        this.field_147000_g = 223;
    }

    protected void func_73864_a(int x, int y, int i) {
        NBTTagCompound data;
        super.func_73864_a(x, y, i);
        this.slidStart = this.turbinegas.powerSliderPos;
        this.yStart = y;
        if (Math.sqrt(Math.pow(x - this.field_147003_i - 88, 2.0) + Math.pow(y - this.field_147009_r - 40, 2.0)) <= 8.0) {
            if (this.turbinegas.counter == 0 || this.turbinegas.counter == 579) {
                int state = this.turbinegas.state - 1;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                data = new NBTTagCompound();
                data.func_74768_a("state", state);
                PacketDispatcher.wrapper.sendToServer((IMessage)new NBTControlPacket(data, this.turbinegas.field_145851_c, this.turbinegas.field_145848_d, this.turbinegas.field_145849_e));
            } else {
                return;
            }
        }
        if (this.turbinegas.state == 1 && x > this.field_147003_i + 74 && x <= this.field_147003_i + 74 + 29 && y >= this.field_147009_r + 86 && y < this.field_147009_r + 86 + 13) {
            boolean automode = !this.turbinegas.autoMode;
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            data = new NBTTagCompound();
            data.func_74757_a("autoMode", automode);
            PacketDispatcher.wrapper.sendToServer((IMessage)new NBTControlPacket(data, this.turbinegas.field_145851_c, this.turbinegas.field_145848_d, this.turbinegas.field_145849_e));
        }
        if (this.turbinegas.state == 1 && this.field_147009_r + 97 - this.slidStart <= this.yStart && this.field_147009_r + 103 - this.slidStart > this.yStart && this.field_147003_i + 36 < x && this.field_147003_i + 52 >= x) {
            NBTTagCompound data2 = new NBTTagCompound();
            data2.func_74757_a("autoMode", false);
            PacketDispatcher.wrapper.sendToServer((IMessage)new NBTControlPacket(data2, this.turbinegas.field_145851_c, this.turbinegas.field_145848_d, this.turbinegas.field_145849_e));
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
    }

    protected void func_146273_a(int x, int y, int p_146273_3_, long p_146273_4_) {
        super.func_146273_a(x, y, p_146273_3_, p_146273_4_);
        int slidPos = this.turbinegas.powerSliderPos;
        if (!this.turbinegas.autoMode && this.turbinegas.state == 1 && this.field_147003_i + 36 < x && this.field_147003_i + 52 >= x && this.field_147009_r + 37 < y && this.field_147009_r + 103 >= y && this.field_147009_r + 97 - this.slidStart <= this.yStart && this.field_147009_r + 103 - this.slidStart > this.yStart) {
            slidPos = this.field_147009_r + 100 - y;
            if (slidPos > 60) {
                slidPos = 60;
            } else if (slidPos < 0) {
                slidPos = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74780_a("slidPos", (double)slidPos);
            PacketDispatcher.wrapper.sendToServer((IMessage)new NBTControlPacket(data, this.turbinegas.field_145851_c, this.turbinegas.field_145848_d, this.turbinegas.field_145849_e));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        this.drawElectricityInfo(this, mouseX, mouseY, this.field_147003_i + 26, this.field_147009_r + 108, 142, 16, this.turbinegas.power, this.turbinegas.getMaxPower());
        if (this.turbinegas.powerSliderPos == 0) {
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 36, this.field_147009_r + 36, 16, 66, mouseX, mouseY, "Turbine idle");
        } else {
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 36, this.field_147009_r + 36, 16, 66, mouseX, mouseY, this.turbinegas.powerSliderPos * 100 / 60 + "% power");
        }
        if (this.turbinegas.temp >= 20) {
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 133, this.field_147009_r + 23, 8, 72, mouseX, mouseY, "Temperature: " + this.turbinegas.temp + "\u00b0C");
        } else {
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 133, this.field_147009_r + 23, 8, 72, mouseX, mouseY, "Temperature: 20\u00b0C");
        }
        this.turbinegas.tanks[0].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 8, this.field_147009_r + 16, 16, 48);
        this.turbinegas.tanks[1].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 8, this.field_147009_r + 70, 16, 32);
        this.turbinegas.tanks[2].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 147, this.field_147009_r + 61, 16, 36);
        this.turbinegas.tanks[3].renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 147, this.field_147009_r + 21, 16, 36);
        String[] info = I18nUtil.resolveKeyArray("desc.gui.turbinegas.automode", new Object[0]);
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 34, 16, 16, this.field_147003_i - 8, this.field_147009_r + 44 + 16, info);
        ArrayList<String> fuels = new ArrayList<String>();
        fuels.add(I18nUtil.resolveKey("desc.gui.turbinegas.fuels", new Object[0]));
        for (FluidType type : Fluids.getInNiceOrder()) {
            if (!type.hasTrait(FT_Combustible.class) || type.getTrait(FT_Combustible.class).getGrade() != FT_Combustible.FuelGrade.GAS) continue;
            fuels.add("  " + I18nUtil.resolveKey(type.getUnlocalizedName(), new Object[0]));
        }
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 34 + 16, 16, 16, this.field_147003_i - 8, this.field_147009_r + 44 + 16, fuels);
        String[] warning = I18nUtil.resolveKeyArray("desc.gui.turbinegas.warning", new Object[0]);
        if (this.turbinegas.tanks[0].getFill() < 5000 || this.turbinegas.tanks[1].getFill() < 1000) {
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 34 + 32, 16, 16, this.field_147003_i - 8, this.field_147009_r + 44 + 16, warning);
        }
    }

    protected void func_146976_a(float iinterpolation, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.turbinegas.autoMode) {
            this.func_73729_b(this.field_147003_i + 74, this.field_147009_r + 86, 194, 11, 29, 13);
        } else {
            this.func_73729_b(this.field_147003_i + 74, this.field_147009_r + 86, 194, 24, 29, 13);
        }
        switch (this.turbinegas.state) {
            case 0: {
                this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 32, 178, 38, 16, 16);
                break;
            }
            case -1: {
                this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 32, 194, 38, 16, 16);
                this.displayStartup();
                break;
            }
            case 1: {
                this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 32, 210, 38, 16, 16);
                this.drawPowerMeterDisplay(20 * this.turbinegas.instantPowerOutput);
                break;
            }
        }
        this.func_73729_b(this.field_147003_i + 36, this.field_147009_r + 97 - this.turbinegas.powerSliderPos, 178, 0, 16, 6);
        int power = (int)(this.turbinegas.power * 142L / 1000000L);
        this.func_73729_b(this.field_147003_i + 26, this.field_147009_r + 109, 0, 223, power, 16);
        this.drawRPMGauge(this.turbinegas.rpm);
        this.drawThermometer(this.turbinegas.temp);
        this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 34, 16, 16, 3);
        this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 34 + 16, 16, 16, 2);
        if (this.turbinegas.tanks[0].getFill() < 5000 || this.turbinegas.tanks[1].getFill() < 1000) {
            this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 34 + 32, 16, 16, 7);
        }
        if (this.turbinegas.tanks[0].getFill() == 0 || this.turbinegas.tanks[1].getFill() == 0) {
            this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 34 + 32, 16, 16, 6);
        }
        this.turbinegas.tanks[0].renderTank(this.field_147003_i + 8, this.field_147009_r + 65, this.field_73735_i, 16, 48);
        this.turbinegas.tanks[1].renderTank(this.field_147003_i + 8, this.field_147009_r + 103, this.field_73735_i, 16, 32);
        this.turbinegas.tanks[2].renderTank(this.field_147003_i + 147, this.field_147009_r + 98, this.field_73735_i, 16, 36);
        this.turbinegas.tanks[3].renderTank(this.field_147003_i + 147, this.field_147009_r + 58, this.field_73735_i, 16, 36);
    }

    public void displayStartup() {
        boolean displayOn = true;
        if (this.numberToDisplay < 888888 && this.turbinegas.counter < 60) {
            ++this.digitNumber;
            if (this.digitNumber == 9) {
                this.digitNumber = 1;
                ++this.exponent;
            }
            this.numberToDisplay = (int)((double)this.numberToDisplay + Math.pow(10.0, this.exponent));
        }
        if (this.turbinegas.counter > 50) {
            this.numberToDisplay = 0;
        }
        this.drawPowerMeterDisplay(this.numberToDisplay);
    }

    protected void drawPowerMeterDisplay(int number) {
        int i;
        int firstDigitX = 66;
        int firstDigitY = 62;
        int width = 5;
        int height = 11;
        int spaceBetweenBumbers = 3;
        int[] digit = new int[6];
        for (int i2 = 5; i2 >= 0; --i2) {
            digit[i2] = number % 10;
            number /= 10;
            this.func_73729_b(this.field_147003_i + firstDigitX + i2 * 8, this.field_147009_r + 9 + firstDigitY, 194 + digit[i2] * 5, 0, 5, 11);
        }
        int uselessZeros = 0;
        for (i = 0; i < 5 && digit[i] == 0; ++i) {
            ++uselessZeros;
        }
        for (i = 0; i < uselessZeros; ++i) {
            this.func_73729_b(this.field_147003_i + firstDigitX + i * 8, this.field_147009_r + 9 + firstDigitY, 244, 0, 5, 11);
        }
    }

    protected void drawThermometer(int temp) {
        int xPos = this.field_147003_i + 136;
        int yPos = this.field_147009_r + 28;
        int width = 2;
        int height = 64;
        int maxTemp = 800;
        double uMin = 0.6875;
        double uMax = 0.6953125;
        double vMin = (64.0 - (double)(64 * temp / maxTemp)) / 256.0;
        double vMax = 0.25;
        GL11.glEnable((int)3042);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)xPos, (double)(yPos + height), (double)this.field_73735_i, uMin, vMax);
        tessellator.func_78374_a((double)(xPos + width), (double)(yPos + height), (double)this.field_73735_i, uMax, vMax);
        tessellator.func_78374_a((double)(xPos + width), (double)(yPos + 64 - 64 * temp / maxTemp), (double)this.field_73735_i, uMax, vMin);
        tessellator.func_78374_a((double)xPos, (double)(yPos + 64 - 64 * temp / maxTemp), (double)this.field_73735_i, uMin, vMin);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    protected void drawRPMGauge(int position) {
        int xPos = this.field_147003_i + 64;
        int yPos = this.field_147009_r + 16;
        int squareSideLenght = 48;
        double uMin = 0.009900990099009901 * (double)position;
        double uMax = 0.009900990099009901 * (double)(position + 1);
        double vMin = 0.0;
        double vMax = 1.0;
        GL11.glEnable((int)3042);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(gauge_tex);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)xPos, (double)(yPos + squareSideLenght), (double)this.field_73735_i, uMin, vMax);
        tessellator.func_78374_a((double)(xPos + squareSideLenght), (double)(yPos + squareSideLenght), (double)this.field_73735_i, uMax, vMax);
        tessellator.func_78374_a((double)(xPos + squareSideLenght), (double)yPos, (double)this.field_73735_i, uMax, vMin);
        tessellator.func_78374_a((double)xPos, (double)yPos, (double)this.field_73735_i, uMin, vMin);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    protected void func_146979_b(int i, int j) {
        String name = this.turbinegas.func_145818_k_() ? this.turbinegas.func_145825_b() : I18n.func_135052_a((String)this.turbinegas.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 94, 0x404040);
    }
}

