/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerMachineSelenium;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.tileentity.machine.TileEntityMachineSeleniumEngine;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIMachineSelenium
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_selenium.png");
    private TileEntityMachineSeleniumEngine selenium;

    public GUIMachineSelenium(InventoryPlayer invPlayer, TileEntityMachineSeleniumEngine tedf) {
        super(new ContainerMachineSelenium(invPlayer, tedf));
        this.selenium = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        this.selenium.tank.renderTankInfo(this, mouseX, mouseY, this.field_147003_i + 116, this.field_147009_r + 18, 16, 52);
        this.drawElectricityInfo(this, mouseX, mouseY, this.field_147003_i + 8, this.field_147009_r + 108, 160, 16, this.selenium.power, this.selenium.powerCap);
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.YELLOW + "Accepted Fuels:");
        for (FluidType type : Fluids.getInNiceOrder()) {
            long energy = TileEntityMachineSeleniumEngine.getHEFromFuel(type);
            if (energy <= 0L) continue;
            text.add("  " + I18nUtil.resolveKey(type.getUnlocalizedName(), new Object[0]) + " (" + BobMathUtil.getShortNumber(energy) + "HE/t)");
        }
        text.add(EnumChatFormatting.ITALIC + "(These numbers are base values,");
        text.add(EnumChatFormatting.ITALIC + "actual output is based");
        text.add(EnumChatFormatting.ITALIC + "on piston count)");
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 36, 16, 16, this.field_147003_i - 8, this.field_147009_r + 36 + 16, text.toArray(new String[0]));
        String[] text1 = new String[]{"Fuel consumption rate:", "  1 mB/t", "  20 mB/s", "(Consumption rate per piston)"};
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 36 + 16, 16, 16, this.field_147003_i - 8, this.field_147009_r + 36 + 16, text1);
        if (this.selenium.pistonCount < 3) {
            String[] text2 = new String[]{"Error: At least three pistons are", "required to operate this radial engine!"};
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 36 + 32, 16, 16, this.field_147003_i - 8, this.field_147009_r + 36 + 16 + 32, text2);
        }
        if (!this.selenium.hasAcceptableFuel()) {
            String[] text2 = new String[]{"Error: The currently set fuel type", "is not supported by this engine!"};
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 16, this.field_147009_r + 36 + 48, 16, 16, this.field_147003_i - 8, this.field_147009_r + 36 + 16 + 32, text2);
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = this.selenium.func_145818_k_() ? this.selenium.func_145825_b() : I18n.func_135052_a((String)this.selenium.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.selenium.power > 0L) {
            int i = (int)this.selenium.getPowerScaled(160L);
            i = Math.min(i, 160);
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 108, 0, 222, i, 16);
        }
        if (this.selenium.tank.getFill() > 0 && this.selenium.hasAcceptableFuel() && this.selenium.pistonCount > 2) {
            this.func_73729_b(this.field_147003_i + 115, this.field_147009_r + 71, 192, 0, 18, 18);
        }
        if (this.selenium.pistonCount > 0) {
            int k = this.selenium.pistonCount;
            this.func_73729_b(this.field_147003_i + 26, this.field_147009_r + 81, 176, 52 + 16 * k - 16, 16, 16);
        }
        if (this.selenium.pistonCount < 3) {
            this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 36 + 32, 16, 16, 6);
        }
        if (!this.selenium.hasAcceptableFuel()) {
            this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 36 + 48, 16, 16, 7);
        }
        this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 36, 16, 16, 2);
        this.drawInfoPanel(this.field_147003_i - 16, this.field_147009_r + 36 + 16, 16, 16, 3);
        this.selenium.tank.renderTank(this.field_147003_i + 80 + 36, this.field_147009_r + 70, this.field_73735_i, 16, 52);
    }
}

