/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.inventory.container.ContainerMachineGasCent;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.tileentity.machine.TileEntityMachineGasCent;
import com.hbm.util.I18nUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIMachineGasCent
extends GuiInfoContainer {
    public static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/processing/gui_centrifuge_gas.png");
    private TileEntityMachineGasCent gasCent;

    public GUIMachineGasCent(InventoryPlayer invPlayer, TileEntityMachineGasCent tedf) {
        super(new ContainerMachineGasCent(invPlayer, tedf));
        this.gasCent = tedf;
        this.field_146999_f = 206;
        this.field_147000_g = 204;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        String[] inTankInfo = new String[]{this.gasCent.inputTank.getTankType().getName(), this.gasCent.inputTank.getFill() + " / " + this.gasCent.inputTank.getMaxFill() + " mB"};
        if (this.gasCent.inputTank.getTankType().getIfHighSpeed()) {
            inTankInfo[0] = this.gasCent.getProcessingSpeed() > 150 - 70 ? EnumChatFormatting.DARK_RED + inTankInfo[0] : EnumChatFormatting.GOLD + inTankInfo[0];
        }
        String[] outTankInfo = new String[]{this.gasCent.outputTank.getTankType().getName(), this.gasCent.outputTank.getFill() + " / " + this.gasCent.outputTank.getMaxFill() + " mB"};
        if (this.gasCent.outputTank.getTankType().getIfHighSpeed()) {
            outTankInfo[0] = EnumChatFormatting.GOLD + outTankInfo[0];
        }
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 15, this.field_147009_r + 15, 24, 55, mouseX, mouseY, inTankInfo);
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 137, this.field_147009_r + 15, 25, 55, mouseX, mouseY, outTankInfo);
        this.drawElectricityInfo(this, mouseX, mouseY, this.field_147003_i + 182, this.field_147009_r + 69 - 52, 16, 52, this.gasCent.power, 100000L);
        String[] enrichmentText = I18nUtil.resolveKeyArray("desc.gui.gasCent.enrichment", new Object[0]);
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 12, this.field_147009_r + 16, 16, 16, this.field_147003_i - 8, this.field_147009_r + 16 + 16, enrichmentText);
        String[] transferText = I18nUtil.resolveKeyArray("desc.gui.gasCent.output", new Object[0]);
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i - 12, this.field_147009_r + 32, 16, 16, this.field_147003_i - 8, this.field_147009_r + 32 + 16, transferText);
    }

    protected void func_146979_b(int i, int j) {
        String name = this.gasCent.func_145818_k_() ? this.gasCent.func_145825_b() : I18n.func_135052_a((String)this.gasCent.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int i = (int)this.gasCent.getPowerRemainingScaled(52);
        this.func_73729_b(this.field_147003_i + 182, this.field_147009_r + 69 - i, 206, 52 - i, 16, i);
        int j = this.gasCent.getCentrifugeProgressScaled(36);
        this.func_73729_b(this.field_147003_i + 70, this.field_147009_r + 35, 206, 52, j, 13);
        this.renderTank(this.field_147003_i + 16, this.field_147009_r + 16, this.field_73735_i, 6, 52, this.gasCent.inputTank.getFill(), this.gasCent.inputTank.getMaxFill());
        this.renderTank(this.field_147003_i + 32, this.field_147009_r + 16, this.field_73735_i, 6, 52, this.gasCent.inputTank.getFill(), this.gasCent.inputTank.getMaxFill());
        this.renderTank(this.field_147003_i + 138, this.field_147009_r + 16, this.field_73735_i, 6, 52, this.gasCent.outputTank.getFill(), this.gasCent.outputTank.getMaxFill());
        this.renderTank(this.field_147003_i + 154, this.field_147009_r + 16, this.field_73735_i, 6, 52, this.gasCent.outputTank.getFill(), this.gasCent.outputTank.getMaxFill());
        this.drawInfoPanel(this.field_147003_i - 12, this.field_147009_r + 16, 16, 16, 3);
        this.drawInfoPanel(this.field_147003_i - 12, this.field_147009_r + 32, 16, 16, 2);
    }

    public void renderTank(int x, int y, double z, int width, int height, int fluid, int maxFluid) {
        GL11.glEnable((int)3042);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gasCent.tank.getTankType().getTexture());
        int i = fluid * height / maxFluid;
        double minX = x;
        double maxX = x + width;
        double minY = (y += height) - height;
        double maxY = y - (height - i);
        double minV = 1.0;
        double maxV = 1.0 - (double)i / 16.0;
        double minU = 0.0;
        double maxU = (double)width / 16.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(minX, maxY, z, minU, maxV);
        tessellator.func_78374_a(maxX, maxY, z, maxU, maxV);
        tessellator.func_78374_a(maxX, minY, z, maxU, minV);
        tessellator.func_78374_a(minX, minY, z, minU, minV);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }
}

