/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.tank;

import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidLoaderFillableItem;
import com.hbm.inventory.fluid.tank.FluidLoaderInfinite;
import com.hbm.inventory.fluid.tank.FluidLoaderStandard;
import com.hbm.inventory.fluid.tank.FluidLoadingHandler;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEFluidPacket;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class FluidTank {
    public static final List<FluidLoadingHandler> loadingHandlers = new ArrayList<FluidLoadingHandler>();
    FluidType type;
    int fluid;
    int maxFluid;
    @Deprecated
    public int index = 0;
    int pressure = 0;

    public FluidTank(FluidType type, int maxFluid) {
        this.type = type;
        this.maxFluid = maxFluid;
    }

    public FluidTank withPressure(int pressure) {
        if (this.pressure != pressure) {
            this.setFill(0);
        }
        this.pressure = pressure;
        return this;
    }

    @Deprecated
    public FluidTank(FluidType type, int maxFluid, int index) {
        this.type = type;
        this.maxFluid = maxFluid;
        this.index = index;
    }

    public void setFill(int i) {
        this.fluid = i;
    }

    public void setTankType(FluidType type) {
        if (type == null) {
            type = Fluids.NONE;
        }
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.setFill(0);
    }

    public FluidType getTankType() {
        return this.type;
    }

    public int getFill() {
        return this.fluid;
    }

    public int getMaxFill() {
        return this.maxFluid;
    }

    public int getPressure() {
        return this.pressure;
    }

    public int changeTankSize(int size) {
        this.maxFluid = size;
        if (this.fluid > this.maxFluid) {
            int dif = this.fluid - this.maxFluid;
            this.fluid = this.maxFluid;
            return dif;
        }
        return 0;
    }

    @Deprecated
    public void updateTank(TileEntity te) {
        this.updateTank(te, 100);
    }

    @Deprecated
    public void updateTank(TileEntity te, int range) {
        this.updateTank(te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w().field_73011_w.field_76574_g, range);
    }

    @Deprecated
    public void updateTank(int x, int y, int z, int dim) {
        this.updateTank(x, y, z, dim, 100);
    }

    @Deprecated
    public void updateTank(int x, int y, int z, int dim, int range) {
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEFluidPacket(x, y, z, this.fluid, this.index, this.type), new NetworkRegistry.TargetPoint(dim, (double)x, (double)y, (double)z, (double)range));
    }

    public boolean loadTank(int in, int out, ItemStack[] slots) {
        if (slots[in] == null) {
            return false;
        }
        if (this.pressure != 0) {
            return false;
        }
        int prev = this.getFill();
        for (FluidLoadingHandler handler : loadingHandlers) {
            if (handler.emptyItem(slots, in, out, this)) break;
        }
        return this.getFill() > prev;
    }

    public boolean unloadTank(int in, int out, ItemStack[] slots) {
        if (slots[in] == null) {
            return false;
        }
        int prev = this.getFill();
        for (FluidLoadingHandler handler : loadingHandlers) {
            if (handler.fillItem(slots, in, out, this)) break;
        }
        return this.getFill() < prev;
    }

    public boolean setType(int in, ItemStack[] slots) {
        return this.setType(in, in, slots);
    }

    public boolean setType(int in, int out, ItemStack[] slots) {
        if (slots[in] != null && slots[in].func_77973_b() instanceof IItemFluidIdentifier) {
            FluidType newType;
            IItemFluidIdentifier id = (IItemFluidIdentifier)slots[in].func_77973_b();
            if (in == out) {
                FluidType newType2 = id.getType(null, 0, 0, 0, slots[in]);
                if (this.type != newType2) {
                    this.type = newType2;
                    this.fluid = 0;
                    return true;
                }
            } else if (slots[out] == null && this.type != (newType = id.getType(null, 0, 0, 0, slots[in]))) {
                this.type = newType;
                slots[out] = slots[in].func_77946_l();
                slots[in] = null;
                this.fluid = 0;
                return true;
            }
        }
        return false;
    }

    public void renderTank(int x, int y, double z, int width, int height) {
        GL11.glEnable((int)3042);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.type.getTexture());
        int i = this.fluid * height / this.maxFluid;
        double minX = x;
        double maxX = x + width;
        double minY = (y -= height) + (height - i);
        double maxY = y + height;
        double minV = 1.0 - (double)i / 16.0;
        double maxV = 1.0;
        double minU = 0.0;
        double maxU = (double)width / 16.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(minX, maxY, z, minU, maxV);
        tessellator.func_78374_a(maxX, maxY, z, maxU, maxV);
        tessellator.func_78374_a(maxX, minY, z, maxU, minV);
        tessellator.func_78374_a(minX, minY, z, minU, minV);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public void renderTankInfo(GuiInfoContainer gui, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (x <= mouseX && x + width > mouseX && y < mouseY && y + height >= mouseY) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.func_135052_a((String)this.type.getUnlocalizedName(), (Object[])new Object[0]));
            list.add(this.fluid + "/" + this.maxFluid + "mB");
            if (this.pressure != 0) {
                list.add(EnumChatFormatting.RED + "Pressure: " + this.pressure + " PU");
            }
            this.type.addInfo(list);
            gui.drawInfo(list.toArray(new String[0]), mouseX, mouseY);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String s) {
        nbt.func_74768_a(s, this.fluid);
        nbt.func_74768_a(s + "_max", this.maxFluid);
        nbt.func_74768_a(s + "_type", this.type.getID());
        nbt.func_74777_a(s + "_p", (short)this.pressure);
    }

    public void readFromNBT(NBTTagCompound nbt, String s) {
        this.fluid = nbt.func_74762_e(s);
        int max = nbt.func_74762_e(s + "_max");
        if (max > 0) {
            this.maxFluid = max;
        }
        this.fluid = MathHelper.func_76125_a((int)this.fluid, (int)0, (int)max);
        this.type = Fluids.fromName(nbt.func_74779_i(s + "_type"));
        if (this.type == Fluids.NONE) {
            this.type = Fluids.fromID(nbt.func_74762_e(s + "_type"));
        }
        this.pressure = nbt.func_74765_d(s + "_p");
    }

    static {
        loadingHandlers.add(new FluidLoaderStandard());
        loadingHandlers.add(new FluidLoaderFillableItem());
        loadingHandlers.add(new FluidLoaderInfinite());
    }
}

