/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.tank;

import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidLoadingHandler;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.machine.ItemInfiniteFluid;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class FluidLoaderInfinite
extends FluidLoadingHandler {
    private static Random rand = new Random();

    @Override
    public boolean fillItem(ItemStack[] slots, int in, int out, FluidTank tank) {
        if (slots[in] == null || !(slots[in].func_77973_b() instanceof ItemInfiniteFluid)) {
            return false;
        }
        ItemInfiniteFluid item = (ItemInfiniteFluid)slots[in].func_77973_b();
        if (item.getType() != null && tank.type != item.getType()) {
            return false;
        }
        if (item.getChance() <= 1 || rand.nextInt(item.getChance()) == 0) {
            tank.setFill(Math.max(tank.getFill() - item.getAmount(), 0));
        }
        return true;
    }

    @Override
    public boolean emptyItem(ItemStack[] slots, int in, int out, FluidTank tank) {
        if (slots[in] == null || !(slots[in].func_77973_b() instanceof ItemInfiniteFluid) || tank.getTankType() == Fluids.NONE) {
            return false;
        }
        ItemInfiniteFluid item = (ItemInfiniteFluid)slots[in].func_77973_b();
        if (item.getType() != null && tank.type != item.getType()) {
            return false;
        }
        if (item.getChance() <= 1 || rand.nextInt(item.getChance()) == 0) {
            tank.setFill(Math.min(tank.getFill() + item.getAmount(), tank.getMaxFill()));
        }
        return true;
    }
}

