/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid;

import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.render.util.EnumSymbol;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class FluidType {
    private int id;
    private String stringId;
    private int color;
    private String unlocalized;
    public int poison;
    public int flammability;
    public int reactivity;
    public EnumSymbol symbol;
    public static final int ROOM_TEMPERATURE = 20;
    public static final double DEFAULT_HEATCAP = 0.01;
    public static final double DEFAULT_COMPRESSION = 1.0;
    public int temperature = 20;
    public double compression = 1.0;
    public HashMap<Class, Object> containers = new HashMap();
    public HashMap<Class<? extends FluidTrait>, FluidTrait> traits = new HashMap();
    private ResourceLocation texture;

    public FluidType(String name, int color, int p, int f, int r, EnumSymbol symbol) {
        this.stringId = name;
        this.color = color;
        this.unlocalized = "hbmfluid." + name.toLowerCase(Locale.US);
        this.poison = p;
        this.flammability = f;
        this.reactivity = r;
        this.symbol = symbol;
        this.texture = new ResourceLocation("hbm:textures/gui/fluids/" + name.toLowerCase(Locale.US) + ".png");
        this.id = Fluids.registerSelf(this);
    }

    public FluidType(int forcedId, String name, int color, int p, int f, int r, EnumSymbol symbol) {
        this(name, color, p, f, r, symbol);
        if (this.id != forcedId) {
            throw new IllegalStateException("Howdy! I am a safeguard put into place by Bob to protect you, the player, from Bob's dementia. For whatever reason, Bob decided to either add or remove a fluid in a way that shifts the IDs, despite the entire system being built to prevent just that. Instead of people's fluids getting jumbled for the 500th time, I am here to prevent the game from starting entirely. The expected ID was " + forcedId + ", but turned out to be " + this.id + ".");
        }
    }

    public FluidType setTemp(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public FluidType setCompression(double compression) {
        this.compression = compression;
        return this;
    }

    public FluidType addContainers(Object ... containers) {
        for (Object container : containers) {
            this.containers.put(container.getClass(), container);
        }
        return this;
    }

    public <T> T getContainer(Class<? extends T> container) {
        return (T)this.containers.get(container);
    }

    public FluidType addTraits(FluidTrait ... traits) {
        for (FluidTrait trait : traits) {
            this.traits.put(trait.getClass(), trait);
        }
        return this;
    }

    public boolean hasTrait(Class<? extends FluidTrait> trait) {
        return this.traits.containsKey(trait);
    }

    public <T extends FluidTrait> T getTrait(Class<? extends T> trait) {
        return (T)this.traits.get(trait);
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.stringId;
    }

    public int getColor() {
        return this.color;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String getUnlocalizedName() {
        return this.unlocalized;
    }

    public String getDict(int quantity) {
        return "container" + quantity + this.stringId.replace("_", "").toLowerCase(Locale.US);
    }

    public boolean isHot() {
        return this.temperature >= 100;
    }

    public boolean isCorrosive() {
        return this.traits.containsKey(FT_Corrosive.class);
    }

    public boolean isAntimatter() {
        return this.traits.containsKey(FluidTraitSimple.FT_Amat.class);
    }

    public boolean hasNoContainer() {
        return this.traits.containsKey(FluidTraitSimple.FT_NoContainer.class);
    }

    public boolean hasNoID() {
        return this.traits.containsKey(FluidTraitSimple.FT_NoID.class);
    }

    public boolean needsLeadContainer() {
        return this.traits.containsKey(FluidTraitSimple.FT_LeadContainer.class);
    }

    public void onTankBroken(TileEntity te, FluidTank tank) {
    }

    public void onTankUpdate(TileEntity te, FluidTank tank) {
    }

    public void onFluidRelease(TileEntity te, FluidTank tank, int overflowAmount) {
        this.onFluidRelease(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, tank, overflowAmount);
    }

    public void onFluidRelease(World world, int x, int y, int z, FluidTank tank, int overflowAmount) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInfo(List<String> info) {
        if (this.temperature != 20) {
            if (this.temperature < 0) {
                info.add(EnumChatFormatting.BLUE + "" + this.temperature + "\u00b0C");
            }
            if (this.temperature > 0) {
                info.add(EnumChatFormatting.RED + "" + this.temperature + "\u00b0C");
            }
        }
        ArrayList<String> hidden = new ArrayList<String>();
        for (Map.Entry<Class<? extends FluidTrait>, FluidTrait> entry : this.traits.entrySet()) {
            entry.getValue().addInfo(info);
            entry.getValue().addInfoHidden(hidden);
        }
        if (!hidden.isEmpty()) {
            if (Keyboard.isKeyDown((int)42)) {
                info.addAll(hidden);
            } else {
                info.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "Hold <" + EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + "LSHIFT" + EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "> to display more info");
            }
        }
    }

    @Deprecated
    public static FluidType getEnum(int i) {
        return Fluids.fromID(i);
    }

    @Deprecated
    public static FluidType getEnumFromName(String s) {
        return Fluids.fromName(s);
    }

    @Deprecated
    public int ordinal() {
        return this.getID();
    }

    @Deprecated
    public int getMSAColor() {
        return this.color;
    }

    @Deprecated
    public String name() {
        return this.stringId;
    }
}

