/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.inventory.FluidContainer;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.util.Compat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class FluidContainerRegistry {
    public static List<FluidContainer> allContainers = new ArrayList<FluidContainer>();

    public static void register() {
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151133_ar), Fluids.WATER, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack((Item)Items.field_151068_bn), new ItemStack(Items.field_151069_bo), Fluids.WATER, 250));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(Items.field_151129_at), new ItemStack(Items.field_151133_ar), Fluids.LAVA, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.bucket_mud), new ItemStack(Items.field_151133_ar), Fluids.WATZ, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.bucket_schrabidic_acid), new ItemStack(Items.field_151133_ar), Fluids.SCHRABIDIC, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.bucket_sulfuric_acid), new ItemStack(Items.field_151133_ar), Fluids.SULFURIC_ACID, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModBlocks.red_barrel), new ItemStack(ModItems.tank_steel), Fluids.DIESEL, 10000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModBlocks.pink_barrel), new ItemStack(ModItems.tank_steel), Fluids.KEROSENE, 10000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModBlocks.lox_barrel), new ItemStack(ModItems.tank_steel), Fluids.OXYGEN, 10000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModBlocks.ore_oil), null, Fluids.OIL, 250));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModBlocks.ore_gneiss_gas), null, Fluids.PETROLEUM, GeneralConfig.enable528 ? 50 : 250));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.cell_deuterium), new ItemStack(ModItems.cell_empty), Fluids.DEUTERIUM, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.cell_tritium), new ItemStack(ModItems.cell_empty), Fluids.TRITIUM, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.cell_uf6), new ItemStack(ModItems.cell_empty), Fluids.UF6, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.cell_puf6), new ItemStack(ModItems.cell_empty), Fluids.PUF6, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.cell_antimatter), new ItemStack(ModItems.cell_empty), Fluids.AMAT, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.cell_anti_schrabidium), new ItemStack(ModItems.cell_empty), Fluids.ASCHRAB, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.cell_sas3), new ItemStack(ModItems.cell_empty), Fluids.SAS3, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.bottle_mercury), new ItemStack(Items.field_151069_bo), Fluids.MERCURY, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.ingot_mercury), null, Fluids.MERCURY, 125));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.rod_zirnox_tritium), new ItemStack(ModItems.rod_zirnox_empty), Fluids.TRITIUM, 2000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.particle_hydrogen), new ItemStack(ModItems.particle_empty), Fluids.HYDROGEN, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.particle_amat), new ItemStack(ModItems.particle_empty), Fluids.AMAT, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.particle_aschrab), new ItemStack(ModItems.particle_empty), Fluids.ASCHRAB, 1000));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.iv_blood), new ItemStack(ModItems.iv_empty), Fluids.BLOOD, 100));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.iv_xp), new ItemStack(ModItems.iv_xp_empty), Fluids.XPJUICE, 100));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(Items.field_151062_by), new ItemStack(Items.field_151069_bo), Fluids.XPJUICE, 100));
        FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.can_mug), new ItemStack(ModItems.can_empty), Fluids.MUG, 100));
        FluidType[] fluids = Fluids.getAll();
        for (int i = 1; i < fluids.length; ++i) {
            FluidType type = fluids[i];
            if (type.getContainer(Fluids.CD_Canister.class) != null) {
                FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.canister_full, 1, i), new ItemStack(ModItems.canister_empty), Fluids.fromID(i), 1000));
            }
            if (type.getContainer(Fluids.CD_Gastank.class) != null) {
                FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.gas_full, 1, i), new ItemStack(ModItems.gas_empty), Fluids.fromID(i), 1000));
            }
            if (type.hasNoContainer()) continue;
            FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.fluid_tank_lead_full, 1, i), new ItemStack(ModItems.fluid_tank_lead_empty), Fluids.fromID(i), 1000));
            if (type.needsLeadContainer()) continue;
            FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.fluid_tank_full, 1, i), new ItemStack(ModItems.fluid_tank_empty), Fluids.fromID(i), 1000));
            FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(ModItems.fluid_barrel_full, 1, i), new ItemStack(ModItems.fluid_barrel_empty), Fluids.fromID(i), 16000));
        }
        Compat.registerCompatFluidContainers();
    }

    public static void registerContainer(FluidContainer con) {
        allContainers.add(con);
        OreDictionary.registerOre((String)con.type.getDict(con.content), (ItemStack)con.fullContainer);
    }

    public static int getFluidContent(ItemStack stack, FluidType type) {
        if (stack == null) {
            return 0;
        }
        ItemStack sta = stack.func_77946_l();
        sta.field_77994_a = 1;
        for (FluidContainer container : allContainers) {
            if (container.type != type || !ItemStack.func_77989_b((ItemStack)container.fullContainer, (ItemStack)sta) || !ItemStack.func_77970_a((ItemStack)container.fullContainer, (ItemStack)sta)) continue;
            return container.content;
        }
        return 0;
    }

    public static FluidType getFluidType(ItemStack stack) {
        if (stack == null) {
            return Fluids.NONE;
        }
        ItemStack sta = stack.func_77946_l();
        sta.field_77994_a = 1;
        for (FluidContainer container : allContainers) {
            if (!ItemStack.func_77989_b((ItemStack)container.fullContainer, (ItemStack)sta) || !ItemStack.func_77970_a((ItemStack)container.fullContainer, (ItemStack)sta)) continue;
            return container.type;
        }
        return Fluids.NONE;
    }

    public static ItemStack getFullContainer(ItemStack stack, FluidType type) {
        if (stack == null) {
            return null;
        }
        ItemStack sta = stack.func_77946_l();
        sta.field_77994_a = 1;
        for (FluidContainer container : allContainers) {
            if (!ItemStack.func_77989_b((ItemStack)container.emptyContainer, (ItemStack)sta) || !ItemStack.func_77970_a((ItemStack)container.emptyContainer, (ItemStack)sta) || container.type != type) continue;
            return container.fullContainer.func_77946_l();
        }
        return null;
    }

    public static ItemStack getEmptyContainer(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack sta = stack.func_77946_l();
        sta.field_77994_a = 1;
        for (FluidContainer container : allContainers) {
            if (!ItemStack.func_77989_b((ItemStack)container.fullContainer, (ItemStack)sta) || !ItemStack.func_77970_a((ItemStack)container.fullContainer, (ItemStack)sta)) continue;
            return container.emptyContainer == null ? null : container.emptyContainer.func_77946_l();
        }
        return null;
    }
}

