/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.hazard.HazardData;
import com.hbm.hazard.HazardEntry;
import com.hbm.hazard.HazardSystem;
import com.hbm.hazard.modifier.HazardModifierFuelRadiation;
import com.hbm.hazard.modifier.HazardModifierRBMKHot;
import com.hbm.hazard.modifier.HazardModifierRBMKRadiation;
import com.hbm.hazard.modifier.HazardModifierRTGRadiation;
import com.hbm.hazard.transformer.HazardTransformerRadiationContainer;
import com.hbm.hazard.transformer.HazardTransformerRadiationME;
import com.hbm.hazard.transformer.HazardTransformerRadiationNBT;
import com.hbm.hazard.type.HazardTypeAsbestos;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.hazard.type.HazardTypeBlinding;
import com.hbm.hazard.type.HazardTypeCoal;
import com.hbm.hazard.type.HazardTypeDigamma;
import com.hbm.hazard.type.HazardTypeExplosive;
import com.hbm.hazard.type.HazardTypeHot;
import com.hbm.hazard.type.HazardTypeHydroactive;
import com.hbm.hazard.type.HazardTypeRadiation;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemBreedingRod;
import com.hbm.items.machine.ItemRTGPelletDepleted;
import com.hbm.items.machine.ItemWatzPellet;
import com.hbm.items.machine.ItemZirnoxRod;
import com.hbm.items.special.ItemHolotapeImage;
import com.hbm.util.Compat;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class HazardRegistry {
    public static final float gen_S = 10000.0f;
    public static final float gen_H = 2000.0f;
    public static final float gen_10D = 100.0f;
    public static final float gen_100D = 80.0f;
    public static final float gen_1Y = 50.0f;
    public static final float gen_10Y = 30.0f;
    public static final float gen_100Y = 10.0f;
    public static final float gen_1K = 7.5f;
    public static final float gen_10K = 6.25f;
    public static final float gen_100K = 5.0f;
    public static final float gen_1M = 2.5f;
    public static final float gen_10M = 1.5f;
    public static final float gen_100M = 1.0f;
    public static final float gen_1B = 0.5f;
    public static final float gen_10B = 0.1f;
    public static final float co60 = 30.0f;
    public static final float sr90 = 15.0f;
    public static final float tc99 = 2.75f;
    public static final float i131 = 150.0f;
    public static final float xe135 = 1250.0f;
    public static final float cs137 = 20.0f;
    public static final float au198 = 500.0f;
    public static final float pb209 = 10000.0f;
    public static final float at209 = 7500.0f;
    public static final float po210 = 75.0f;
    public static final float ra226 = 7.5f;
    public static final float ac227 = 30.0f;
    public static final float th232 = 0.1f;
    public static final float thf = 1.75f;
    public static final float u = 0.35f;
    public static final float u233 = 5.0f;
    public static final float u235 = 1.0f;
    public static final float u238 = 0.25f;
    public static final float uf = 0.5f;
    public static final float np237 = 2.5f;
    public static final float npf = 1.5f;
    public static final float pu = 7.5f;
    public static final float purg = 6.25f;
    public static final float pu238 = 10.0f;
    public static final float pu239 = 5.0f;
    public static final float pu240 = 7.5f;
    public static final float pu241 = 25.0f;
    public static final float puf = 4.25f;
    public static final float am241 = 8.5f;
    public static final float am242 = 9.5f;
    public static final float amrg = 9.0f;
    public static final float amf = 4.75f;
    public static final float mox = 2.5f;
    public static final float sa326 = 15.0f;
    public static final float sa327 = 17.5f;
    public static final float saf = 5.85f;
    public static final float sas3 = 5.0f;
    public static final float gh336 = 5.0f;
    public static final float mud = 1.0f;
    public static final float radsource_mult = 3.0f;
    public static final float pobe = 225.0f;
    public static final float rabe = 22.5f;
    public static final float pube = 30.0f;
    public static final float zfb_bi = 0.35f;
    public static final float zfb_pu241 = 12.5f;
    public static final float zfb_am_mix = 4.5f;
    public static final float bf = 300000.0f;
    public static final float bfb = 500000.0f;
    public static final float sr = 1.5f;
    public static final float sb = 1.5f;
    public static final float trx = 25.0f;
    public static final float trn = 0.1f;
    public static final float wst = 15.0f;
    public static final float wstv = 7.5f;
    public static final float yc = 0.35f;
    public static final float fo = 10.0f;
    public static final float nugget = 0.1f;
    public static final float ingot = 1.0f;
    public static final float gem = 1.0f;
    public static final float plate = 1.0f;
    public static final float plateCast = 3.0f;
    public static final float powder_mult = 3.0f;
    public static final float powder = 3.0f;
    public static final float powder_tiny = 0.3f;
    public static final float ore = 1.0f;
    public static final float block = 10.0f;
    public static final float crystal = 10.0f;
    public static final float billet = 0.5f;
    public static final float rtg = 1.5f;
    public static final float rod = 0.5f;
    public static final float rod_dual = 1.0f;
    public static final float rod_quad = 2.0f;
    public static final float rod_rbmk = 4.0f;
    public static final HazardTypeBase RADIATION = new HazardTypeRadiation();
    public static final HazardTypeBase DIGAMMA = new HazardTypeDigamma();
    public static final HazardTypeBase HOT = new HazardTypeHot();
    public static final HazardTypeBase BLINDING = new HazardTypeBlinding();
    public static final HazardTypeBase ASBESTOS = new HazardTypeAsbestos();
    public static final HazardTypeBase COAL = new HazardTypeCoal();
    public static final HazardTypeBase HYDROACTIVE = new HazardTypeHydroactive();
    public static final HazardTypeBase EXPLOSIVE = new HazardTypeExplosive();

    public static void registerItems() {
        HazardSystem.register(Items.field_151016_H, HazardRegistry.makeData(EXPLOSIVE, 1.0f));
        HazardSystem.register(Blocks.field_150335_W, HazardRegistry.makeData(EXPLOSIVE, 4.0f));
        HazardSystem.register(Items.field_151158_bO, HazardRegistry.makeData(EXPLOSIVE, 1.0f));
        HazardSystem.register(ModItems.ball_dynamite, HazardRegistry.makeData(EXPLOSIVE, 2.0f));
        HazardSystem.register(ModItems.stick_dynamite, HazardRegistry.makeData(EXPLOSIVE, 1.0f));
        HazardSystem.register(ModItems.stick_tnt, HazardRegistry.makeData(EXPLOSIVE, 1.5f));
        HazardSystem.register(ModItems.stick_semtex, HazardRegistry.makeData(EXPLOSIVE, 2.5f));
        HazardSystem.register(ModItems.stick_c4, HazardRegistry.makeData(EXPLOSIVE, 2.5f));
        HazardSystem.register(ModItems.cordite, HazardRegistry.makeData(EXPLOSIVE, 2.0f));
        HazardSystem.register(ModItems.ballistite, HazardRegistry.makeData(EXPLOSIVE, 1.0f));
        HazardSystem.register("dustCoal", HazardRegistry.makeData(COAL, 3.0f));
        HazardSystem.register("dustTinyCoal", HazardRegistry.makeData(COAL, 0.3f));
        HazardSystem.register("dustLignite", HazardRegistry.makeData(COAL, 3.0f));
        HazardSystem.register("dustTinyLignite", HazardRegistry.makeData(COAL, 0.3f));
        HazardSystem.register(ModItems.insert_polonium, HazardRegistry.makeData(RADIATION, 100.0f));
        HazardSystem.register(ModItems.demon_core_open, HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(ModItems.demon_core_closed, HazardRegistry.makeData(RADIATION, 100000.0f));
        HazardSystem.register(ModBlocks.lamp_demon, HazardRegistry.makeData(RADIATION, 100000.0f));
        HazardSystem.register(ModItems.cell_tritium, HazardRegistry.makeData(RADIATION, 0.001f));
        HazardSystem.register(ModItems.cell_sas3, HazardRegistry.makeData().addEntry(RADIATION, 5.0f).addEntry(BLINDING, 60.0f));
        HazardSystem.register(ModItems.cell_balefire, HazardRegistry.makeData(RADIATION, 50.0f));
        HazardSystem.register(ModItems.powder_balefire, HazardRegistry.makeData(RADIATION, 500.0f));
        HazardSystem.register(ModItems.egg_balefire_shard, HazardRegistry.makeData(RADIATION, 30000.0f));
        HazardSystem.register(ModItems.egg_balefire, HazardRegistry.makeData(RADIATION, 300000.0f));
        HazardSystem.register(ModItems.solid_fuel_bf, HazardRegistry.makeData(RADIATION, 1000.0f));
        HazardSystem.register(ModItems.solid_fuel_presto_bf, HazardRegistry.makeData(RADIATION, 2000.0f));
        HazardSystem.register(ModItems.solid_fuel_presto_triplet_bf, HazardRegistry.makeData(RADIATION, 6000.0f));
        HazardSystem.register(ModItems.nuclear_waste_long, HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(ModItems.nuclear_waste_long_tiny, HazardRegistry.makeData(RADIATION, 0.5f));
        HazardSystem.register(ModItems.nuclear_waste_short, HazardRegistry.makeData().addEntry(RADIATION, 30.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.nuclear_waste_short_tiny, HazardRegistry.makeData().addEntry(RADIATION, 3.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.nuclear_waste_long_depleted, HazardRegistry.makeData(RADIATION, 0.5f));
        HazardSystem.register(ModItems.nuclear_waste_long_depleted_tiny, HazardRegistry.makeData(RADIATION, 0.05f));
        HazardSystem.register(ModItems.nuclear_waste_short_depleted, HazardRegistry.makeData(RADIATION, 3.0f));
        HazardSystem.register(ModItems.nuclear_waste_short_depleted_tiny, HazardRegistry.makeData(RADIATION, 0.3f));
        HazardSystem.register(ModItems.scrap_nuclear, HazardRegistry.makeData(RADIATION, 1.0f));
        HazardSystem.register(ModItems.trinitite, HazardRegistry.makeData(RADIATION, 0.1f));
        HazardSystem.register(ModBlocks.block_trinitite, HazardRegistry.makeData(RADIATION, 1.0f));
        HazardSystem.register(ModItems.nuclear_waste, HazardRegistry.makeData(RADIATION, 15.0f));
        HazardSystem.register(ModBlocks.yellow_barrel, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModItems.billet_nuclear_waste, HazardRegistry.makeData(RADIATION, 7.5f));
        HazardSystem.register(ModItems.nuclear_waste_tiny, HazardRegistry.makeData(RADIATION, 1.5f));
        HazardSystem.register(ModItems.nuclear_waste_vitrified, HazardRegistry.makeData(RADIATION, 7.5f));
        HazardSystem.register(ModItems.nuclear_waste_vitrified_tiny, HazardRegistry.makeData(RADIATION, 0.75f));
        HazardSystem.register(ModBlocks.block_waste, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModBlocks.block_waste_painted, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModBlocks.block_waste_vitrified, HazardRegistry.makeData(RADIATION, 75.0f));
        HazardSystem.register(ModBlocks.ancient_scrap, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModBlocks.block_corium, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModBlocks.block_corium_cobble, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModBlocks.sand_gold198, HazardRegistry.makeData(RADIATION, 15000.0f));
        HazardSystem.register(new ItemStack(ModBlocks.sellafield, 1, 0), HazardRegistry.makeData(RADIATION, 0.5f));
        HazardSystem.register(new ItemStack(ModBlocks.sellafield, 1, 1), HazardRegistry.makeData(RADIATION, 1.0f));
        HazardSystem.register(new ItemStack(ModBlocks.sellafield, 1, 2), HazardRegistry.makeData(RADIATION, 2.5f));
        HazardSystem.register(new ItemStack(ModBlocks.sellafield, 1, 3), HazardRegistry.makeData(RADIATION, 4.0f));
        HazardSystem.register(new ItemStack(ModBlocks.sellafield, 1, 4), HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(new ItemStack(ModBlocks.sellafield, 1, 5), HazardRegistry.makeData(RADIATION, 10.0f));
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.NATURAL_URANIUM_FUEL.ordinal(), 0.35f, 172.5f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.URANIUM_FUEL.ordinal(), 0.5f, 150.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.TH232.ordinal(), 0.1f, 1.75f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.THORIUM_FUEL.ordinal(), 1.75f, 112.5f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.MOX_FUEL.ordinal(), 2.5f, 150.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.PLUTONIUM_FUEL.ordinal(), 4.25f, 187.5f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.U233_FUEL.ordinal(), 5.0f, 150.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.U235_FUEL.ordinal(), 1.0f, 165.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.LES_FUEL.ordinal(), 5.85f, 225.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.LITHIUM.ordinal(), 0.0f, 0.001f, false);
        HazardRegistry.registerOtherFuel(ModItems.rod_zirnox, ItemZirnoxRod.EnumZirnoxType.ZFB_MOX.ordinal(), 2.5f, 75.0f, false);
        HazardSystem.register(ModItems.rod_zirnox_natural_uranium_fuel_depleted, HazardRegistry.makeData(RADIATION, 172.5f));
        HazardSystem.register(ModItems.rod_zirnox_uranium_fuel_depleted, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModItems.rod_zirnox_thorium_fuel_depleted, HazardRegistry.makeData(RADIATION, 112.5f));
        HazardSystem.register(ModItems.rod_zirnox_mox_fuel_depleted, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModItems.rod_zirnox_plutonium_fuel_depleted, HazardRegistry.makeData(RADIATION, 187.5f));
        HazardSystem.register(ModItems.rod_zirnox_u233_fuel_depleted, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModItems.rod_zirnox_u235_fuel_depleted, HazardRegistry.makeData(RADIATION, 165.0f));
        HazardSystem.register(ModItems.rod_zirnox_les_fuel_depleted, HazardRegistry.makeData().addEntry(RADIATION, 225.0f).addEntry(BLINDING, 20.0f));
        HazardSystem.register(ModItems.rod_zirnox_tritium, HazardRegistry.makeData(RADIATION, 0.001f));
        HazardSystem.register(ModItems.rod_zirnox_zfb_mox_depleted, HazardRegistry.makeData(RADIATION, 75.0f));
        HazardRegistry.registerOtherWaste(ModItems.waste_natural_uranium, 86.25f);
        HazardRegistry.registerOtherWaste(ModItems.waste_uranium, 75.0f);
        HazardRegistry.registerOtherWaste(ModItems.waste_thorium, 56.25f);
        HazardRegistry.registerOtherWaste(ModItems.waste_mox, 75.0f);
        HazardRegistry.registerOtherWaste(ModItems.waste_plutonium, 93.75f);
        HazardRegistry.registerOtherWaste(ModItems.waste_u233, 75.0f);
        HazardRegistry.registerOtherWaste(ModItems.waste_u235, 82.5f);
        HazardRegistry.registerOtherWaste(ModItems.waste_schrabidium, 112.5f);
        HazardRegistry.registerOtherWaste(ModItems.waste_zfb_mox, 37.5f);
        HazardRegistry.registerOtherFuel(ModItems.pellet_schrabidium, 75.0f, 1500.0f, true);
        HazardRegistry.registerOtherFuel(ModItems.pellet_hes, 29.25f, 1125.0f, true);
        HazardRegistry.registerOtherFuel(ModItems.pellet_mes, 29.25f, 750.0f, true);
        HazardRegistry.registerOtherFuel(ModItems.pellet_les, 29.25f, 300.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.pellet_beryllium, 0.0f, 10.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.pellet_neptunium, 12.5f, 150.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.pellet_lead, 0.0f, 15.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.pellet_advanced, 0.0f, 20.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.plate_fuel_u233, 5.0f, 195.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.plate_fuel_u235, 1.0f, 150.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.plate_fuel_mox, 2.5f, 240.0f, false);
        HazardRegistry.registerOtherFuel(ModItems.plate_fuel_pu239, 5.0f, 202.5f, false);
        HazardRegistry.registerOtherFuel(ModItems.plate_fuel_sa326, 15.0f, 150.0f, true);
        HazardRegistry.registerOtherFuel(ModItems.plate_fuel_ra226be, 11.25f, 67.5f, false);
        HazardRegistry.registerOtherFuel(ModItems.plate_fuel_pu238be, 15.0f, 3.0f, false);
        HazardRegistry.registerOtherWaste(ModItems.waste_plate_u233, 195.0f);
        HazardRegistry.registerOtherWaste(ModItems.waste_plate_u235, 150.0f);
        HazardRegistry.registerOtherWaste(ModItems.waste_plate_mox, 240.0f);
        HazardRegistry.registerOtherWaste(ModItems.waste_plate_pu239, 202.5f);
        HazardRegistry.registerOtherWaste(ModItems.waste_plate_sa326, 150.0f);
        HazardRegistry.registerRadSourceWaste(ModItems.waste_plate_ra226be, 67.5f);
        HazardRegistry.registerRadSourceWaste(ModItems.waste_plate_pu238be, 3.0f);
        HazardSystem.register(ModItems.debris_graphite, HazardRegistry.makeData().addEntry(RADIATION, 70.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.debris_metal, HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(ModItems.debris_fuel, HazardRegistry.makeData().addEntry(RADIATION, 500.0f).addEntry(HOT, 5.0f));
        HazardSystem.register(ModItems.debris_concrete, HazardRegistry.makeData(RADIATION, 30.0f));
        HazardSystem.register(ModItems.debris_exchanger, HazardRegistry.makeData(RADIATION, 25.0f));
        HazardSystem.register(ModItems.debris_shrapnel, HazardRegistry.makeData(RADIATION, 2.5f));
        HazardSystem.register(ModItems.debris_element, HazardRegistry.makeData(RADIATION, 100.0f));
        HazardSystem.register(ModItems.nugget_uranium_fuel, HazardRegistry.makeData(RADIATION, 0.05f));
        HazardSystem.register(ModItems.billet_uranium_fuel, HazardRegistry.makeData(RADIATION, 0.25f));
        HazardSystem.register(ModItems.ingot_uranium_fuel, HazardRegistry.makeData(RADIATION, 0.5f));
        HazardSystem.register(ModBlocks.block_uranium_fuel, HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(ModItems.nugget_plutonium_fuel, HazardRegistry.makeData(RADIATION, 0.425f));
        HazardSystem.register(ModItems.billet_plutonium_fuel, HazardRegistry.makeData(RADIATION, 2.125f));
        HazardSystem.register(ModItems.ingot_plutonium_fuel, HazardRegistry.makeData(RADIATION, 4.25f));
        HazardSystem.register(ModBlocks.block_plutonium_fuel, HazardRegistry.makeData(RADIATION, 42.5f));
        HazardSystem.register(ModItems.nugget_thorium_fuel, HazardRegistry.makeData(RADIATION, 0.175f));
        HazardSystem.register(ModItems.billet_thorium_fuel, HazardRegistry.makeData(RADIATION, 0.875f));
        HazardSystem.register(ModItems.ingot_thorium_fuel, HazardRegistry.makeData(RADIATION, 1.75f));
        HazardSystem.register(ModBlocks.block_thorium_fuel, HazardRegistry.makeData(RADIATION, 17.5f));
        HazardSystem.register(ModItems.nugget_neptunium_fuel, HazardRegistry.makeData(RADIATION, 0.15f));
        HazardSystem.register(ModItems.billet_neptunium_fuel, HazardRegistry.makeData(RADIATION, 0.75f));
        HazardSystem.register(ModItems.ingot_neptunium_fuel, HazardRegistry.makeData(RADIATION, 1.5f));
        HazardSystem.register(ModItems.nugget_mox_fuel, HazardRegistry.makeData(RADIATION, 0.25f));
        HazardSystem.register(ModItems.billet_mox_fuel, HazardRegistry.makeData(RADIATION, 1.25f));
        HazardSystem.register(ModItems.ingot_mox_fuel, HazardRegistry.makeData(RADIATION, 2.5f));
        HazardSystem.register(ModBlocks.block_mox_fuel, HazardRegistry.makeData(RADIATION, 25.0f));
        HazardSystem.register(ModItems.nugget_americium_fuel, HazardRegistry.makeData(RADIATION, 0.475f));
        HazardSystem.register(ModItems.billet_americium_fuel, HazardRegistry.makeData(RADIATION, 2.375f));
        HazardSystem.register(ModItems.ingot_americium_fuel, HazardRegistry.makeData(RADIATION, 4.75f));
        HazardSystem.register(ModItems.nugget_schrabidium_fuel, HazardRegistry.makeData().addEntry(RADIATION, 0.585f).addEntry(BLINDING, 0.5f));
        HazardSystem.register(ModItems.billet_schrabidium_fuel, HazardRegistry.makeData().addEntry(RADIATION, 2.925f).addEntry(BLINDING, 2.5f));
        HazardSystem.register(ModItems.ingot_schrabidium_fuel, HazardRegistry.makeData().addEntry(RADIATION, 5.85f).addEntry(BLINDING, 5.0f));
        HazardSystem.register(ModBlocks.block_schrabidium_fuel, HazardRegistry.makeData().addEntry(RADIATION, 58.5f).addEntry(BLINDING, 50.0f));
        HazardSystem.register(ModItems.nugget_hes, HazardRegistry.makeData(RADIATION, 0.585f));
        HazardSystem.register(ModItems.billet_hes, HazardRegistry.makeData(RADIATION, 2.925f));
        HazardSystem.register(ModItems.ingot_hes, HazardRegistry.makeData(RADIATION, 5.85f));
        HazardSystem.register(ModItems.nugget_les, HazardRegistry.makeData(RADIATION, 0.585f));
        HazardSystem.register(ModItems.billet_les, HazardRegistry.makeData(RADIATION, 2.925f));
        HazardSystem.register(ModItems.ingot_les, HazardRegistry.makeData(RADIATION, 5.85f));
        HazardSystem.register(ModItems.billet_balefire_gold, HazardRegistry.makeData(RADIATION, 250.0f));
        HazardSystem.register(ModItems.billet_flashlead, HazardRegistry.makeData().addEntry(RADIATION, 6250.0f).addEntry(HOT, 7.0f));
        HazardSystem.register(ModItems.billet_po210be, HazardRegistry.makeData(RADIATION, 112.5f));
        HazardSystem.register(ModItems.billet_ra226be, HazardRegistry.makeData(RADIATION, 11.25f));
        HazardSystem.register(ModItems.billet_pu238be, HazardRegistry.makeData(RADIATION, 15.0f));
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg, 15.0f, 0.0f, 3.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_radium, 11.25f, 0.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_weak, 5.25f, 0.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_strontium, 22.5f, 0.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_cobalt, 45.0f, 0.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_actinium, 45.0f, 0.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_polonium, 112.5f, 0.0f, 3.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_lead, 15000.0f, 0.0f, 7.0f, 50.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_gold, 750.0f, 0.0f, 5.0f);
        HazardRegistry.registerRTGPellet(ModItems.pellet_rtg_americium, 12.75f, 0.0f);
        HazardSystem.register(new ItemStack(ModItems.pellet_rtg_depleted, 1, ItemRTGPelletDepleted.DepletedRTGMaterial.NEPTUNIUM.ordinal()), HazardRegistry.makeData(RADIATION, 3.75f));
        HazardSystem.register(ModItems.pile_rod_uranium, HazardRegistry.makeData(RADIATION, 0.525f));
        HazardSystem.register(ModItems.pile_rod_pu239, HazardRegistry.makeData(RADIATION, !GeneralConfig.enable528 ? 5.8f : 13.125f));
        HazardSystem.register(ModItems.pile_rod_plutonium, HazardRegistry.makeData(RADIATION, !GeneralConfig.enable528 ? 6.425f : 13.75f));
        HazardSystem.register(ModItems.pile_rod_source, HazardRegistry.makeData(RADIATION, 33.75f));
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.TRITIUM, 0.001f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.CO60, 30.0f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.RA226, 7.5f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.AC227, 30.0f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.TH232, 0.1f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.THF, 1.75f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.U235, 1.0f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.NP237, 2.5f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.U238, 0.25f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.PU238, 10.0f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.PU239, 5.0f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.RGP, 6.25f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.WASTE, 15.0f);
        HazardRegistry.registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType.URANIUM, 0.35f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_ueu, 1.4f, 1200.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_meu, 2.0f, 1290.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_heu233, 20.0f, 1860.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_heu235, 4.0f, 1800.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_thmeu, 7.0f, 1050.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_lep, 17.0f, 1500.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_mep, 25.0f, 1800.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_hep239, 20.0f, 1950.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_hep241, 100.0f, 2100.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_lea, 19.0f, 1560.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_mea, 36.0f, 1830.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_hea241, 34.0f, 2010.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_hea242, 38.0f, 2040.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_men, 6.0f, 1350.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_hen, 10.0f, 1800.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_mox, 10.0f, 1530.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_les, 23.4f, 1470.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_mes, 23.4f, 1800.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_hes, 23.4f, 3000.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_leaus, 0.0f, 2250.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_heaus, 0.0f, 1950.0f);
        HazardRegistry.registerRBMKRod((Item)ModItems.rbmk_fuel_po210be, 900.0f, 90.0f, true);
        HazardRegistry.registerRBMKRod((Item)ModItems.rbmk_fuel_ra226be, 90.0f, 36.0f, true);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_pu238be, 120.0f, 150.0f);
        HazardRegistry.registerRBMKRod((Item)ModItems.rbmk_fuel_balefire_gold, 2000.0f, 600000.0f, true);
        HazardRegistry.registerRBMKRod((Item)ModItems.rbmk_fuel_flashlead, 50000.0f, 200.0f, true);
        HazardRegistry.registerRBMKRod((Item)ModItems.rbmk_fuel_balefire, 1200000.0f, 1.2E8f, true);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_zfb_bismuth, 10.0f, 300.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_zfb_pu241, 2.0f, 450.0f);
        HazardRegistry.registerRBMKRod(ModItems.rbmk_fuel_zfb_am_mix, 10.0f, 600.0f);
        HazardRegistry.registerRBMK(ModItems.rbmk_fuel_drx, 1200000.0f, 1.2E8f, true, true, 0.0f, 0.33333334f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_ueu, 0.175f, 150.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_meu, 0.25f, 161.25f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_heu233, 2.5f, 232.5f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_heu235, 0.5f, 225.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_thmeu, 0.875f, 131.25f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_lep, 2.125f, 187.5f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_mep, 3.125f, 225.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_hep239, 2.5f, 243.75f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_hep241, 12.5f, 262.5f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_lea, 2.375f, 195.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_mea, 4.5f, 228.75f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_hea241, 4.25f, 251.25f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_hea242, 4.75f, 255.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_men, 0.75f, 168.75f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_hen, 1.25f, 225.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_mox, 1.25f, 191.25f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_les, 2.925f, 183.75f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_mes, 2.925f, 225.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_hes, 2.925f, 375.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_leaus, 0.0f, 281.25f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_heaus, 0.0f, 243.75f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_po210be, 112.5f, 11.25f, true);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_ra226be, 11.25f, 4.5f, true);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_pu238be, 15.0f, 22.5f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_balefire_gold, 250.0f, 75000.0f, true);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_flashlead, 6250.0f, 50.0f, true);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_balefire, 150000.0f, 1.5E7f, true);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_zfb_bismuth, 1.25f, 37.5f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_zfb_pu241, 0.25f, 56.25f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_zfb_am_mix, 1.25f, 75.0f);
        HazardRegistry.registerRBMKPellet(ModItems.rbmk_pellet_drx, 150000.0f, 1.5E7f, true, 0.0f, 0.041666668f);
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.SCHRABIDIUM), HazardRegistry.makeData(RADIATION, 60.0f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.HES), HazardRegistry.makeData(RADIATION, 23.4f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.MES), HazardRegistry.makeData(RADIATION, 23.4f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.LES), HazardRegistry.makeData(RADIATION, 23.4f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.HEN), HazardRegistry.makeData(RADIATION, 10.0f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.MEU), HazardRegistry.makeData(RADIATION, 2.0f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.MEP), HazardRegistry.makeData(RADIATION, 25.0f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.DU), HazardRegistry.makeData(RADIATION, 1.0f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.NQD), HazardRegistry.makeData(RADIATION, 4.0f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.watz_pellet, (Enum)ItemWatzPellet.EnumWatzType.NQR), HazardRegistry.makeData(RADIATION, 20.0f));
        HazardSystem.register(ModItems.powder_yellowcake, HazardRegistry.makeData(RADIATION, 1.05f));
        HazardSystem.register(ModBlocks.block_yellowcake, HazardRegistry.makeData(RADIATION, 10.5f));
        HazardSystem.register(ModItems.fallout, HazardRegistry.makeData(RADIATION, 30.0f));
        HazardSystem.register(ModBlocks.fallout, HazardRegistry.makeData(RADIATION, 60.0f));
        HazardSystem.register(ModBlocks.block_fallout, HazardRegistry.makeData(RADIATION, 10.5f));
        HazardSystem.register(ModItems.powder_caesium, HazardRegistry.makeData().addEntry(HYDROACTIVE, 1.0f).addEntry(HOT, 3.0f));
        HazardSystem.register(ModItems.wire_schrabidium, HazardRegistry.makeData(RADIATION, 1.5f));
        HazardSystem.register(ModBlocks.brick_asbestos, HazardRegistry.makeData(ASBESTOS, 1.0f));
        HazardSystem.register(ModBlocks.tile_lab_broken, HazardRegistry.makeData(ASBESTOS, 1.0f));
        HazardSystem.register(ModItems.powder_coltan_ore, HazardRegistry.makeData(ASBESTOS, 3.0f));
        HazardSystem.register(ModItems.crystal_uranium, HazardRegistry.makeData(RADIATION, 3.5f));
        HazardSystem.register(ModItems.crystal_thorium, HazardRegistry.makeData(RADIATION, 1.0f));
        HazardSystem.register(ModItems.crystal_plutonium, HazardRegistry.makeData(RADIATION, 75.0f));
        HazardSystem.register(ModItems.crystal_schraranium, HazardRegistry.makeData(RADIATION, 15.0f));
        HazardSystem.register(ModItems.crystal_schrabidium, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(ModItems.crystal_phosphorus, HazardRegistry.makeData(HOT, 20.0f));
        HazardSystem.register(ModItems.crystal_lithium, HazardRegistry.makeData(HYDROACTIVE, 10.0f));
        HazardSystem.register(ModItems.crystal_trixite, HazardRegistry.makeData(RADIATION, 250.0f));
        HazardSystem.register(ModItems.boy_propellant, HazardRegistry.makeData(EXPLOSIVE, 2.0f));
        HazardSystem.register(ModItems.gadget_core, HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(ModItems.boy_target, HazardRegistry.makeData(RADIATION, 2.0f));
        HazardSystem.register(ModItems.boy_bullet, HazardRegistry.makeData(RADIATION, 1.0f));
        HazardSystem.register(ModItems.man_core, HazardRegistry.makeData(RADIATION, 5.0f));
        HazardSystem.register(ModItems.mike_core, HazardRegistry.makeData(RADIATION, 0.25f));
        HazardSystem.register(ModItems.tsar_core, HazardRegistry.makeData(RADIATION, 7.5f));
        HazardSystem.register(ModItems.fleija_propellant, HazardRegistry.makeData().addEntry(RADIATION, 15.0f).addEntry(EXPLOSIVE, 8.0f).addEntry(BLINDING, 50.0f));
        HazardSystem.register(ModItems.fleija_core, HazardRegistry.makeData(RADIATION, 10.0f));
        HazardSystem.register(ModItems.solinium_propellant, HazardRegistry.makeData(EXPLOSIVE, 10.0f));
        HazardSystem.register(ModItems.solinium_core, HazardRegistry.makeData().addEntry(RADIATION, 14.0f).addEntry(BLINDING, 45.0f));
        HazardSystem.register(ModBlocks.nuke_fstbmb, HazardRegistry.makeData(DIGAMMA, 0.01f));
        HazardSystem.register(OreDictManager.DictFrame.fromOne(ModItems.holotape_image, (Enum)ItemHolotapeImage.EnumHoloImage.HOLO_RESTORED), HazardRegistry.makeData(DIGAMMA, 1.0f));
        HazardSystem.register(ModItems.holotape_damaged, HazardRegistry.makeData(DIGAMMA, 1000.0f));
        for (String ore : OreDictManager.TH232.ores()) {
            HazardSystem.blacklist(ore);
        }
        for (String ore : OreDictManager.U.ores()) {
            HazardSystem.blacklist(ore);
        }
        Item recWaste = Compat.tryLoadItem("ReactorCraft", "reactorcraft_item_waste");
        if (recWaste != null) {
            for (Compat.ReikaIsotope i : Compat.ReikaIsotope.values()) {
                if (!(i.getRad() > 0.0f)) continue;
                HazardSystem.register(new ItemStack(recWaste, 1, i.ordinal()), HazardRegistry.makeData(RADIATION, i.getRad()));
            }
        }
        if (Compat.isModLoaded("gregtech")) {
            Object[][] data = new Object[][]{{"Naquadah", Float.valueOf(0.35f)}, {"Naquadah-Enriched", Float.valueOf(1.0f)}, {"Naquadria", Float.valueOf(5.0f)}};
            for (MaterialShapes shape : MaterialShapes.allShapes) {
                for (String prefix : shape.prefixes) {
                    for (Object[] o : data) {
                        HazardSystem.register(prefix + o[0], new HazardData().setMutex(1).addEntry(new HazardEntry(RADIATION, ((Float)o[1]).floatValue() * (float)shape.q(1) / (float)MaterialShapes.INGOT.q(1))));
                    }
                }
            }
        }
    }

    public static void registerTrafos() {
        HazardSystem.trafos.add(new HazardTransformerRadiationNBT());
        if (!GeneralConfig.enableLBSM || !GeneralConfig.enableLBSMSafeCrates) {
            HazardSystem.trafos.add(new HazardTransformerRadiationContainer());
        }
        if (!GeneralConfig.enableLBSM || !GeneralConfig.enableLBSMSafeMEDrives) {
            HazardSystem.trafos.add(new HazardTransformerRadiationME());
        }
    }

    private static HazardData makeData() {
        return new HazardData();
    }

    private static HazardData makeData(HazardTypeBase hazard) {
        return new HazardData().addEntry(hazard);
    }

    private static HazardData makeData(HazardTypeBase hazard, float level) {
        return new HazardData().addEntry(hazard, level);
    }

    private static HazardData makeData(HazardTypeBase hazard, float level, boolean override) {
        return new HazardData().addEntry(hazard, level, override);
    }

    private static void registerRBMKPellet(Item pellet, float base, float dep) {
        HazardRegistry.registerRBMKPellet(pellet, base, dep, false, 0.0f, 0.0f);
    }

    private static void registerRBMKPellet(Item pellet, float base, float dep, boolean linear) {
        HazardRegistry.registerRBMKPellet(pellet, base, dep, linear, 0.0f, 0.0f);
    }

    private static void registerRBMKPellet(Item pellet, float base, float dep, boolean linear, float blinding, float digamma) {
        HazardData data = new HazardData();
        data.addEntry(new HazardEntry(RADIATION, base).addMod(new HazardModifierRBMKRadiation(dep, linear)));
        if (blinding > 0.0f) {
            data.addEntry(new HazardEntry(BLINDING, blinding));
        }
        if (digamma > 0.0f) {
            data.addEntry(new HazardEntry(DIGAMMA, digamma));
        }
        HazardSystem.register(pellet, data);
    }

    private static void registerRBMKRod(Item rod, float base, float dep) {
        HazardRegistry.registerRBMK(rod, base, dep, true, false, 0.0f, 0.0f);
    }

    private static void registerRBMKRod(Item rod, float base, float dep, float blinding) {
        HazardRegistry.registerRBMK(rod, base, dep, true, false, blinding, 0.0f);
    }

    private static void registerRBMKRod(Item rod, float base, float dep, boolean linear) {
        HazardRegistry.registerRBMK(rod, base, dep, true, linear, 0.0f, 0.0f);
    }

    private static void registerRBMK(Item rod, float base, float dep, boolean hot, boolean linear, float blinding, float digamma) {
        HazardData data = new HazardData();
        data.addEntry(new HazardEntry(RADIATION, base).addMod(new HazardModifierRBMKRadiation(dep, linear)));
        if (hot) {
            data.addEntry(new HazardEntry(HOT, 0.0f).addMod(new HazardModifierRBMKHot()));
        }
        if (blinding > 0.0f) {
            data.addEntry(new HazardEntry(BLINDING, blinding));
        }
        if (digamma > 0.0f) {
            data.addEntry(new HazardEntry(DIGAMMA, digamma));
        }
        HazardSystem.register(rod, data);
    }

    private static void registerBreedingRodRadiation(ItemBreedingRod.BreedingRodType type, float base) {
        HazardSystem.register(new ItemStack(ModItems.rod, 1, type.ordinal()), HazardRegistry.makeData(RADIATION, base));
        HazardSystem.register(new ItemStack(ModItems.rod_dual, 1, type.ordinal()), HazardRegistry.makeData(RADIATION, base * 1.0f));
        HazardSystem.register(new ItemStack(ModItems.rod_quad, 1, type.ordinal()), HazardRegistry.makeData(RADIATION, base * 2.0f));
    }

    private static void registerOtherFuel(Item fuel, float base, float target, boolean blinding) {
        HazardData data = new HazardData();
        data.addEntry(new HazardEntry(RADIATION, base).addMod(new HazardModifierFuelRadiation(target)));
        if (blinding) {
            data.addEntry(BLINDING, 20.0f);
        }
        HazardSystem.register(fuel, data);
    }

    private static void registerOtherFuel(Item fuel, int meta, float base, float target, boolean blinding) {
        HazardData data = new HazardData();
        data.addEntry(new HazardEntry(RADIATION, base).addMod(new HazardModifierFuelRadiation(target)));
        if (blinding) {
            data.addEntry(BLINDING, 20.0f);
        }
        HazardSystem.register(new ItemStack(fuel, 1, meta), data);
    }

    private static void registerRTGPellet(Item pellet, float base, float target) {
        HazardRegistry.registerRTGPellet(pellet, base, target, 0.0f, 0.0f);
    }

    private static void registerRTGPellet(Item pellet, float base, float target, float hot) {
        HazardRegistry.registerRTGPellet(pellet, base, target, hot, 0.0f);
    }

    private static void registerRTGPellet(Item pellet, float base, float target, float hot, float blinding) {
        HazardData data = new HazardData();
        data.addEntry(new HazardEntry(RADIATION, base).addMod(new HazardModifierRTGRadiation(target)));
        if (hot > 0.0f) {
            data.addEntry(new HazardEntry(HOT, hot));
        }
        if (blinding > 0.0f) {
            data.addEntry(new HazardEntry(BLINDING, blinding));
        }
        HazardSystem.register(pellet, data);
    }

    private static void registerOtherWaste(Item waste, float base) {
        HazardSystem.register(new ItemStack(waste, 1, 0), HazardRegistry.makeData(RADIATION, base * 0.075f));
        HazardData data = new HazardData();
        data.addEntry(new HazardEntry(RADIATION, base));
        data.addEntry(new HazardEntry(HOT, 5.0f));
        HazardSystem.register(new ItemStack(waste, 1, 1), data);
    }

    private static void registerRadSourceWaste(Item waste, float base) {
        HazardSystem.register(new ItemStack(waste, 1, 0), HazardRegistry.makeData(RADIATION, base));
        HazardData data = new HazardData();
        data.addEntry(new HazardEntry(RADIATION, base));
        data.addEntry(new HazardEntry(HOT, 5.0f));
        HazardSystem.register(new ItemStack(waste, 1, 1), data);
    }
}

