/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.RadiationConfig;
import com.hbm.handler.radiation.ChunkRadiationHandler;
import com.hbm.packet.AuxParticlePacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkRadiationHandlerSimple
extends ChunkRadiationHandler {
    private HashMap<World, SimpleRadiationPerWorld> perWorld = new HashMap();
    private static final float maxRad = 100000.0f;
    private static final String NBT_KEY_CHUNK_RADIATION = "hfr_simple_radiation";

    @Override
    public float getRadiation(World world, int x, int y, int z) {
        SimpleRadiationPerWorld radWorld = this.perWorld.get(world);
        if (radWorld != null) {
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            Float rad = radWorld.radiation.get(coords);
            return rad == null ? 0.0f : MathHelper.func_76131_a((float)rad.floatValue(), (float)0.0f, (float)100000.0f);
        }
        return 0.0f;
    }

    @Override
    public void setRadiation(World world, int x, int y, int z, float rad) {
        SimpleRadiationPerWorld radWorld = this.perWorld.get(world);
        if (radWorld != null && world.func_72899_e(x, 0, z)) {
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            radWorld.radiation.put(coords, Float.valueOf(MathHelper.func_76131_a((float)rad, (float)0.0f, (float)100000.0f)));
            world.func_72938_d((int)x, (int)z).field_76643_l = true;
        }
    }

    @Override
    public void incrementRad(World world, int x, int y, int z, float rad) {
        this.setRadiation(world, x, y, z, this.getRadiation(world, x, y, z) + rad);
    }

    @Override
    public void decrementRad(World world, int x, int y, int z, float rad) {
        this.setRadiation(world, x, y, z, Math.max(this.getRadiation(world, x, y, z) - rad, 0.0f));
    }

    @Override
    public void updateSystem() {
        for (Map.Entry<World, SimpleRadiationPerWorld> entry : this.perWorld.entrySet()) {
            HashMap<ChunkCoordIntPair, Float> radiation = entry.getValue().radiation;
            HashMap<ChunkCoordIntPair, Float> buff = new HashMap<ChunkCoordIntPair, Float>(radiation);
            radiation.clear();
            World world = entry.getKey();
            for (Map.Entry<ChunkCoordIntPair, Float> chunk : buff.entrySet()) {
                if (chunk.getValue().floatValue() == 0.0f) continue;
                ChunkCoordIntPair coord = chunk.getKey();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        int type = Math.abs(i) + Math.abs(j);
                        float percent = type == 0 ? 0.6f : (type == 1 ? 0.075f : 0.025f);
                        ChunkCoordIntPair newCoord = new ChunkCoordIntPair(coord.field_77276_a + i, coord.field_77275_b + j);
                        if (buff.containsKey(newCoord)) {
                            Float val = radiation.get(newCoord);
                            float rad = val == null ? 0.0f : val.floatValue();
                            float newRad = rad + chunk.getValue().floatValue() * percent;
                            newRad = MathHelper.func_76131_a((float)0.0f, (float)(newRad * 0.99f - 0.05f), (float)100000.0f);
                            radiation.put(newCoord, Float.valueOf(newRad));
                        } else {
                            radiation.put(newCoord, Float.valueOf(chunk.getValue().floatValue() * percent));
                        }
                        float rad = radiation.get(newCoord).floatValue();
                        if (!(rad > (float)RadiationConfig.fogRad) || world == null || world.field_73012_v.nextInt(RadiationConfig.fogCh) != 0 || !world.func_72964_e((int)coord.field_77276_a, (int)coord.field_77275_b).field_76636_d) continue;
                        int x = coord.field_77276_a * 16 + world.field_73012_v.nextInt(16);
                        int z = coord.field_77275_b * 16 + world.field_73012_v.nextInt(16);
                        int y = world.func_72976_f(x, z) + world.field_73012_v.nextInt(5);
                        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket(x, y, z, 3), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 100.0));
                    }
                }
            }
        }
    }

    @Override
    public void receiveWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            this.perWorld.put(event.world, new SimpleRadiationPerWorld());
        }
    }

    @Override
    public void receiveWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            this.perWorld.remove(event.world);
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        SimpleRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            radWorld.radiation.put(event.getChunk().func_76632_l(), Float.valueOf(event.getData().func_74760_g(NBT_KEY_CHUNK_RADIATION)));
        }
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        SimpleRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            Float val = radWorld.radiation.get(event.getChunk().func_76632_l());
            float rad = val == null ? 0.0f : val.floatValue();
            event.getData().func_74776_a(NBT_KEY_CHUNK_RADIATION, rad);
        }
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        SimpleRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            radWorld.radiation.remove(event.getChunk());
        }
    }

    @Override
    public void handleWorldDestruction() {
        int count = 10;
        int threshold = 10;
        int chunks = 5;
        for (Map.Entry<World, SimpleRadiationPerWorld> per : this.perWorld.entrySet()) {
            World world = per.getKey();
            SimpleRadiationPerWorld list = per.getValue();
            Object[] entries = list.radiation.entrySet().toArray();
            if (entries.length == 0) continue;
            for (int c = 0; c < chunks; ++c) {
                Map.Entry randEnt = (Map.Entry)entries[world.field_73012_v.nextInt(entries.length)];
                ChunkCoordIntPair coords = (ChunkCoordIntPair)randEnt.getKey();
                WorldServer serv = (WorldServer)world;
                ChunkProviderServer provider = (ChunkProviderServer)serv.func_72863_F();
                for (int i = 0; i < count; ++i) {
                    if (randEnt == null || ((Float)randEnt.getValue()).floatValue() < (float)threshold || !provider.func_73149_a(coords.field_77276_a, coords.field_77275_b)) continue;
                    for (int a = 0; a < 16; ++a) {
                        for (int b = 0; b < 16; ++b) {
                            int z;
                            int y;
                            if (world.field_73012_v.nextInt(3) != 0) continue;
                            int x = coords.func_77273_a() - 8 + a;
                            if (world.func_147439_a(x, y = world.func_72976_f(x, z = coords.func_77274_b() - 8 + b) - world.field_73012_v.nextInt(2), z) == Blocks.field_150349_c) {
                                world.func_147449_b(x, y, z, ModBlocks.waste_earth);
                                continue;
                            }
                            if (world.func_147439_a(x, y, z) == Blocks.field_150329_H) {
                                world.func_147449_b(x, y, z, Blocks.field_150350_a);
                                continue;
                            }
                            if (world.func_147439_a(x, y, z).func_149688_o() != Material.field_151584_j || world.func_147439_a(x, y, z) == ModBlocks.waste_leaves) continue;
                            if (world.field_73012_v.nextInt(7) <= 5) {
                                world.func_147449_b(x, y, z, ModBlocks.waste_leaves);
                                continue;
                            }
                            world.func_147449_b(x, y, z, Blocks.field_150350_a);
                        }
                    }
                }
            }
        }
    }

    public static class SimpleRadiationPerWorld {
        public HashMap<ChunkCoordIntPair, Float> radiation = new HashMap();
    }
}

