/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.inventory.gui.GUIAnvil;
import com.hbm.inventory.recipes.anvil.AnvilRecipes;
import com.hbm.inventory.recipes.anvil.AnvilSmithingRecipe;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class SmithingRecipeHandler
extends TemplateRecipeHandler {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsGui = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiGui = new LinkedList();

    public String getRecipeName() {
        return "Anvil";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ntmSmithing")) {
            List<AnvilSmithingRecipe> recipes = AnvilRecipes.getSmithing();
            for (AnvilSmithingRecipe recipe : recipes) {
                this.arecipes.add(new RecipeSet(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<AnvilSmithingRecipe> recipes = AnvilRecipes.getSmithing();
        for (AnvilSmithingRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getSimpleOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new RecipeSet(recipe));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("ntmSmithing")) {
            this.loadCraftingRecipes("ntmSmithing", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<AnvilSmithingRecipe> recipes = AnvilRecipes.getSmithing();
        block0: for (AnvilSmithingRecipe recipe : recipes) {
            for (ItemStack left : recipe.getLeft()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)left, (ItemStack)ingredient)) continue;
                this.arecipes.add(new RecipeSet(recipe));
                continue block0;
            }
            for (ItemStack right : recipe.getRight()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)right, (ItemStack)ingredient)) continue;
                this.arecipes.add(new RecipeSet(recipe));
                continue block0;
            }
        }
    }

    public void loadTransferRects() {
        this.transferRectsGui = new LinkedList();
        this.guiGui = new LinkedList();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(56, 24, 18, 18), "ntmSmithing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(92, 24, 18, 18), "ntmSmithing", new Object[0]));
        this.transferRectsGui.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 15, 18, 18), "ntmSmithing", new Object[0]));
        this.transferRectsGui.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(29, 15, 18, 18), "ntmSmithing", new Object[0]));
        this.guiGui.add(GUIAnvil.class);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(this.guiGui, this.transferRectsGui);
    }

    public void drawExtras(int recipe) {
        this.loadTransferRects();
        RecipeSet rec = (RecipeSet)((Object)this.arecipes.get(recipe));
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b("Tier " + rec.tier, 52, 43, 0x404040);
    }

    public int recipiesPerPage() {
        return 2;
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_smithing.png";
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input1;
        PositionedStack input2;
        PositionedStack output;
        int tier;

        public RecipeSet(AnvilSmithingRecipe recipe) {
            super((TemplateRecipeHandler)SmithingRecipeHandler.this);
            this.input1 = new PositionedStack(recipe.getLeft(), 39, 24);
            this.input2 = new PositionedStack(recipe.getRight(), 75, 24);
            this.output = new PositionedStack((Object)recipe.getOutput(this.input1.item, this.input2.item), 111, 24);
            this.tier = recipe.tier;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SmithingRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input1, this.input2));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

