/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.util.InventoryUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class NEIUniversalHandler
extends TemplateRecipeHandler {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsGui = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiGui = new LinkedList();
    public final String display;
    public final ItemStack[] machine;
    public final HashMap<Object, Object> recipes;
    public HashMap<Object, Object> machineOverrides;

    public NEIUniversalHandler(String display, ItemStack[] machine, HashMap recipes) {
        this.display = display;
        this.machine = machine;
        this.recipes = recipes;
        this.machineOverrides = null;
    }

    public NEIUniversalHandler(String display, HashMap recipes, HashMap machines) {
        this(display, (ItemStack[])null, recipes);
        this.machineOverrides = machines;
    }

    public NEIUniversalHandler(String display, ItemStack machine, HashMap recipes) {
        this(display, new ItemStack[]{machine}, recipes);
    }

    public NEIUniversalHandler(String display, Item machine, HashMap recipes) {
        this(display, new ItemStack(machine), recipes);
    }

    public NEIUniversalHandler(String display, Block machine, HashMap recipes) {
        this(display, new ItemStack(machine), recipes);
    }

    public String getRecipeName() {
        return this.display;
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei.png";
    }

    public void drawBackground(int recipe) {
        int[][] outPos;
        int[][] inPos;
        super.drawBackground(recipe);
        RecipeSet rec = (RecipeSet)((Object)this.arecipes.get(recipe));
        for (int[] pos : inPos = NEIUniversalHandler.getInputCoords(rec.input.length)) {
            GuiDraw.drawTexturedModalRect((int)(pos[0] - 1), (int)(pos[1] - 1), (int)5, (int)87, (int)18, (int)18);
        }
        for (int[] pos : outPos = NEIUniversalHandler.getOutputCoords(rec.output.length)) {
            GuiDraw.drawTexturedModalRect((int)(pos[0] - 1), (int)(pos[1] - 1), (int)5, (int)87, (int)18, (int)18);
        }
        GuiDraw.drawTexturedModalRect((int)74, (int)14, (int)59, (int)87, (int)18, (int)38);
    }

    public static int[][] getInputCoords(int count) {
        switch (count) {
            case 1: {
                return new int[][]{{48, 24}};
            }
            case 2: {
                return new int[][]{{48, 24}, {30, 24}};
            }
            case 3: {
                return new int[][]{{48, 24}, {30, 24}, {12, 24}};
            }
            case 4: {
                return new int[][]{{48, 15}, {30, 15}, {48, 33}, {30, 33}};
            }
            case 5: {
                return new int[][]{{48, 15}, {30, 15}, {12, 24}, {48, 33}, {30, 33}};
            }
            case 6: {
                return new int[][]{{48, 15}, {30, 15}, {12, 15}, {48, 33}, {30, 33}, {12, 33}};
            }
            case 7: {
                return new int[][]{{48, 6}, {30, 15}, {12, 15}, {48, 24}, {30, 33}, {12, 33}, {48, 42}};
            }
            case 8: {
                return new int[][]{{48, 6}, {30, 6}, {12, 15}, {48, 24}, {30, 24}, {12, 33}, {48, 42}, {30, 42}};
            }
            case 9: {
                return new int[][]{{48, 6}, {30, 6}, {12, 6}, {48, 24}, {30, 24}, {12, 24}, {48, 42}, {30, 42}, {12, 42}};
            }
        }
        return new int[count][2];
    }

    public static int[][] getOutputCoords(int count) {
        switch (count) {
            case 1: {
                return new int[][]{{102, 24}};
            }
            case 2: {
                return new int[][]{{102, 24}, {120, 24}};
            }
            case 3: {
                return new int[][]{{102, 24}, {120, 24}, {138, 24}};
            }
            case 4: {
                return new int[][]{{102, 15}, {120, 15}, {102, 33}, {120, 33}};
            }
        }
        return new int[count][2];
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getKey())) {
            for (Map.Entry<Object, Object> recipe : this.recipes.entrySet()) {
                ItemStack[][] ins = InventoryUtil.extractObject(recipe.getKey());
                ItemStack[][] outs = InventoryUtil.extractObject(recipe.getValue());
                this.arecipes.add(new RecipeSet(ins, outs, recipe.getKey()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Map.Entry<Object, Object> recipe : this.recipes.entrySet()) {
            ItemStack[][] outs;
            ItemStack[][] ins = InventoryUtil.extractObject(recipe.getKey());
            ItemStack[][] itemStackArray = outs = InventoryUtil.extractObject(recipe.getValue());
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack[] array;
                for (ItemStack stack : array = itemStackArray[i]) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)result)) continue;
                    this.arecipes.add(new RecipeSet(ins, outs, recipe.getKey()));
                    continue block0;
                }
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals(this.getKey())) {
            this.loadCraftingRecipes(this.getKey(), new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Map.Entry<Object, Object> recipe : this.recipes.entrySet()) {
            ItemStack[][] ins = InventoryUtil.extractObject(recipe.getKey());
            ItemStack[][] outs = InventoryUtil.extractObject(recipe.getValue());
            ItemStack[][] itemStackArray = ins;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack[] array;
                for (ItemStack stack : array = itemStackArray[i]) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
                    this.arecipes.add(new RecipeSet(ins, outs, recipe.getKey()));
                    continue block0;
                }
            }
        }
    }

    public void loadTransferRects() {
        this.transferRectsGui = new LinkedList();
        this.guiGui = new LinkedList();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(147, 1, 18, 18), this.getKey(), new Object[0]));
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
    }

    public abstract String getKey();

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] input;
        PositionedStack[] output;
        PositionedStack machinePositioned;

        public RecipeSet(ItemStack[][] in, ItemStack[][] out, Object originalInputInstance) {
            Object key;
            super((TemplateRecipeHandler)NEIUniversalHandler.this);
            this.input = new PositionedStack[in.length];
            int[][] inPos = NEIUniversalHandler.getInputCoords(in.length);
            for (int i = 0; i < in.length; ++i) {
                ItemStack[] sub = in[i];
                this.input[i] = new PositionedStack((Object)sub, inPos[i][0], inPos[i][1]);
            }
            this.output = new PositionedStack[out.length];
            int[][] outPos = NEIUniversalHandler.getOutputCoords(out.length);
            for (int i = 0; i < out.length; ++i) {
                ItemStack[] sub = out[i];
                this.output[i] = new PositionedStack((Object)sub, outPos[i][0], outPos[i][1]);
            }
            ItemStack[] m = NEIUniversalHandler.this.machine;
            if (NEIUniversalHandler.this.machineOverrides != null && (key = NEIUniversalHandler.this.machineOverrides.get(originalInputInstance)) != null) {
                this.machinePositioned = new PositionedStack(key, 75, 31);
            }
            if (this.machinePositioned == null) {
                this.machinePositioned = new PositionedStack((Object)m, 75, 31);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIUniversalHandler.this.cycleticks / 20, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return this.output[0];
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> other = new ArrayList<PositionedStack>();
            for (PositionedStack pos : this.output) {
                other.add(pos);
            }
            other.add(this.machinePositioned);
            return this.getCycledIngredients(NEIUniversalHandler.this.cycleticks / 20, other);
        }
    }
}

