/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.inventory.gui.GUIHadron;
import com.hbm.inventory.recipes.HadronRecipes;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class HadronRecipeHandler
extends TemplateRecipeHandler {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsGui = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiGui = new LinkedList();

    public String getRecipeName() {
        return "Particle Accelerator";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("hadron") && ((Object)((Object)this)).getClass() == HadronRecipeHandler.class) {
            List<HadronRecipes.HadronRecipe> recipes = HadronRecipes.getRecipes();
            for (HadronRecipes.HadronRecipe recipe : recipes) {
                this.arecipes.add(new RecipeSet(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<HadronRecipes.HadronRecipe> recipes = HadronRecipes.getRecipes();
        for (HadronRecipes.HadronRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.out1, (ItemStack)result) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.out2, (ItemStack)result)) continue;
            this.arecipes.add(new RecipeSet(recipe));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("hadron") && ((Object)((Object)this)).getClass() == HadronRecipeHandler.class) {
            this.loadCraftingRecipes("hadron", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<HadronRecipes.HadronRecipe> recipes = HadronRecipes.getRecipes();
        for (HadronRecipes.HadronRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.in1.toStack(), (ItemStack)ingredient) && !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.in2.toStack(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new RecipeSet(recipe));
        }
    }

    public void loadTransferRects() {
        this.transferRectsGui = new LinkedList();
        this.guiGui = new LinkedList();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(53, 23, 24, 18), "hadron", new Object[0]));
        this.transferRectsGui.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(67, 17, 30, 30), "hadron", new Object[0]));
        this.guiGui.add(GUIHadron.class);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(this.guiGui, this.transferRectsGui);
    }

    public void drawExtras(int recipe) {
        RecipeSet rec = (RecipeSet)((Object)this.arecipes.get(recipe));
        if (rec.analysisOnly) {
            GuiDraw.drawTexturedModalRect((int)128, (int)23, (int)0, (int)86, (int)18, (int)18);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String mom = String.format("%,d", rec.momentum);
        fontRenderer.func_78276_b(mom, -fontRenderer.func_78256_a(mom) / 2 + 30, 42, 0x404040);
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_hadron.png";
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input1;
        PositionedStack input2;
        PositionedStack output1;
        PositionedStack output2;
        int momentum;
        boolean analysisOnly;

        public RecipeSet(HadronRecipes.HadronRecipe recipe) {
            super((TemplateRecipeHandler)HadronRecipeHandler.this);
            this.input1 = new PositionedStack((Object)recipe.in1.toStack(), 12, 24);
            this.input2 = new PositionedStack((Object)recipe.in2.toStack(), 30, 24);
            this.output1 = new PositionedStack((Object)recipe.out1, 84, 24);
            this.output2 = new PositionedStack((Object)recipe.out2, 102, 24);
            this.momentum = recipe.momentum;
            this.analysisOnly = recipe.analysisOnly;
        }

        public List<PositionedStack> getIngredients() {
            return Arrays.asList(this.input1, this.input2);
        }

        public List<PositionedStack> getOtherStacks() {
            return Arrays.asList(this.output1, this.output2);
        }

        public PositionedStack getResult() {
            return this.output1;
        }
    }
}

