/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.blocks.machine.NTMAnvil;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.gui.GUIAnvil;
import com.hbm.inventory.recipes.anvil.AnvilRecipes;
import com.hbm.util.ItemStackUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class AnvilRecipeHandler
extends TemplateRecipeHandler {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsGui = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiGui = new LinkedList();

    public String getRecipeName() {
        return "Anvil";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ntmAnvil")) {
            List<AnvilRecipes.AnvilConstructionRecipe> recipes = AnvilRecipes.getConstruction();
            for (AnvilRecipes.AnvilConstructionRecipe recipe : recipes) {
                this.addRecipeToList(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<AnvilRecipes.AnvilConstructionRecipe> recipes = AnvilRecipes.getConstruction();
        block0: for (AnvilRecipes.AnvilConstructionRecipe recipe : recipes) {
            for (AnvilRecipes.AnvilOutput out : recipe.output) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)out.stack, (ItemStack)result)) continue;
                this.addRecipeToList(recipe);
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("ntmAnvil")) {
            this.loadCraftingRecipes("ntmAnvil", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<AnvilRecipes.AnvilConstructionRecipe> recipes = AnvilRecipes.getConstruction();
        block0: for (AnvilRecipes.AnvilConstructionRecipe recipe : recipes) {
            for (RecipesCommon.AStack in : recipe.input) {
                List<ItemStack> stacks = in.extractForNEI();
                for (ItemStack stack : stacks) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
                    this.addRecipeToList(recipe);
                    continue block0;
                }
            }
        }
    }

    private void addRecipeToList(AnvilRecipes.AnvilConstructionRecipe recipe) {
        ArrayList<Object> ins = new ArrayList<Object>();
        for (RecipesCommon.AStack input : recipe.input) {
            ins.add(input.extractForNEI());
        }
        ArrayList<Object> outs = new ArrayList<Object>();
        for (AnvilRecipes.AnvilOutput output : recipe.output) {
            ItemStack stack = output.stack.func_77946_l();
            if (output.chance != 1.0f) {
                ItemStackUtil.addTooltipToStack(stack, EnumChatFormatting.RED + "" + (double)((int)(output.chance * 1000.0f)) / 10.0 + "%");
            }
            outs.add(stack);
        }
        this.arecipes.add(new RecipeSet(ins, outs, recipe.tierLower));
    }

    public void loadTransferRects() {
        this.transferRectsGui = new LinkedList();
        this.guiGui = new LinkedList();
        this.transferRectsGui.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(11, 42, 36, 18), "ntmAnvil", new Object[0]));
        this.transferRectsGui.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 42, 36, 18), "ntmAnvil", new Object[0]));
        this.guiGui.add(GUIAnvil.class);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(this.guiGui, this.transferRectsGui);
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_anvil.png";
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        RecipeSet set = (RecipeSet)((Object)this.arecipes.get(recipe));
        switch (set.shape) {
            case NONE: {
                GuiDraw.drawTexturedModalRect((int)2, (int)5, (int)5, (int)87, (int)72, (int)54);
                GuiDraw.drawTexturedModalRect((int)92, (int)5, (int)5, (int)87, (int)72, (int)54);
                GuiDraw.drawTexturedModalRect((int)74, (int)14, (int)131, (int)96, (int)18, (int)36);
                break;
            }
            case SMITHING: {
                GuiDraw.drawTexturedModalRect((int)47, (int)23, (int)113, (int)105, (int)18, (int)18);
                GuiDraw.drawTexturedModalRect((int)101, (int)23, (int)113, (int)105, (int)18, (int)18);
                GuiDraw.drawTexturedModalRect((int)74, (int)14, (int)149, (int)96, (int)18, (int)36);
                break;
            }
            case CONSTRUCTION: {
                GuiDraw.drawTexturedModalRect((int)11, (int)5, (int)5, (int)87, (int)108, (int)54);
                GuiDraw.drawTexturedModalRect((int)137, (int)23, (int)113, (int)105, (int)18, (int)18);
                GuiDraw.drawTexturedModalRect((int)119, (int)14, (int)167, (int)96, (int)18, (int)36);
                break;
            }
            case RECYCLING: {
                GuiDraw.drawTexturedModalRect((int)11, (int)23, (int)113, (int)105, (int)18, (int)18);
                GuiDraw.drawTexturedModalRect((int)47, (int)5, (int)5, (int)87, (int)108, (int)54);
                GuiDraw.drawTexturedModalRect((int)29, (int)14, (int)185, (int)96, (int)18, (int)36);
            }
        }
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        List<PositionedStack> input;
        List<PositionedStack> output;
        PositionedStack anvil;
        int tier;
        AnvilRecipes.OverlayType shape;

        public RecipeSet(List<Object> in, List<Object> out, int tier) {
            int i;
            super((TemplateRecipeHandler)AnvilRecipeHandler.this);
            this.input = new ArrayList<PositionedStack>();
            this.output = new ArrayList<PositionedStack>();
            int inLine = 1;
            int outLine = 1;
            int inOX = 0;
            int inOY = 0;
            int outOX = 0;
            int outOY = 0;
            int anvX = 0;
            int anvY = 31;
            if (in.size() == 1 && out.size() == 1) {
                this.shape = AnvilRecipes.OverlayType.SMITHING;
                inOX = 48;
                inOY = 24;
                outOX = 102;
                outOY = 24;
                anvX = 75;
            } else if (in.size() == 1 && out.size() > 1) {
                this.shape = AnvilRecipes.OverlayType.RECYCLING;
                outLine = 6;
                inOX = 12;
                inOY = 24;
                outOX = 48;
                outOY = 6;
                anvX = 30;
            } else if (in.size() > 1 && out.size() == 1) {
                this.shape = AnvilRecipes.OverlayType.CONSTRUCTION;
                inLine = 6;
                inOX = 12;
                inOY = 6;
                outOX = 138;
                outOY = 24;
                anvX = 120;
            } else {
                this.shape = AnvilRecipes.OverlayType.NONE;
                inLine = 4;
                outLine = 4;
                inOX = 3;
                inOY = 6;
                outOX = 93;
                outOY = 6;
                anvX = 75;
            }
            for (i = 0; i < in.size(); ++i) {
                this.input.add(new PositionedStack(in.get(i), inOX + 18 * (i % inLine), inOY + 18 * (i / inLine)));
            }
            for (i = 0; i < out.size(); ++i) {
                this.output.add(new PositionedStack(out.get(i), outOX + 18 * (i % outLine), outOY + 18 * (i / outLine)));
            }
            this.anvil = new PositionedStack(NTMAnvil.getAnvilsFromTier(tier), anvX, anvY);
            this.tier = tier;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AnvilRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output.get(0);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> other = new ArrayList<PositionedStack>();
            other.addAll(this.output);
            other.add(this.anvil);
            return this.getCycledIngredients(AnvilRecipeHandler.this.cycleticks / 20, other);
        }
    }
}

