/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityRocketHoming;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.render.util.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class GunRocketHomingFactory {
    public static GunConfiguration getStingerConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_KRUCK;
        config.firingSound = "hbm:weapon.rpgShoot";
        config.reloadSound = "hbm:weapon.rpgReload";
        config.reloadSoundEnd = false;
        config.name = "stinger";
        config.manufacturer = HbmCollection.EnumGunManufacturer.RAYTHEON;
        config.comment.add("Woosh, beep-beep-beep!");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER_HE);
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER_NUCLEAR);
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER_BONES);
        config.durability = 250;
        return config;
    }

    public static GunConfiguration getSkyStingerConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_KRUCK;
        config.firingSound = "hbm:weapon.rpgShoot";
        config.reloadSound = "hbm:weapon.rpgReload";
        config.reloadSoundEnd = false;
        config.name = "stingerOneSky";
        config.manufacturer = HbmCollection.EnumGunManufacturer.EQUESTRIA;
        config.comment.add("Oh, I get it, because of the...nyeees!");
        config.comment.add("It all makes sense now!");
        config.comment.add("");
        config.comment.add("Rockets travel faster, are Three times stronger");
        config.comment.add("and fires a second rocket for free");
        config.comment.add("");
        config.comment.add("[LEGENDARY WEAPON]");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER_HE);
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER_NUCLEAR);
        config.config.add(BulletConfigSyncingUtil.ROCKET_STINGER_BONES);
        config.durability = 1000;
        return config;
    }

    public static BulletConfiguration getRocketStingerConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_stinger_rocket.stackFromEnum(ItemAmmoEnums.AmmoStinger.STOCK));
        bullet.dmgMin = 20.0f;
        bullet.dmgMax = 25.0f;
        bullet.explosive = 4.0f;
        bullet.trail = 0;
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                EntityPlayer player = bulletnt.field_70170_p.func_72890_a((Entity)bulletnt, -1.0);
                EntityRocketHoming rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.0f, 5.0f, 0);
                if (player.func_70694_bm().func_77973_b() == ModItems.gun_skystinger && !player.func_70093_af()) {
                    EntityRocketHoming rocket2 = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 0);
                    rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 0);
                    rocket.setIsCritical(true);
                    rocket2.setIsCritical(true);
                    bulletnt.field_70170_p.func_72838_d((Entity)rocket2);
                }
                rocket.homingMod = 5;
                rocket.homingRadius = 25;
                bulletnt.field_70170_p.func_72838_d((Entity)rocket);
                bulletnt.func_70106_y();
            }
        };
        return bullet;
    }

    public static BulletConfiguration getRocketStingerHEConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_stinger_rocket.stackFromEnum(ItemAmmoEnums.AmmoStinger.HE));
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 35.0f;
        bullet.explosive = 8.0f;
        bullet.trail = 0;
        bullet.wear = 15;
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                EntityPlayer player = bulletnt.field_70170_p.func_72890_a((Entity)bulletnt, -1.0);
                EntityRocketHoming rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.0f, 5.0f, 1);
                if (player.func_70694_bm().func_77973_b() == ModItems.gun_skystinger && !player.func_70093_af()) {
                    EntityRocketHoming rocket2 = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 1);
                    rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 1);
                    rocket.setIsCritical(true);
                    rocket2.setIsCritical(true);
                    bulletnt.field_70170_p.func_72838_d((Entity)rocket2);
                }
                rocket.homingMod = 5;
                rocket.homingRadius = 25;
                bulletnt.field_70170_p.func_72838_d((Entity)rocket);
                bulletnt.func_70106_y();
            }
        };
        return bullet;
    }

    public static BulletConfiguration getRocketStingerIncendiaryConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_stinger_rocket.stackFromEnum(ItemAmmoEnums.AmmoStinger.INCENDIARY));
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 20.0f;
        bullet.explosive = 4.0f;
        bullet.trail = 0;
        bullet.wear = 12;
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                EntityPlayer player = bulletnt.field_70170_p.func_72890_a((Entity)bulletnt, -1.0);
                EntityRocketHoming rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.0f, 5.0f, 2);
                if (player.func_70694_bm().func_77973_b() == ModItems.gun_skystinger && !player.func_70093_af()) {
                    EntityRocketHoming rocket2 = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 2);
                    rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 2);
                    rocket.setIsCritical(true);
                    rocket2.setIsCritical(true);
                    bulletnt.field_70170_p.func_72838_d((Entity)rocket2);
                }
                rocket.homingMod = 5;
                rocket.homingRadius = 25;
                bulletnt.field_70170_p.func_72838_d((Entity)rocket);
                bulletnt.func_70106_y();
            }
        };
        return bullet;
    }

    public static BulletConfiguration getRocketStingerNuclearConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_stinger_rocket.stackFromEnum(ItemAmmoEnums.AmmoStinger.NUCLEAR));
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 55.0f;
        bullet.explosive = 15.0f;
        bullet.trail = 0;
        bullet.wear = 30;
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                EntityPlayer player = bulletnt.field_70170_p.func_72890_a((Entity)bulletnt, -1.0);
                if (player.func_70032_d((Entity)bulletnt) < 16.0f) {
                    EntityRocketHoming rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.0f, 5.0f, 4);
                    if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.gun_skystinger && !player.func_70093_af()) {
                        EntityRocketHoming rocket2 = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 4);
                        rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 4);
                        rocket.setIsCritical(true);
                        rocket2.setIsCritical(true);
                        bulletnt.field_70170_p.func_72838_d((Entity)rocket2);
                    }
                    rocket.homingMod = 5;
                    rocket.homingRadius = 25;
                    bulletnt.field_70170_p.func_72838_d((Entity)rocket);
                }
                bulletnt.func_70106_y();
            }
        };
        return bullet;
    }

    public static BulletConfiguration getRocketStingerBonesConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_stinger_rocket.stackFromEnum(ItemAmmoEnums.AmmoStinger.BONES));
        bullet.dmgMin = 20.0f;
        bullet.dmgMax = 25.0f;
        bullet.explosive = 8.0f;
        bullet.trail = 0;
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                EntityPlayer player = bulletnt.field_70170_p.func_72890_a((Entity)bulletnt, -1.0);
                if (player.func_70032_d((Entity)bulletnt) < 16.0f) {
                    EntityRocketHoming rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.0f, 5.0f, 42);
                    if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.gun_skystinger && !player.func_70093_af()) {
                        EntityRocketHoming rocket2 = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 42);
                        rocket = new EntityRocketHoming(bulletnt.field_70170_p, (EntityLivingBase)player, 1.5f, 15.0f, 42);
                        rocket.setIsCritical(true);
                        rocket2.setIsCritical(true);
                        bulletnt.field_70170_p.func_72838_d((Entity)rocket2);
                    }
                    rocket.homingMod = 5;
                    rocket.homingRadius = 25;
                    bulletnt.field_70170_p.func_72838_d((Entity)rocket);
                }
                bulletnt.func_70106_y();
            }
        };
        return bullet;
    }
}

