/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.effect.EntitySpear;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class GunRocketFactory {
    public static GunConfiguration getGustavConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 30;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 30;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = "hbm:weapon.rpgShoot";
        config.reloadSound = "hbm:weapon.rpgReload";
        config.reloadSoundEnd = false;
        config.name = "gustav";
        config.manufacturer = HbmCollection.EnumGunManufacturer.SAAB;
        config.comment.add("Fun fact of the day: Recoilless");
        config.comment.add("rifles don't actually fire rockets.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ROCKET_NORMAL);
        config.config.add(BulletConfigSyncingUtil.ROCKET_HE);
        config.config.add(BulletConfigSyncingUtil.ROCKET_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.ROCKET_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.ROCKET_SHRAPNEL);
        config.config.add(BulletConfigSyncingUtil.ROCKET_EMP);
        config.config.add(BulletConfigSyncingUtil.ROCKET_GLARE);
        config.config.add(BulletConfigSyncingUtil.ROCKET_TOXIC);
        config.config.add(BulletConfigSyncingUtil.ROCKET_CANISTER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_SLEEK);
        config.config.add(BulletConfigSyncingUtil.ROCKET_NUKE);
        config.config.add(BulletConfigSyncingUtil.ROCKET_CHAINSAW);
        config.durability = 140;
        return config;
    }

    public static GunConfiguration getQuadroConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 5;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 100;
        config.firingDuration = 0;
        config.ammoCap = 4;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = "hbm:weapon.rpgShoot";
        config.reloadSound = "hbm:weapon.quadroReload";
        config.reloadSoundEnd = false;
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("QUADRO_RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, -0.5, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 50))));
        config.animations.put(HbmAnimations.AnimType.RELOAD, new BusAnimation().addBus("QUADRO_RELOAD_ROTATE", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 60.0, 750)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 60.0, 3500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 750))).addBus("QUADRO_RELOAD_PUSH", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(-1.0, -1.0, 0.0, 0)).addKeyframe(new BusAnimationKeyframe(-1.0, -1.0, 0.0, 750)).addKeyframe(new BusAnimationKeyframe(-1.0, 0.0, 0.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 3000)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 750))));
        config.name = "quadro";
        config.manufacturer = HbmCollection.EnumGunManufacturer.MANN;
        config.comment.add("For the next three hundred years, people who needed to get to the second");
        config.comment.add("floor used the only method available to them, which was rocket jumping.");
        config.comment.add("This persisted until 1857, when the young bearded inventor named");
        config.comment.add("President Abraham Lincoln invented stairs.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ROCKET_NORMAL_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_HE_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_INCENDIARY_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_PHOSPHORUS_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_SHRAPNEL_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_EMP_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_GLARE_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_TOXIC_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_CANISTER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_SLEEK_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_NUKE_LASER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_CHAINSAW_LASER);
        config.durability = 500;
        return config;
    }

    public static GunConfiguration getKarlConfig() {
        GunConfiguration config = GunRocketFactory.getGustavConfig();
        config.reloadDuration = 20;
        config.name = "karl";
        config.manufacturer = HbmCollection.EnumGunManufacturer.UNKNOWN;
        config.comment.clear();
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ROCKET_HE);
        config.config.add(BulletConfigSyncingUtil.ROCKET_EMP);
        config.config.add(BulletConfigSyncingUtil.ROCKET_SLEEK);
        config.config.add(BulletConfigSyncingUtil.ROCKET_TOXIC);
        config.config.add(BulletConfigSyncingUtil.ROCKET_CANISTER);
        config.config.add(BulletConfigSyncingUtil.ROCKET_NUKE);
        config.config.add(BulletConfigSyncingUtil.ROCKET_CHAINSAW);
        config.config.add(BulletConfigSyncingUtil.ROCKET_ERROR);
        config.durability = 500;
        return config;
    }

    public static GunConfiguration getPanzConfig() {
        GunConfiguration config = GunRocketFactory.getGustavConfig();
        config.reloadDuration = 25;
        config.hasSights = true;
        config.name = "panz";
        config.manufacturer = HbmCollection.EnumGunManufacturer.ENZINGER;
        config.comment.clear();
        config.comment.add("Panzer-Shrek");
        config.durability = 260;
        return config;
    }

    public static BulletConfiguration getRocketConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.STOCK));
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.explosive = 4.0f;
        bullet.trail = 0;
        return bullet;
    }

    public static BulletConfiguration getRocketHEConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.HE));
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 15;
        bullet.explosive = 6.5f;
        bullet.trail = 1;
        return bullet;
    }

    public static BulletConfiguration getRocketIncendiaryConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.INCENDIARY));
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 15;
        bullet.explosive = 4.0f;
        bullet.incendiary = 5;
        bullet.trail = 2;
        return bullet;
    }

    public static BulletConfiguration getRocketEMPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.EMP));
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.explosive = 2.5f;
        bullet.emp = 10;
        bullet.trail = 4;
        return bullet;
    }

    public static BulletConfiguration getRocketSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.SLEEK));
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.explosive = 10.0f;
        bullet.trail = 6;
        bullet.gravity = 0.0;
        bullet.jolt = 6.5;
        return bullet;
    }

    public static BulletConfiguration getRocketShrapnelConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.SHRAPNEL));
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.explosive = 4.0f;
        bullet.shrapnel = 25;
        bullet.trail = 3;
        return bullet;
    }

    public static BulletConfiguration getRocketGlareConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.GLARE));
        bullet.velocity = 5.0f;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 20;
        bullet.explosive = 4.0f;
        bullet.incendiary = 5;
        bullet.trail = 5;
        return bullet;
    }

    public static BulletConfiguration getRocketNukeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.NUCLEAR));
        bullet.velocity = 1.5f;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 35;
        bullet.explosive = 0.0f;
        bullet.incendiary = 0;
        bullet.trail = 7;
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> BulletConfigFactory.nuclearExplosion(bulletnt, x, y, z, ExplosionNukeSmall.PARAMS_MEDIUM);
        return bullet;
    }

    public static BulletConfiguration getRocketChlorineConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.CHLORINE));
        bullet.velocity = 1.5f;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 10;
        bullet.explosive = 0.0f;
        bullet.chlorine = 50;
        bullet.trail = 7;
        return bullet;
    }

    public static BulletConfiguration getRocketRPCConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.RPC));
        bullet.velocity = 3.0f;
        bullet.dmgMin = 20.0f;
        bullet.dmgMax = 25.0f;
        bullet.wear = 15;
        bullet.explosive = 0.0f;
        bullet.incendiary = 0;
        bullet.trail = 8;
        bullet.gravity = 0.0;
        bullet.ricochetAngle = 90.0;
        bullet.LBRC = 100;
        bullet.doesPenetrate = true;
        bullet.bntRicochet = (bulletnt, bX, bY, bZ) -> {
            World worldObj = bulletnt.field_70170_p;
            if (!(worldObj.field_72995_K || worldObj.func_147439_a(bX, bY, bZ).func_149688_o() != Material.field_151575_d && worldObj.func_147439_a(bX, bY, bZ).func_149688_o() != Material.field_151585_k && worldObj.func_147439_a(bX, bY, bZ).func_149688_o() != Material.field_151592_s && worldObj.func_147439_a(bX, bY, bZ).func_149688_o() != Material.field_151584_j)) {
                worldObj.func_147480_a(bX, bY, bZ, false);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getRocketPhosphorusConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.PHOSPHORUS));
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 15;
        bullet.explosive = 4.0f;
        bullet.incendiary = 5;
        bullet.trail = 9;
        bullet.bntImpact = BulletConfigFactory.getPhosphorousEffect(10, 1200, 100, 0.5, 1.0f);
        return bullet;
    }

    public static BulletConfiguration getRocketCanisterConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.CANISTER));
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.explosive = 2.0f;
        bullet.trail = 0;
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K && bulletnt.field_70173_aa > 10) {
                bulletnt.func_70106_y();
                for (int i = 0; i < 50; ++i) {
                    EntityBulletBaseNT bolt = new EntityBulletBaseNT(bulletnt.field_70170_p, BulletConfigSyncingUtil.M44_AP);
                    bolt.func_70107_b(bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v);
                    bolt.func_70186_c(bulletnt.field_70159_w, bulletnt.field_70181_x, bulletnt.field_70179_y, 0.25f, 0.1f);
                    bolt.setThrower(bulletnt.getThrower());
                    bulletnt.field_70170_p.func_72838_d((Entity)bolt);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getRocketErrorConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.DIGAMMA));
        bullet.velocity = 0.5f;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 35;
        bullet.explosive = 0.0f;
        bullet.incendiary = 0;
        bullet.trail = 7;
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            EntitySpear spear = new EntitySpear(bulletnt.field_70170_p);
            spear.field_70165_t = bulletnt.field_70165_t;
            spear.field_70161_v = bulletnt.field_70161_v;
            spear.field_70163_u = bulletnt.field_70163_u + 100.0;
            bulletnt.field_70170_p.func_72838_d((Entity)spear);
        };
        return bullet;
    }
}

