/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.SpentCasing;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class GunGrenadeFactory {
    private static final CasingEjector EJECTOR_LAUNCHER = new CasingEjector().setAngleRange(0.02f, 0.03f).setAfterReload();
    private static final CasingEjector EJECTOR_CONGOLAKE = new CasingEjector().setMotion(0.3, 0.1, 0.0).setAngleRange(0.02f, 0.03f).setDelay(15);
    private static final SpentCasing CASING40MM = new SpentCasing(SpentCasing.CasingType.STRAIGHT).setScale(4.0f, 4.0f, 3.0f).setBounceMotion(0.02f, 0.03f).setColor(0x777777).setupSmoke(1.0f, 0.5, 60, 40);

    public static GunConfiguration getHK69Config() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 30;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.hasSights = true;
        config.zoomFOV = 0.66f;
        config.reloadDuration = 40;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = "hbm:weapon.hkShoot";
        config.reloadSound = "hbm:weapon.hkReload";
        config.reloadSoundEnd = false;
        config.name = "gPistol";
        config.manufacturer = HbmCollection.EnumGunManufacturer.H_AND_K;
        config.config = HbmCollection.grenade;
        config.durability = 300;
        config.ejector = EJECTOR_LAUNCHER;
        return config;
    }

    public static GunConfiguration getCongoConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 4;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = "hbm:weapon.glShoot";
        config.reloadSound = "hbm:weapon.glReload";
        config.name = "congoLake";
        config.manufacturer = HbmCollection.EnumGunManufacturer.NAWS;
        config.config = HbmCollection.grenade;
        config.durability = 2500;
        config.ejector = EJECTOR_CONGOLAKE;
        return config;
    }

    public static BulletConfiguration getGrenadeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.STOCK));
        bullet.velocity = 2.0f;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 10;
        bullet.trail = 0;
        bullet.spentCasing = CASING40MM.clone().register("40MMStock");
        return bullet;
    }

    public static BulletConfiguration getGrenadeHEConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.HE));
        bullet.velocity = 2.0f;
        bullet.dmgMin = 20.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 15;
        bullet.explosive = 5.0f;
        bullet.trail = 1;
        bullet.spentCasing = CASING40MM.clone().register("40MMHE");
        return bullet;
    }

    public static BulletConfiguration getGrenadeIncendirayConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.INCENDIARY));
        bullet.velocity = 2.0f;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 15;
        bullet.trail = 0;
        bullet.incendiary = 2;
        bullet.spentCasing = CASING40MM.clone().register("40MMInc");
        return bullet;
    }

    public static BulletConfiguration getGrenadePhosphorusConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.PHOSPHORUS));
        bullet.velocity = 2.0f;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 15;
        bullet.trail = 0;
        bullet.incendiary = 2;
        bullet.bntImpact = BulletConfigFactory.getPhosphorousEffect(10, 1200, 100, 0.5, 1.0f);
        bullet.spentCasing = CASING40MM.clone().register("40MMPhos");
        return bullet;
    }

    public static BulletConfiguration getGrenadeChlorineConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.CHLORINE));
        bullet.velocity = 2.0f;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 10;
        bullet.trail = 3;
        bullet.explosive = 0.0f;
        bullet.chlorine = 50;
        bullet.spentCasing = CASING40MM.clone().register("40MMTox");
        return bullet;
    }

    public static BulletConfiguration getGrenadeSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.SLEEK));
        bullet.velocity = 2.0f;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 10;
        bullet.trail = 4;
        bullet.explosive = 7.5f;
        bullet.jolt = 6.5;
        bullet.spentCasing = CASING40MM.clone().register("40MMIF");
        return bullet;
    }

    public static BulletConfiguration getGrenadeConcussionConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.CONCUSSION));
        bullet.velocity = 2.0f;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 20.0f;
        bullet.blockDamage = false;
        bullet.explosive = 10.0f;
        bullet.trail = 3;
        bullet.spentCasing = CASING40MM.clone().register("40MMCon");
        return bullet;
    }

    public static BulletConfiguration getGrenadeFinnedConfig() {
        BulletConfiguration bullet = GunGrenadeFactory.getGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.FINNED));
        bullet.gravity = 0.02;
        bullet.explosive = 1.5f;
        bullet.trail = 5;
        bullet.spentCasing = CASING40MM.clone().register("40MMFin");
        return bullet;
    }

    public static BulletConfiguration getGrenadeNuclearConfig() {
        BulletConfiguration bullet = GunGrenadeFactory.getGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.NUCLEAR));
        bullet.velocity = 4.0f;
        bullet.explosive = 0.0f;
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> BulletConfigFactory.nuclearExplosion(bulletnt, x, y, z, ExplosionNukeSmall.PARAMS_TOTS);
        bullet.spentCasing = CASING40MM.clone().register("40MMNuke");
        return bullet;
    }

    public static BulletConfiguration getGrenadeTracerConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.TRACER));
        bullet.velocity = 2.0f;
        bullet.wear = 10;
        bullet.explosive = 0.0f;
        bullet.trail = 5;
        bullet.vPFX = "bluedust";
        bullet.spentCasing = CASING40MM.clone().register("40MMTrac").setColor(0xEEEEEE);
        return bullet;
    }

    public static BulletConfiguration getGrenadeKampfConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.KAMPF));
        bullet.spread = 0.0f;
        bullet.gravity = 0.0;
        bullet.wear = 15;
        bullet.explosive = 3.5f;
        bullet.style = 10;
        bullet.trail = 4;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static BulletConfiguration getGrenadeLeadbursterConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.LEADBURSTER));
        bullet.spread = 0.0f;
        bullet.gravity = 0.01;
        bullet.explosive = 0.0f;
        bullet.style = 18;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.vPFX = "";
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> {
            switch (sideHit) {
                case 0: {
                    bulletnt.field_70125_A = 90.0f;
                    break;
                }
                case 1: {
                    bulletnt.field_70125_A = -90.0f;
                    break;
                }
                case 2: {
                    bulletnt.field_70125_A = 0.0f;
                    bulletnt.field_70177_z = 0.0f;
                    break;
                }
                case 3: {
                    bulletnt.field_70125_A = 0.0f;
                    bulletnt.field_70177_z = 180.0f;
                    break;
                }
                case 4: {
                    bulletnt.field_70125_A = 0.0f;
                    bulletnt.field_70177_z = 90.0f;
                    break;
                }
                case 5: {
                    bulletnt.field_70125_A = 0.0f;
                    bulletnt.field_70177_z = -90.0f;
                }
            }
            Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
            vec.func_72440_a((float)((double)bulletnt.field_70125_A * Math.PI / 180.0));
            vec.func_72442_b((float)((double)bulletnt.field_70177_z * Math.PI / 180.0));
            double offset = 0.1;
            bulletnt.field_70165_t -= vec.field_72450_a * offset;
            bulletnt.field_70163_u -= vec.field_72448_b * offset;
            bulletnt.field_70161_v -= vec.field_72449_c * offset;
            bulletnt.field_70173_aa = 0;
            bulletnt.getStuck(x, y, z, sideHit);
        };
        bullet.bntUpdate = bulletnt -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            switch (bulletnt.getStuckIn()) {
                case 0: {
                    bulletnt.field_70125_A = 90.0f;
                    break;
                }
                case 1: {
                    bulletnt.field_70125_A = -90.0f;
                    break;
                }
                case 2: {
                    bulletnt.field_70125_A = 0.0f;
                    bulletnt.field_70177_z = 0.0f;
                    break;
                }
                case 3: {
                    bulletnt.field_70125_A = 0.0f;
                    bulletnt.field_70177_z = 180.0f;
                    break;
                }
                case 4: {
                    bulletnt.field_70125_A = 0.0f;
                    bulletnt.field_70177_z = 90.0f;
                    break;
                }
                case 5: {
                    bulletnt.field_70125_A = 0.0f;
                    bulletnt.field_70177_z = -90.0f;
                }
            }
            if (bulletnt.ticksInGround < 20) {
                return;
            }
            int timer = bulletnt.ticksInGround - 20;
            Vec3 offset = Vec3.func_72443_a((double)0.0, (double)0.0, (double)-0.5);
            offset.func_72440_a((float)((double)bulletnt.field_70125_A * Math.PI / 180.0));
            offset.func_72442_b((float)((double)bulletnt.field_70177_z * Math.PI / 180.0));
            if (bulletnt.field_70173_aa >= 100) {
                bulletnt.func_70106_y();
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaExt");
                data.func_74778_a("mode", "largeexplode");
                data.func_74776_a("size", 1.0f);
                data.func_74774_a("count", (byte)1);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bulletnt.field_70165_t + offset.field_72450_a, bulletnt.field_70163_u + offset.field_72448_b, bulletnt.field_70161_v + offset.field_72449_c), new NetworkRegistry.TargetPoint(bulletnt.field_71093_bK, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, 50.0));
            }
            if (timer > 60) {
                return;
            }
            bulletnt.field_70170_p.func_72908_a(bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, "hbm:weapon.silencerShoot", 2.0f, 1.0f);
            for (int i = 0; i < 5; ++i) {
                Vec3 vec = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
                vec.func_72440_a((float)Math.toRadians(11.25 * (double)i));
                vec.func_72446_c((float)(-Math.toRadians(13 * timer)));
                vec.func_72440_a((float)((double)bulletnt.field_70125_A * Math.PI / 180.0));
                vec.func_72442_b((float)((double)bulletnt.field_70177_z * Math.PI / 180.0));
                EntityBulletBaseNT pellet = new EntityBulletBaseNT(bulletnt.field_70170_p, BulletConfigSyncingUtil.R556_NORMAL);
                double dist = 0.5;
                double off = 0.5;
                pellet.func_70107_b(bulletnt.field_70165_t + vec.field_72450_a * dist + offset.field_72450_a * off, bulletnt.field_70163_u + vec.field_72448_b * dist + offset.field_72448_b * off, bulletnt.field_70161_v + vec.field_72449_c * dist + offset.field_72449_c * off);
                double vel = 0.5;
                pellet.field_70159_w = vec.field_72450_a * vel;
                pellet.field_70181_x = vec.field_72448_b * vel;
                pellet.field_70179_y = vec.field_72449_c * vel;
                float hyp = MathHelper.func_76133_a((double)(pellet.field_70159_w * pellet.field_70159_w + pellet.field_70179_y * pellet.field_70179_y));
                pellet.field_70126_B = pellet.field_70177_z = (float)(Math.atan2(pellet.field_70159_w, pellet.field_70179_y) * 180.0 / Math.PI);
                pellet.field_70127_C = pellet.field_70125_A = (float)(Math.atan2(pellet.field_70181_x, hyp) * 180.0 / Math.PI);
                bulletnt.field_70170_p.func_72838_d((Entity)pellet);
            }
        };
        return bullet;
    }
}

