/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNT;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GunFatmanFactory {
    public static GunConfiguration getFatmanConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 120;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = "hbm:weapon.fatmanShoot";
        config.reloadSound = "hbm:weapon.fatmanReload";
        config.reloadSoundEnd = false;
        config.name = "m42";
        config.manufacturer = HbmCollection.EnumGunManufacturer.F_STRONG;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NUKE_NORMAL);
        config.config.add(BulletConfigSyncingUtil.NUKE_LOW);
        config.config.add(BulletConfigSyncingUtil.NUKE_HIGH);
        config.config.add(BulletConfigSyncingUtil.NUKE_TOTS);
        config.config.add(BulletConfigSyncingUtil.NUKE_SAFE);
        config.config.add(BulletConfigSyncingUtil.NUKE_PUMPKIN);
        config.config.add(BulletConfigSyncingUtil.NUKE_BARREL);
        config.durability = 1000;
        return config;
    }

    public static GunConfiguration getMIRVConfig() {
        GunConfiguration config = GunFatmanFactory.getFatmanConfig();
        config.name = "m42MIRV";
        config.manufacturer = HbmCollection.EnumGunManufacturer.F_STRONG;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_NORMAL);
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_LOW);
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_HIGH);
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_SAFE);
        config.config.add(BulletConfigSyncingUtil.NUKE_MIRV_SPECIAL);
        config.durability = 1000;
        return config;
    }

    public static GunConfiguration getBELConfig() {
        GunConfiguration config = GunFatmanFactory.getFatmanConfig();
        config.name = "bel";
        config.manufacturer = HbmCollection.EnumGunManufacturer.F_STRONG;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NUKE_AMAT);
        return config;
    }

    public static GunConfiguration getProtoConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 8;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 120;
        config.firingDuration = 0;
        config.ammoCap = 8;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = "hbm:weapon.fatmanShoot";
        config.reloadSound = "hbm:weapon.fatmanReload";
        config.reloadSoundEnd = false;
        config.name = "m42";
        config.manufacturer = HbmCollection.EnumGunManufacturer.F_STRONG;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_NORMAL);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_LOW);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_HIGH);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_TOTS);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_SAFE);
        config.config.add(BulletConfigSyncingUtil.NUKE_PROTO_PUMPKIN);
        config.config.add(BulletConfigSyncingUtil.NUKE_BARREL);
        config.durability = 1000;
        return config;
    }

    public static BulletConfiguration getNukeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.STOCK));
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, ExplosionNukeSmall.PARAMS_MEDIUM);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeLowConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.LOW));
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, ExplosionNukeSmall.PARAMS_LOW);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeHighConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.HIGH));
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, ExplosionNukeSmall.PARAMS_HIGH);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeTotsConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.TOTS));
        bullet.bulletsMin = 8;
        bullet.bulletsMax = 8;
        bullet.spread = 0.1f;
        bullet.style = 10;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, ExplosionNukeSmall.PARAMS_TOTS);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeSafeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.SAFE));
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                BulletConfigFactory.nuclearExplosion(bullet, x, y, z, ExplosionNukeSmall.PARAMS_SAFE);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukePumpkinConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.PUMPKIN));
        bullet.explosive = 10.0f;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    double posX = bullet.field_70165_t;
                    double posY = bullet.field_70163_u + 0.5;
                    double posZ = bullet.field_70161_v;
                    if (y >= 0) {
                        posX = (double)x + 0.5;
                        posY = (double)y + 1.5;
                        posZ = (double)z + 0.5;
                    }
                    ExplosionLarge.spawnParticles(bullet.field_70170_p, posX, posY, posZ, 45);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeBarrelConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.BARREL));
        bullet.explosive = 3.0f;
        bullet.style = 16;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    double posX = bullet.field_70165_t;
                    double posY = bullet.field_70163_u + 0.5;
                    double posZ = bullet.field_70161_v;
                    if (y >= 0) {
                        posX = (double)x + 0.5;
                        posY = (double)y + 1.5;
                        posZ = (double)z + 0.5;
                    }
                    x = (int)Math.floor(posX);
                    y = (int)Math.floor(posY);
                    z = (int)Math.floor(posZ);
                    World worldObj = bullet.field_70170_p;
                    for (int ix = x - 3; ix <= x + 3; ++ix) {
                        for (int iy = y - 3; iy <= y + 3; ++iy) {
                            for (int iz = z - 3; iz <= z + 3; ++iz) {
                                if (worldObj.field_73012_v.nextInt(3) == 0 && worldObj.func_147439_a(ix, iy, iz).isReplaceable((IBlockAccess)worldObj, ix, iy, iz) && ModBlocks.fallout.func_149742_c(worldObj, ix, iy, iz)) {
                                    worldObj.func_147449_b(ix, iy, iz, ModBlocks.fallout);
                                    continue;
                                }
                                if (worldObj.func_147439_a(ix, iy, iz) != Blocks.field_150350_a) continue;
                                if (worldObj.field_73012_v.nextBoolean()) {
                                    worldObj.func_147449_b(ix, iy, iz, ModBlocks.gas_radon);
                                    continue;
                                }
                                worldObj.func_147449_b(ix, iy, iz, ModBlocks.gas_radon_dense);
                            }
                        }
                    }
                    ChunkRadiationManager.proxy.incrementRad(worldObj, x, y, z, 100.0f);
                    ExplosionLarge.spawnParticles(bullet.field_70170_p, posX, posY, posZ, 45);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.MIRV));
        bullet.style = 9;
        bullet.velocity *= 3.0f;
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 6; ++i) {
                        EntityBulletBaseNT nuke = new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_NORMAL);
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.1;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvLowConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeLowConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.MIRV_LOW));
        bullet.style = 9;
        bullet.velocity *= 3.0f;
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 6; ++i) {
                        EntityBulletBaseNT nuke = new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_LOW);
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.1;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvHighConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeHighConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.MIRV_HIGH));
        bullet.style = 9;
        bullet.velocity *= 3.0f;
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 6; ++i) {
                        EntityBulletBaseNT nuke = new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_HIGH);
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.1;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvSafeConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeSafeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.MIRV_SAFE));
        bullet.style = 9;
        bullet.velocity *= 3.0f;
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 6; ++i) {
                        EntityBulletBaseNT nuke = new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_SAFE);
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.1;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getMirvSpecialConfig() {
        BulletConfiguration bullet = GunFatmanFactory.getNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.MIRV_SPECIAL));
        bullet.style = 9;
        bullet.velocity *= 3.0f;
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70173_aa == 15) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 24; ++i) {
                        EntityBulletBaseNT nuke = null;
                        nuke = i < 6 ? new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_LOW) : (i < 12 ? new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_TOTS) : (i < 18 ? new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_NORMAL) : new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.NUKE_AMAT)));
                        nuke.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        double mod = 0.25;
                        nuke.field_70159_w = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        nuke.field_70181_x = -0.1;
                        nuke.field_70179_y = bullet.field_70170_p.field_73012_v.nextGaussian() * mod;
                        bullet.field_70170_p.func_72838_d((Entity)nuke);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getBalefireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardNukeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.BALEFIRE));
        bullet.style = 11;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    double posX = bullet.field_70165_t;
                    double posY = bullet.field_70163_u + 0.5;
                    double posZ = bullet.field_70161_v;
                    if (y >= 0) {
                        posX = (double)x + 0.5;
                        posY = (double)y + 1.5;
                        posZ = (double)z + 0.5;
                    }
                    bullet.field_70170_p.func_72908_a((double)x, (double)y, (double)z, "hbm:weapon.mukeExplosion", 15.0f, 1.0f);
                    ExplosionLarge.spawnShrapnels(bullet.field_70170_p, posX, posY, posZ, 25);
                    ExplosionNT exp = new ExplosionNT(bullet.field_70170_p, null, posX, posY, posZ, 15.0f).addAttrib(ExplosionNT.ExAttrib.BALEFIRE).addAttrib(ExplosionNT.ExAttrib.NOPARTICLE).addAttrib(ExplosionNT.ExAttrib.NOSOUND).addAttrib(ExplosionNT.ExAttrib.NODROP).overrideResolution(64);
                    exp.func_77278_a();
                    exp.func_77279_a(false);
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "muke");
                    data.func_74757_a("balefire", true);
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, x, (double)y + 0.5, z), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 250.0));
                }
            }
        };
        return bullet;
    }
}

