/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.ExplosionKnockbackPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.util.RenderScreenOverlay;
import com.hbm.tileentity.IRepairable;
import com.hbm.util.CompatExternal;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class GunEnergyFactory {
    public static GunConfiguration getChemConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.allowsInfinity = false;
        config.ammoCap = 3000;
        config.durability = 90000;
        config.reloadType = 1;
        config.crosshair = RenderScreenOverlay.Crosshair.CIRCLE;
        config.name = "Chemical Thrower";
        config.manufacturer = HbmCollection.EnumGunManufacturer.LANGFORD;
        config.config = new ArrayList<Integer>();
        return config;
    }

    public static GunConfiguration getEMPConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 30;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 0;
        config.durability = 1500;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_SPLIT;
        config.firingSound = "hbm:weapon.teslaShoot";
        config.name = "EMP Orb Projector";
        config.manufacturer = HbmCollection.EnumGunManufacturer.MWT;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.SPECIAL_EMP);
        return config;
    }

    public static GunConfiguration getFlamerConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.ammoCap = 100;
        config.durability = 1000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.firingSound = "hbm:weapon.flamethrowerShoot";
        config.reloadSound = "hbm:weapon.flamerReload";
        config.name = "Heavy Duty Flamer";
        config.manufacturer = HbmCollection.EnumGunManufacturer.MWT;
        config.comment.add("Dragon-slaying: Advanced techniques, part 1:");
        config.comment.add("Try not to get eaten by the dragon.");
        config.comment.add("");
        config.comment.add("Hope that helps.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.FLAMER_NORMAL);
        config.config.add(BulletConfigSyncingUtil.FLAMER_NAPALM);
        config.config.add(BulletConfigSyncingUtil.FLAMER_WP);
        config.config.add(BulletConfigSyncingUtil.FLAMER_VAPORIZER);
        config.config.add(BulletConfigSyncingUtil.FLAMER_GAS);
        return config;
    }

    public static GunConfiguration getZOMGConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 10;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.durability = 100000;
        config.reloadType = 1;
        config.ammoCap = 1000;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_ARROWS;
        config.firingSound = "hbm:weapon.zomgShoot";
        config.reloadSound = "hbm:weapon.b92Reload";
        config.name = "EMC101 Prismatic Negative Energy Cannon";
        config.manufacturer = HbmCollection.EnumGunManufacturer.MWT;
        config.comment.add("Taste the rainbow!");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ZOMG_BOLT);
        return config;
    }

    public static GunConfiguration getExtConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.ammoCap = 300;
        config.durability = 10000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.firingSound = "hbm:weapon.extinguisher";
        config.reloadSound = "hbm:weapon.flamerReload";
        config.name = "PROTEX Fire Exinguisher 6kg";
        config.manufacturer = HbmCollection.EnumGunManufacturer.GLORIA;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.FEXT_NORMAL);
        config.config.add(BulletConfigSyncingUtil.FEXT_FOAM);
        config.config.add(BulletConfigSyncingUtil.FEXT_SAND);
        return config;
    }

    public static GunConfiguration getCoilgunConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 5;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.durability = 2500;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.CIRCLE;
        config.firingSound = "hbm:weapon.coilgunShoot";
        config.reloadSoundEnd = false;
        config.reloadSound = "hbm:weapon.coilgunReload";
        config.name = "ArmsKore Coilgun";
        config.manufacturer = HbmCollection.EnumGunManufacturer.DRG;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.COIL_NORMAL);
        config.config.add(BulletConfigSyncingUtil.COIL_DU);
        config.config.add(BulletConfigSyncingUtil.COIL_RUBBER);
        return config;
    }

    public static GunConfiguration getCryoCannonConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.firingDuration = 0;
        config.ammoCap = 1000;
        config.durability = 10000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.name = "Cryo Cannon";
        config.manufacturer = HbmCollection.EnumGunManufacturer.DRG;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.CRYO_NORMAL);
        return config;
    }

    public static GunConfiguration getVortexConfig() {
        GunConfiguration config = new GunConfiguration();
        return config;
    }

    public static BulletConfiguration getOrbusConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.gun_emp_ammo);
        bullet.velocity = 1.0f;
        bullet.spread = 0.0f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 12.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = 12;
        bullet.plink = 0;
        bullet.emp = 10;
        bullet.damageType = "electrified";
        bullet.dmgProj = false;
        bullet.dmgBypass = true;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 1));
        bullet.effects.add(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 4));
        return bullet;
    }

    public static BulletConfiguration getCoilConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_coilgun, 1, ItemAmmoEnums.AmmoCoilgun.STOCK.ordinal());
        bullet.velocity = 7.5f;
        bullet.spread = 0.0f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 35.0f;
        bullet.dmgMax = 45.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 50;
        bullet.doesPenetrate = true;
        bullet.isSpectral = true;
        bullet.style = 4;
        bullet.trail = 1;
        bullet.vPFX = "fireworks";
        bullet.bntUpdate = entity -> GunEnergyFactory.breakInPath(entity, 1.25f);
        return bullet;
    }

    public static BulletConfiguration getCoilDUConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_coilgun, 1, ItemAmmoEnums.AmmoCoilgun.DU.ordinal());
        bullet.velocity = 7.5f;
        bullet.spread = 0.0f;
        bullet.wear = 25;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 65.0f;
        bullet.dmgMax = 80.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 50;
        bullet.doesPenetrate = true;
        bullet.isSpectral = true;
        bullet.style = 4;
        bullet.trail = 1;
        bullet.vPFX = "fireworks";
        bullet.bntUpdate = entity -> GunEnergyFactory.breakInPath(entity, 2.5f);
        return bullet;
    }

    public static BulletConfiguration getCoilRubberConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_coilgun, 1, ItemAmmoEnums.AmmoCoilgun.RUBBER.ordinal());
        bullet.velocity = 5.0f;
        bullet.spread = 0.0f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 20.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 50;
        bullet.doesPenetrate = false;
        bullet.isSpectral = false;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 30.0;
        bullet.HBRC = 90;
        bullet.LBRC = 100;
        bullet.bounceMod = 1.0;
        bullet.selfDamageDelay = 2;
        bullet.style = 3;
        bullet.bntHurt = (entity, hit) -> {
            Vec3 vec = Vec3.func_72443_a((double)entity.field_70159_w, (double)entity.field_70181_x, (double)entity.field_70179_y);
            vec = vec.func_72432_b();
            vec.field_72450_a *= 10.0;
            vec.field_72448_b *= 10.0;
            vec.field_72449_c *= 10.0;
            hit.field_70159_w += vec.field_72450_a;
            hit.field_70181_x += vec.field_72448_b;
            hit.field_70179_y += vec.field_72449_c;
            if (hit instanceof EntityPlayerMP) {
                PacketDispatcher.wrapper.sendTo((IMessage)new ExplosionKnockbackPacket(vec), (EntityPlayerMP)hit);
            }
        };
        return bullet;
    }

    public static void breakInPath(EntityBulletBaseNT entity, float threshold) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        Vec3 vec = Vec3.func_72443_a((double)(entity.field_70165_t - entity.field_70169_q), (double)(entity.field_70163_u - entity.field_70167_r), (double)(entity.field_70161_v - entity.field_70166_s));
        double motion = Math.max(vec.func_72433_c(), 0.1);
        vec = vec.func_72432_b();
        for (double d = 0.0; d < motion; d += 0.5) {
            int x = (int)Math.floor(entity.field_70165_t - vec.field_72450_a * d);
            int y = (int)Math.floor(entity.field_70163_u - vec.field_72448_b * d);
            int z = (int)Math.floor(entity.field_70161_v - vec.field_72449_c * d);
            Block b = entity.field_70170_p.func_147439_a(x, y, z);
            float hardness = b.func_149712_f(entity.field_70170_p, x, y, z);
            if (b.func_149688_o() == Material.field_151579_a || !(hardness >= 0.0f) || !(hardness < threshold)) continue;
            entity.field_70170_p.func_147480_a(x, y, z, false);
        }
    }

    public static BulletConfiguration getFlameConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fuel.stackFromEnum(ItemAmmoEnums.AmmoFlamethrower.DIESEL));
        bullet.ammoCount = 100;
        bullet.velocity = 0.75f;
        bullet.spread = 0.025f;
        bullet.wear = 1;
        bullet.bulletsMin = 3;
        bullet.bulletsMax = 5;
        bullet.dmgMin = 2.0f;
        bullet.dmgMax = 4.0f;
        bullet.gravity = 0.01;
        bullet.maxAge = 60;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = -1;
        bullet.plink = 0;
        bullet.vPFX = "flame";
        bullet.incendiary = 10;
        bullet.damageType = "flamethrower";
        bullet.dmgProj = false;
        bullet.dmgFire = true;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaburst");
                    data.func_74778_a("mode", "flame");
                    data.func_74768_a("count", 15);
                    data.func_74780_a("motion", 0.1);
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNapalmConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fuel.stackFromEnum(ItemAmmoEnums.AmmoFlamethrower.NAPALM));
        bullet.wear = 2;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 6.0f;
        bullet.maxAge = 200;
        return bullet;
    }

    public static BulletConfiguration getPhosphorusConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fuel.stackFromEnum(ItemAmmoEnums.AmmoFlamethrower.PHOSPHORUS));
        bullet.wear = 2;
        bullet.spread = 0.0f;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 6.0f;
        bullet.maxAge = 200;
        bullet.vPFX = "smoke";
        bullet.bntImpact = BulletConfigFactory.getPhosphorousEffect(5, 1200, 25, 0.25, 0.1f);
        return bullet;
    }

    public static BulletConfiguration getVaporizerConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fuel.stackFromEnum(ItemAmmoEnums.AmmoFlamethrower.VAPORIZER));
        bullet.wear = 4;
        bullet.spread = 0.25f;
        bullet.bulletsMin = 8;
        bullet.bulletsMax = 10;
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 10.0f;
        bullet.maxAge = 15;
        bullet.vPFX = "flame";
        bullet.incendiary = 0;
        bullet.dmgBypass = true;
        PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 400, 0, true);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        return bullet;
    }

    public static BulletConfiguration getGasConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fuel.stackFromEnum(ItemAmmoEnums.AmmoFlamethrower.CHLORINE));
        bullet.wear = 1;
        bullet.spread = 0.05f;
        bullet.gravity = 0.0;
        bullet.bulletsMin = 5;
        bullet.bulletsMax = 7;
        bullet.dmgMin = 0.0f;
        bullet.dmgMax = 0.0f;
        bullet.vPFX = "cloud";
        bullet.incendiary = 0;
        bullet.dmgFire = false;
        bullet.bntImpact = BulletConfigFactory.getGasEffect(5, 1200);
        return bullet;
    }

    public static BulletConfiguration getFextConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fireext.stackFromEnum(ItemAmmoEnums.AmmoFireExt.WATER));
        bullet.ammoCount = 300;
        bullet.velocity = 0.75f;
        bullet.spread = 0.025f;
        bullet.wear = 1;
        bullet.bulletsMin = 2;
        bullet.bulletsMax = 3;
        bullet.dmgMin = 0.0f;
        bullet.dmgMax = 0.0f;
        bullet.gravity = 0.04;
        bullet.maxAge = 100;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = -1;
        bullet.plink = 0;
        bullet.bntHurt = (bulletEntity, target) -> target.func_70066_B();
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    int ix = (int)Math.floor(bullet.field_70165_t);
                    int iy = (int)Math.floor(bullet.field_70163_u);
                    int iz = (int)Math.floor(bullet.field_70161_v);
                    boolean fizz = false;
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                if (bullet.field_70170_p.func_147439_a(ix + i, iy + j, iz + k) != Blocks.field_150480_ab) continue;
                                bullet.field_70170_p.func_147449_b(ix + i, iy + j, iz + k, Blocks.field_150350_a);
                                fizz = true;
                            }
                        }
                    }
                    TileEntity core = CompatExternal.getCoreFromPos(bullet.field_70170_p, ix, iy, iz);
                    if (core instanceof IRepairable) {
                        ((IRepairable)core).tryExtinguish(bullet.field_70170_p, ix, iy, iz, IRepairable.EnumExtinguishType.WATER);
                    }
                    if (fizz) {
                        bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                    }
                }
            }
        };
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150355_j));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    MainRegistry.proxy.effectNT(data);
                } else {
                    int z;
                    int y;
                    int x = (int)Math.floor(bullet.field_70165_t);
                    if (bullet.field_70170_p.func_147439_a(x, y = (int)Math.floor(bullet.field_70163_u), z = (int)Math.floor(bullet.field_70161_v)) == ModBlocks.volcanic_lava_block && bullet.field_70170_p.func_72805_g(x, y, z) == 0) {
                        bullet.field_70170_p.func_147449_b(x, y, z, Blocks.field_150343_Z);
                        bullet.func_70106_y();
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getFextFoamConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFextConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fireext.stackFromEnum(ItemAmmoEnums.AmmoFireExt.FOAM));
        bullet.spread = 0.05f;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    int ix = (int)Math.floor(bullet.field_70165_t);
                    int iy = (int)Math.floor(bullet.field_70163_u);
                    int iz = (int)Math.floor(bullet.field_70161_v);
                    boolean fizz = false;
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                Block b = bullet.field_70170_p.func_147439_a(ix + i, iy + j, iz + k);
                                if (b.func_149688_o() != Material.field_151581_o) continue;
                                bullet.field_70170_p.func_147449_b(ix + i, iy + j, iz + k, Blocks.field_150350_a);
                                fizz = true;
                            }
                        }
                    }
                    Block b = bullet.field_70170_p.func_147439_a(ix, iy, iz);
                    TileEntity core = CompatExternal.getCoreFromPos(bullet.field_70170_p, ix, iy, iz);
                    if (core instanceof IRepairable) {
                        ((IRepairable)core).tryExtinguish(bullet.field_70170_p, ix, iy, iz, IRepairable.EnumExtinguishType.FOAM);
                        return;
                    }
                    if (b.isReplaceable((IBlockAccess)bullet.field_70170_p, ix, iy, iz) && ModBlocks.foam_layer.func_149742_c(bullet.field_70170_p, ix, iy, iz)) {
                        if (b != ModBlocks.foam_layer) {
                            bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.foam_layer);
                        } else {
                            int meta = bullet.field_70170_p.func_72805_g(ix, iy, iz);
                            if (meta < 6) {
                                bullet.field_70170_p.func_72921_c(ix, iy, iz, meta + 1, 3);
                            } else {
                                bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.block_foam);
                            }
                        }
                    }
                    if (fizz) {
                        bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                    }
                }
            }
        };
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)ModBlocks.block_foam));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getFextSandConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFextConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_fireext.stackFromEnum(ItemAmmoEnums.AmmoFireExt.SAND));
        bullet.spread = 0.1f;
        bullet.bntHurt = null;
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    int ix = (int)Math.floor(bullet.field_70165_t);
                    int iy = (int)Math.floor(bullet.field_70163_u);
                    int iz = (int)Math.floor(bullet.field_70161_v);
                    Block b = bullet.field_70170_p.func_147439_a(ix, iy, iz);
                    TileEntity core = CompatExternal.getCoreFromPos(bullet.field_70170_p, ix, iy, iz);
                    if (core instanceof IRepairable) {
                        ((IRepairable)core).tryExtinguish(bullet.field_70170_p, ix, iy, iz, IRepairable.EnumExtinguishType.SAND);
                        return;
                    }
                    if ((b.isReplaceable((IBlockAccess)bullet.field_70170_p, ix, iy, iz) || b == ModBlocks.sand_boron_layer) && ModBlocks.sand_boron_layer.func_149742_c(bullet.field_70170_p, ix, iy, iz)) {
                        if (b != ModBlocks.sand_boron_layer) {
                            bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.sand_boron_layer);
                        } else {
                            int meta = bullet.field_70170_p.func_72805_g(ix, iy, iz);
                            if (meta < 6) {
                                bullet.field_70170_p.func_72921_c(ix, iy, iz, meta + 1, 3);
                            } else {
                                bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.sand_boron);
                            }
                        }
                        if (b.func_149688_o() == Material.field_151581_o) {
                            bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                        }
                    }
                }
            }
        };
        bullet.bntUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)ModBlocks.sand_boron));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getZOMGBoltConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.nugget_euphemium);
        bullet.ammoCount = 1000;
        bullet.wear = 1;
        bullet.velocity = 1.0f;
        bullet.spread = 0.125f;
        bullet.maxAge = 100;
        bullet.gravity = 0.0;
        bullet.bulletsMin = 5;
        bullet.bulletsMax = 5;
        bullet.dmgMin = 10000.0f;
        bullet.dmgMax = 25000.0f;
        bullet.liveAfterImpact = true;
        bullet.damageType = "subAtomic";
        bullet.dmgProj = false;
        bullet.dmgBypass = true;
        bullet.style = 4;
        bullet.trail = 3;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(HbmPotion.bang.field_76415_H, 200, 0));
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    ExplosionChaos.explodeZOMG(bullet.field_70170_p, (int)Math.floor(bullet.field_70165_t), (int)Math.floor(bullet.field_70163_u), (int)Math.floor(bullet.field_70161_v), 5);
                    bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "hbm:entity.bombDet", 5.0f, 1.0f);
                    ExplosionLarge.spawnParticles(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 5);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getCryoConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.gun_cryolator_ammo);
        bullet.ammoCount = 100;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        return bullet;
    }

    public static BulletConfiguration getTurbineConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.nothing);
        bullet.dmgMin = 100.0f;
        bullet.dmgMax = 150.0f;
        bullet.velocity = 1.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 200;
        bullet.style = 15;
        bullet.destroysBlocks = true;
        bullet.doesRicochet = false;
        return bullet;
    }

    public static BulletConfiguration getTurretConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.spread *= 2.0f;
        bullet.gravity = 0.0025;
        return bullet;
    }
}

