/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemGunDart;
import com.hbm.lib.HbmCollection;
import com.hbm.main.MainRegistry;
import com.hbm.render.util.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class GunDartFactory {
    public static GunConfiguration getDarterConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.hasSights = false;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CROSS;
        config.durability = 1000;
        config.reloadSound = "hbm:weapon.hkReload";
        config.firingSound = "hbm:weapon.dartShoot";
        config.reloadSoundEnd = false;
        config.showAmmo = true;
        config.name = "dart";
        config.manufacturer = HbmCollection.EnumGunManufacturer.NONE;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NEEDLE_GPS);
        config.config.add(BulletConfigSyncingUtil.NEEDLE_NUKE);
        return config;
    }

    public static GunConfiguration getMymyConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.hasSights = false;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.NONE;
        config.durability = 1000;
        config.reloadSound = "hbm:weapon.hkReload";
        config.firingSound = "hbm:weapon.dartShoot";
        config.reloadSoundEnd = false;
        config.showAmmo = true;
        config.name = "nerf";
        config.manufacturer = HbmCollection.EnumGunManufacturer.HASBRO;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.DART_NORMAL);
        config.config.add(BulletConfigSyncingUtil.NEEDLE_NUKE);
        return config;
    }

    public static BulletConfiguration getGPSConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_dart.stackFromEnum(ItemAmmoEnums.AmmoDart.GPS));
        bullet.velocity = 5.0f;
        bullet.spread = 0.0f;
        bullet.dmgMin = 1.0f;
        bullet.dmgMax = 2.0f;
        bullet.doesRicochet = true;
        bullet.doesPenetrate = false;
        bullet.style = 2;
        bullet.leadChance = 0;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(Potion.field_82731_v.field_76415_H, 1200, 2));
        bullet.bntHurt = (bulletnt, hit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            if (hit instanceof EntityPlayer) {
                EntityPlayer shooter;
                if (((EntityPlayer)hit).field_71071_by.func_146028_b(ModItems.ingot_meteorite_forged)) {
                    return;
                }
                if (bulletnt.getThrower() instanceof EntityPlayer && (shooter = (EntityPlayer)bulletnt.getThrower()).func_70694_bm() != null && shooter.func_70694_bm().func_77973_b() == ModItems.gun_darter) {
                    ItemGunDart.writePlayer(shooter.func_70694_bm(), (EntityPlayer)hit);
                    shooter.func_85030_a("random.orb", 1.0f, 1.0f);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNukeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_dart.stackFromEnum(ItemAmmoEnums.AmmoDart.NUCLEAR));
        bullet.velocity = 5.0f;
        bullet.spread = 0.0f;
        bullet.dmgMin = 1.0f;
        bullet.dmgMax = 2.0f;
        bullet.doesRicochet = true;
        bullet.doesPenetrate = false;
        bullet.style = 2;
        bullet.leadChance = 0;
        bullet.bntHurt = (bulletnt, hit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            if (hit instanceof EntityLivingBase) {
                EntityLivingBase e = (EntityLivingBase)hit;
                if (HbmLivingProps.getRadiation(e) < 250.0f) {
                    HbmLivingProps.setRadiation(e, 250.0f);
                }
                if (HbmLivingProps.getTimer(e) <= 0) {
                    HbmLivingProps.setTimer(e, MainRegistry.polaroidID * 60 * 20);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNERFConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_dart.stackFromEnum(ItemAmmoEnums.AmmoDart.NERF));
        bullet.velocity = 1.0f;
        bullet.gravity = 0.04;
        bullet.dmgMin = 0.0f;
        bullet.dmgMax = 0.0f;
        bullet.leadChance = 0;
        return bullet;
    }
}

