/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.particle.SpentCasing;

public class GunCannonFactory {
    protected static SpentCasing CASINNG240MM = new SpentCasing(SpentCasing.CasingType.BOTTLENECK).setScale(7.5f).setBounceMotion(0.02f, 0.05f).setColor(15450974).setupSmoke(1.0f, 0.5, 60, 20);

    public static BulletConfiguration getShellConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_shell.stackFromEnum(ItemAmmoEnums.Ammo240Shell.STOCK));
        bullet.dmgMin = 25.0f;
        bullet.dmgMax = 35.0f;
        bullet.explosive = 4.0f;
        bullet.blockDamage = false;
        bullet.spentCasing = CASINNG240MM.register("240MM");
        return bullet;
    }

    public static BulletConfiguration getShellExplosiveConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_shell.stackFromEnum(ItemAmmoEnums.Ammo240Shell.EXPLOSIVE));
        bullet.dmgMin = 35.0f;
        bullet.dmgMax = 45.0f;
        bullet.explosive = 4.0f;
        bullet.blockDamage = true;
        bullet.spentCasing = CASINNG240MM;
        return bullet;
    }

    public static BulletConfiguration getShellAPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_shell.stackFromEnum(ItemAmmoEnums.Ammo240Shell.APFSDS_T));
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 55.0f;
        bullet.doesPenetrate = true;
        bullet.style = 14;
        bullet.spentCasing = CASINNG240MM;
        return bullet;
    }

    public static BulletConfiguration getShellDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_shell.stackFromEnum(ItemAmmoEnums.Ammo240Shell.APFSDS_DU));
        bullet.dmgMin = 70.0f;
        bullet.dmgMax = 80.0f;
        bullet.doesPenetrate = true;
        bullet.style = 14;
        bullet.spentCasing = CASINNG240MM;
        return bullet;
    }

    public static BulletConfiguration getShellW9Config() {
        BulletConfiguration bullet = BulletConfigFactory.standardShellConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_shell.stackFromEnum(ItemAmmoEnums.Ammo240Shell.W9));
        bullet.dmgMin = 100.0f;
        bullet.dmgMax = 150.0f;
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> BulletConfigFactory.nuclearExplosion(bulletnt, x, y, z, ExplosionNukeSmall.PARAMS_TOTS);
        bullet.spentCasing = CASINNG240MM;
        return bullet;
    }
}

