/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.particle.SpentCasing;
import com.hbm.render.util.RenderScreenOverlay;
import java.util.ArrayList;

public class Gun9mmFactory {
    private static final CasingEjector EJECTOR_SMG = new CasingEjector().setMotion(-0.3, 0.6, 0.0).setOffset(-0.35, -0.2, 0.55).setAngleRange(0.01f, 0.03f);
    private static final SpentCasing CASING9MM = new SpentCasing(SpentCasing.CasingType.STRAIGHT).setScale(1.0f, 1.0f, 0.6f).setBounceMotion(0.01f, 0.03f).setColor(15450974);
    static float inaccuracy = 5.0f;

    public static GunConfiguration getMP40Config() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 2;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 32;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_SPLIT;
        config.durability = 2500;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:weapon.rifleShoot";
        config.reloadSoundEnd = false;
        config.name = "mp40";
        config.manufacturer = HbmCollection.EnumGunManufacturer.ERFURT;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.P9_NORMAL);
        config.config.add(BulletConfigSyncingUtil.P9_AP);
        config.config.add(BulletConfigSyncingUtil.P9_DU);
        config.config.add(BulletConfigSyncingUtil.CHL_P9);
        config.config.add(BulletConfigSyncingUtil.P9_ROCKET);
        config.ejector = EJECTOR_SMG;
        return config;
    }

    public static BulletConfiguration get9mmConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_9mm.stackFromEnum(ItemAmmoEnums.Ammo9mm.STOCK));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 14.0f;
        bullet.spentCasing = CASING9MM.clone().register("9MMStock");
        return bullet;
    }

    public static BulletConfiguration get9mmAPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_9mm.stackFromEnum(ItemAmmoEnums.Ammo9mm.AP));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 18.0f;
        bullet.dmgMax = 20.0f;
        bullet.leadChance = 10;
        bullet.wear = 15;
        bullet.spentCasing = CASING9MM.clone().register("9MMAP");
        return bullet;
    }

    public static BulletConfiguration get9mmDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_9mm.stackFromEnum(ItemAmmoEnums.Ammo9mm.DU));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 22.0f;
        bullet.dmgMax = 26.0f;
        bullet.leadChance = 50;
        bullet.wear = 25;
        bullet.spentCasing = CASING9MM.clone().register("9MMDU");
        return bullet;
    }

    public static BulletConfiguration get9mmRocketConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_9mm.stackFromEnum(ItemAmmoEnums.Ammo9mm.ROCKET));
        bullet.velocity = 5.0f;
        bullet.explosive = 7.5f;
        bullet.trail = 5;
        bullet.spentCasing = CASING9MM.clone().register("9MMRocket");
        return bullet;
    }
}

