/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.particle.SpentCasing;
import com.hbm.render.util.RenderScreenOverlay;

public class Gun5mmFactory {
    private static final CasingEjector EJECTOR_MINIGUN = new CasingEjector().setMotion(-0.4, 0.1, 0.0).setOffset(-0.35, -0.2, 0.35).setAngleRange(0.01f, 0.03f).setAmount(5);
    private static final SpentCasing CASING5MM = new SpentCasing(SpentCasing.CasingType.STRAIGHT).setScale(1.25f).setBounceMotion(0.05f, 0.02f).setColor(15450974).setMaxAge(100);
    private static float inaccuracy = 10.0f;

    public static GunConfiguration getMinigunConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 5;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 0;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.durability = 10000;
        config.firingSound = "hbm:weapon.lacunaeShoot";
        config.config = HbmCollection.r5;
        config.ejector = EJECTOR_MINIGUN;
        return config;
    }

    public static GunConfiguration get53Config() {
        GunConfiguration config = Gun5mmFactory.getMinigunConfig();
        config.name = "cz53";
        config.manufacturer = HbmCollection.EnumGunManufacturer.ROCKWELL;
        return config;
    }

    public static GunConfiguration get57Config() {
        GunConfiguration config = Gun5mmFactory.getMinigunConfig();
        config.durability = 15000;
        config.name = "cz57";
        config.manufacturer = HbmCollection.EnumGunManufacturer.ROCKWELL;
        return config;
    }

    public static GunConfiguration getLacunaeConfig() {
        GunConfiguration config = Gun5mmFactory.getMinigunConfig();
        config.durability = 25000;
        config.name = "lacunae";
        config.manufacturer = HbmCollection.EnumGunManufacturer.ROCKWELL_U;
        config.config = HbmCollection.r5Bolt;
        return config;
    }

    public static BulletConfiguration get5mmConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_5mm.stackFromEnum(ItemAmmoEnums.Ammo5mm.STOCK));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 12.0f;
        bullet.dmgMax = 14.0f;
        bullet.spentCasing = CASING5MM.clone().register("5mmStock");
        return bullet;
    }

    public static BulletConfiguration get5mmExplosiveConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_5mm.stackFromEnum(ItemAmmoEnums.Ammo5mm.EXPLOSIVE));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 32.0f;
        bullet.explosive = 1.0f;
        bullet.wear = 25;
        bullet.spentCasing = CASING5MM.clone().register("5mmExp");
        return bullet;
    }

    public static BulletConfiguration get5mmDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_5mm.stackFromEnum(ItemAmmoEnums.Ammo5mm.DU));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 36.0f;
        bullet.dmgMax = 40.0f;
        bullet.wear = 25;
        bullet.leadChance = 50;
        bullet.spentCasing = CASING5MM.clone().register("5mmDU");
        return bullet;
    }

    public static BulletConfiguration get5mmStarConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_5mm.stackFromEnum(ItemAmmoEnums.Ammo5mm.STAR));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 46.0f;
        bullet.dmgMax = 50.0f;
        bullet.wear = 25;
        bullet.leadChance = 100;
        bullet.spentCasing = CASING5MM.clone().register("5mmStar");
        return bullet;
    }
}

