/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.SpentCasing;
import com.hbm.potion.HbmPotion;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

public class Gun50BMGFactory {
    private static final CasingEjector EJECTOR_BMG = new CasingEjector().setMotion(-0.35, 0.9, 0.0).setOffset(-0.45, -0.2, 0.35).setAngleRange(0.01f, 0.05f);
    private static final CasingEjector EJECTOR_SNIPER = new CasingEjector().setMotion(-2.0, 0.15, 0.0).setOffset(-0.45, -0.2, 0.35).setAngleRange(0.02f, 0.05f);
    private static final SpentCasing CASING50BMG = new SpentCasing(SpentCasing.CasingType.BOTTLENECK).setScale(3.0f).setBounceMotion(0.01f, 0.05f).setColor(15450974).setupSmoke(0.125f, 0.5, 60, 20);
    private static final SpentCasing CASINGLUNA = new SpentCasing(SpentCasing.CasingType.BOTTLENECK).setScale(4.0f).setBounceMotion(0.02f, 0.05f).setColor(15450974).setupSmoke(0.125f, 0.5, 60, 30);
    public static final ResourceLocation scope_luna = new ResourceLocation("hbm", "textures/misc/scope_luna.png");
    static float inaccuracy = 2.5f;

    public static BulletConfiguration getLunaticSabotRound() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_luna_sniper.stackFromEnum(ItemAmmoEnums.AmmoLunaticSniper.SABOT));
        bullet.spread = 0.0f;
        bullet.dmgMax = 500.0f;
        bullet.dmgMin = 450.0f;
        bullet.headshotMult = 2.5f;
        bullet.wear = 2000;
        bullet.velocity = 10.0f;
        bullet.doesPenetrate = true;
        bullet.leadChance = 20;
        bullet.blockDamage = false;
        bullet.bntImpact = (projectile, x, y, z, sideHit) -> projectile.field_70170_p.func_72885_a((Entity)projectile, (double)x, (double)y, (double)z, 2.0f, false, false);
        bullet.spentCasing = CASINGLUNA.clone().register("LunaStock");
        return bullet;
    }

    public static BulletConfiguration getLunaticIncendiaryRound() {
        BulletConfiguration bullet = Gun50BMGFactory.getLunaticSabotRound().clone();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_luna_sniper.stackFromEnum(ItemAmmoEnums.AmmoLunaticSniper.INCENDIARY));
        bullet.ammo.meta = 1;
        bullet.incendiary = 10;
        bullet.bntImpact = (projectile, x, y, z, sideHit) -> projectile.field_70170_p.func_72885_a((Entity)projectile, (double)x, (double)y, (double)z, 5.0f, true, false);
        bullet.spentCasing = CASINGLUNA.clone().register("LunaInc");
        return bullet;
    }

    public static BulletConfiguration getLunaticExplosiveRound() {
        BulletConfiguration bullet = Gun50BMGFactory.getLunaticSabotRound().clone();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_luna_sniper.stackFromEnum(ItemAmmoEnums.AmmoLunaticSniper.EXPLOSIVE));
        bullet.ammo.meta = 2;
        bullet.explosive = 25.0f;
        bullet.destroysBlocks = true;
        bullet.bntImpact = (projectile, x, y, z, sideHit) -> projectile.field_70170_p.func_72885_a((Entity)projectile, (double)x, (double)y, (double)z, 25.0f, true, false);
        bullet.spentCasing = CASINGLUNA.clone().register("LunaExp");
        return bullet;
    }

    public static GunConfiguration getAR15Config() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.reloadSoundEnd = false;
        config.ammoCap = 50;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.NONE;
        config.durability = 100000;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:turret.howard_fire";
        config.name = "ar15_50";
        config.manufacturer = HbmCollection.EnumGunManufacturer.ARMALITE;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.BMG50_FLECHETTE_AM);
        config.config.add(BulletConfigSyncingUtil.BMG50_FLECHETTE_PO);
        config.config.add(BulletConfigSyncingUtil.BMG50_FLECHETTE_NORMAL);
        config.config.add(BulletConfigSyncingUtil.BMG50_NORMAL);
        config.config.add(BulletConfigSyncingUtil.BMG50_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.BMG50_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.BMG50_EXPLOSIVE);
        config.config.add(BulletConfigSyncingUtil.BMG50_AP);
        config.config.add(BulletConfigSyncingUtil.BMG50_DU);
        config.config.add(BulletConfigSyncingUtil.BMG50_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_BMG50);
        config.config.add(BulletConfigSyncingUtil.BMG50_SLEEK);
        config.ejector = EJECTOR_BMG;
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 25)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 75))));
        config.animations.put(HbmAnimations.AnimType.RELOAD, new BusAnimation().addBus("TILT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 125)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 750)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 125))).addBus("MAG", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 200)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 1.0, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))));
        return config;
    }

    public static GunConfiguration getM2Config() {
        GunConfiguration config = Gun50BMGFactory.getAR15Config();
        config.rateOfFire = 2;
        config.durability *= 10;
        config.ammoCap = 0;
        config.crosshair = RenderScreenOverlay.Crosshair.L_BOX;
        config.reloadType = 0;
        config.hasSights = true;
        config.zoomFOV = 0.66f;
        config.allowsInfinity = true;
        config.durability = 10000;
        config.firingSound = "hbm:turret.chekhov_fire";
        config.equipSound = "hbm:turret.howard_reload";
        config.name = "m2";
        config.manufacturer = HbmCollection.EnumGunManufacturer.COLT;
        config.comment.add("\"A single man can do unbelievable things...");
        config.comment.add("A single man with a .50 cal machine gun can do even more.\"");
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 25)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 75))));
        config.ejector = EJECTOR_BMG;
        config.config.clear();
        config.config.addAll(HbmCollection.bmg50);
        return config;
    }

    public static GunConfiguration getLunaticMarksman() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 15;
        config.reloadDuration = 15;
        config.firingMode = 0;
        config.roundsPerCycle = 1;
        config.firingSound = "hbm:weapon.hicalShot";
        config.firingPitch = 0.75f;
        config.ammoCap = 4;
        config.reloadType = 2;
        config.hasSights = true;
        config.zoomFOV = 0.2f;
        config.scopeTexture = scope_luna;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CLASSIC;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.reloadSoundEnd = true;
        config.durability = 500000;
        config.name = "lunaSniper";
        config.manufacturer = HbmCollection.EnumGunManufacturer.LUNA;
        config.comment.add("\"You do not spark joy\"");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ROUND_LUNA_SNIPER_SABOT);
        config.config.add(BulletConfigSyncingUtil.ROUND_LUNA_SNIPER_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.ROUND_LUNA_SNIPER_EXPLOSIVE);
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(-0.45, 0.15, 0.0, 40)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 75))).addBus("EJECT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 30)).addKeyframe(new BusAnimationKeyframe(50.0, 0.0, 0.0, 120))));
        config.ejector = EJECTOR_SNIPER;
        return config;
    }

    public static BulletConfiguration get50BMGConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.STOCK));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 36.0f;
        bullet.spentCasing = CASING50BMG.clone().register("50BMGStock");
        return bullet;
    }

    public static BulletConfiguration get50BMGFireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.INCENDIARY));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 36.0f;
        bullet.wear = 15;
        bullet.incendiary = 5;
        bullet.spentCasing = CASING50BMG.clone().register("50BMGInc");
        return bullet;
    }

    public static BulletConfiguration get50BMGPhosphorusConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.PHOSPHORUS));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 36.0f;
        bullet.wear = 15;
        bullet.incendiary = 5;
        bullet.doesPenetrate = false;
        PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 400, 0, true);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "vanillaburst");
            data.func_74778_a("mode", "flame");
            data.func_74768_a("count", 15);
            data.func_74780_a("motion", 0.05);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v), new NetworkRegistry.TargetPoint(bulletnt.field_71093_bK, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, 50.0));
        };
        bullet.spentCasing = CASING50BMG.clone().register("50BMGPhos");
        return bullet;
    }

    public static BulletConfiguration get50BMGExplosiveConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.EXPLOSIVE));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 60.0f;
        bullet.dmgMax = 64.0f;
        bullet.wear = 25;
        bullet.explosive = 1.0f;
        bullet.spentCasing = CASING50BMG.clone().register("50BMGExp");
        return bullet;
    }

    public static BulletConfiguration get50BMGAPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.AP));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 62.0f;
        bullet.dmgMax = 68.0f;
        bullet.wear = 15;
        bullet.leadChance = 10;
        bullet.spentCasing = CASING50BMG.clone().register("50BMGAP");
        return bullet;
    }

    public static BulletConfiguration get50BMGDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.DU));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 80.0f;
        bullet.dmgMax = 86.0f;
        bullet.wear = 25;
        bullet.leadChance = 50;
        bullet.spentCasing = CASING50BMG.clone().register("50BMGDU");
        return bullet;
    }

    public static BulletConfiguration get50BMGStarConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.STAR));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 98.0f;
        bullet.dmgMax = 102.0f;
        bullet.wear = 25;
        bullet.leadChance = 100;
        bullet.spentCasing = CASING50BMG.clone().register("50BMGStar");
        return bullet;
    }

    public static BulletConfiguration get50BMGSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.SLEEK));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 70.0f;
        bullet.wear = 10;
        bullet.leadChance = 100;
        bullet.doesPenetrate = false;
        bullet.bntHit = (bulletnt, hit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            EntityBulletBaseNT meteor = new EntityBulletBaseNT(bulletnt.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
            meteor.func_70107_b(hit.field_70165_t, hit.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), hit.field_70161_v);
            meteor.field_70181_x = -1.0;
            meteor.setThrower(bulletnt.getThrower());
            bulletnt.field_70170_p.func_72838_d((Entity)meteor);
        };
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            if (y == -1) {
                return;
            }
            EntityBulletBaseNT meteor = new EntityBulletBaseNT(bulletnt.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
            meteor.func_70107_b(bulletnt.field_70165_t, bulletnt.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), bulletnt.field_70161_v);
            meteor.field_70181_x = -1.0;
            meteor.setThrower(bulletnt.getThrower());
            bulletnt.field_70170_p.func_72838_d((Entity)meteor);
        };
        bullet.spentCasing = CASING50BMG.clone().register("50BMGIF");
        return bullet;
    }

    public static BulletConfiguration get50BMGFlechetteConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.FLECHETTE));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 54.0f;
        bullet.style = 2;
        BulletConfigFactory.makeFlechette(bullet);
        bullet.spentCasing = CASING50BMG.clone().register("50BMGFlech");
        return bullet;
    }

    public static BulletConfiguration get50BMGFlechetteAMConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.FLECHETTE_AM));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 60.0f;
        bullet.dmgMax = 64.0f;
        bullet.style = 2;
        BulletConfigFactory.makeFlechette(bullet);
        bullet.bntHit = (bulletnt, hit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            if (hit instanceof EntityLivingBase) {
                ContaminationUtil.contaminate((EntityLivingBase)hit, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 100.0f);
            }
        };
        bullet.spentCasing = CASING50BMG.clone().register("50BMGAM");
        return bullet;
    }

    public static BulletConfiguration get50BMGFlechettePOConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.FLECHETTE_PO));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 60.0f;
        bullet.dmgMax = 64.0f;
        bullet.style = 2;
        BulletConfigFactory.makeFlechette(bullet);
        bullet.bntHit = (bulletnt, hit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            if (hit instanceof EntityLivingBase) {
                ContaminationUtil.contaminate((EntityLivingBase)hit, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 50.0f);
            }
        };
        bullet.spentCasing = CASING50BMG.clone().register("50BMGPO");
        return bullet;
    }
}

