/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.particle.SpentCasing;
import com.hbm.render.util.RenderScreenOverlay;

public class Gun50AEFactory {
    private static final CasingEjector EJECTOR_PISTOL = new CasingEjector().setMotion(-0.3, 0.7, 0.0).setOffset(-0.5, 0.0, 0.5).setAngleRange(0.01f, 0.03f);
    private static final SpentCasing CASING50AE = new SpentCasing(SpentCasing.CasingType.STRAIGHT).setScale(1.5f).setBounceMotion(0.01f, 0.03f).setColor(15450974).setupSmoke(0.25f, 0.5, 60, 20);
    private static float inaccuracy = 5.0E-4f;

    public static GunConfiguration getBaseConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 10;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 7;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CLASSIC;
        config.reloadSound = "hbm:weapon.revolverReload";
        config.firingSound = "hbm:weapon.deagleShoot";
        config.reloadSoundEnd = false;
        return config;
    }

    public static GunConfiguration getDeagleConfig() {
        GunConfiguration config = Gun50AEFactory.getBaseConfig();
        config.durability = 2500;
        config.name = "deagle";
        config.manufacturer = HbmCollection.EnumGunManufacturer.MAGNUM_R_IMI;
        config.absoluteFOV = true;
        config.zoomFOV = 0.5f;
        config.hasSights = true;
        config.config = HbmCollection.ae50;
        config.ejector = EJECTOR_PISTOL;
        return config;
    }

    public static BulletConfiguration get50AEConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50ae.stackFromEnum(ItemAmmoEnums.Ammo50AE.STOCK));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 28.0f;
        bullet.dmgMax = 32.0f;
        bullet.spentCasing = CASING50AE.clone().register("50AEStock");
        return bullet;
    }

    public static BulletConfiguration get50APConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50ae.stackFromEnum(ItemAmmoEnums.Ammo50AE.AP));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 36.0f;
        bullet.leadChance = 10;
        bullet.wear = 15;
        bullet.spentCasing = CASING50AE.clone().register("50AEAP");
        return bullet;
    }

    public static BulletConfiguration get50DUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50ae.stackFromEnum(ItemAmmoEnums.Ammo50AE.DU));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 38.0f;
        bullet.dmgMax = 46.0f;
        bullet.leadChance = 50;
        bullet.wear = 25;
        bullet.spentCasing = CASING50AE.clone().register("50AEDU");
        return bullet;
    }

    public static BulletConfiguration get50StarConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_50ae.stackFromEnum(ItemAmmoEnums.Ammo50AE.STAR));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 52.0f;
        bullet.dmgMax = 60.0f;
        bullet.leadChance = 100;
        bullet.wear = 25;
        bullet.spentCasing = CASING50AE.clone().register("50AEStar");
        return bullet;
    }
}

