/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNT;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.SpentCasing;
import com.hbm.potion.HbmPotion;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.IExtendedEntityProperties;

public class Gun4GaugeFactory {
    private static final CasingEjector EJECTOR_SHOTGUN = new CasingEjector().setMotion(Vec3.func_72443_a((double)-0.4, (double)0.4, (double)0.0)).setOffset(Vec3.func_72443_a((double)-0.5, (double)0.0, (double)0.5)).setAngleRange(0.01f, 0.03f);
    private static final SpentCasing CASING4GAUGE = new SpentCasing(SpentCasing.CasingType.SHOTGUN).setScale(2.5f).setBounceMotion(0.01f, 0.03f);

    private static GunConfiguration getShotgunConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 15;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 4;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.hasSights = true;
        config.absoluteFOV = true;
        config.zoomFOV = 0.5f;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.ejector = EJECTOR_SHOTGUN;
        return config;
    }

    public static GunConfiguration getKS23Config() {
        GunConfiguration config = Gun4GaugeFactory.getShotgunConfig();
        config.durability = 3000;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.revolverShootAlt";
        config.firingPitch = 0.65f;
        config.name = "ks23";
        config.manufacturer = HbmCollection.EnumGunManufacturer.TULSKY;
        config.config = HbmCollection.g4;
        return config;
    }

    public static GunConfiguration getSauerConfig() {
        GunConfiguration config = Gun4GaugeFactory.getShotgunConfig();
        config.rateOfFire = 20;
        config.ammoCap = 0;
        config.reloadType = 0;
        config.firingMode = 1;
        config.durability = 3000;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.sauergun";
        config.firingPitch = 1.0f;
        config.ejector = EJECTOR_SHOTGUN.clone().setDelay(12);
        config.name = "sauer";
        config.manufacturer = HbmCollection.EnumGunManufacturer.CUBE;
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("SAUER_RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.5, 0.0, 0.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 50))).addBus("SAUER_TILT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 30.0, 150)).addKeyframe(new BusAnimationKeyframe(45.0, 0.0, 30.0, 150)).addKeyframe(new BusAnimationKeyframe(45.0, 0.0, 30.0, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 30.0, 150)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 150))).addBus("SAUER_COCK", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 500)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 100)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 100))).addBus("SAUER_SHELL_EJECT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 500))));
        config.config = HbmCollection.g4;
        return config;
    }

    public static BulletConfiguration get4GaugeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.STOCK));
        bullet.dmgMin = 5.0f;
        bullet.dmgMax = 8.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaStock").setColor(16766976, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeSlugConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.SLUG));
        bullet.dmgMin = 25.0f;
        bullet.dmgMax = 32.0f;
        bullet.wear = 7;
        bullet.style = 0;
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaSlug").setColor(14686746, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeFlechetteConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.FLECHETTE));
        bullet.dmgMin = 8.0f;
        bullet.dmgMax = 15.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.wear = 15;
        bullet.style = 2;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        BulletConfigFactory.makeFlechette(bullet);
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaFlech").setColor(1390591, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeFlechettePhosphorusConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.FLECHETTE_PHOSPHORUS));
        bullet.dmgMin = 8.0f;
        bullet.dmgMax = 15.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.wear = 15;
        bullet.style = 2;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        bullet.incendiary = 5;
        PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 400, 0, true);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "vanillaburst");
            data.func_74778_a("mode", "flame");
            data.func_74768_a("count", 15);
            data.func_74780_a("motion", 0.05);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v), new NetworkRegistry.TargetPoint(bulletnt.field_71093_bK, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, 50.0));
        };
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaPhos").setColor(16156442, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeExplosiveConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.EXPLOSIVE));
        bullet.velocity *= 2.0f;
        bullet.gravity *= 2.0;
        bullet.dmgMin = 20.0f;
        bullet.dmgMax = 25.0f;
        bullet.wear = 25;
        bullet.trail = 1;
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaExp").setColor(4162115, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeMiningConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.MINING));
        bullet.velocity *= 2.0f;
        bullet.gravity *= 2.0;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 25;
        bullet.trail = 1;
        bullet.explosive = 0.0f;
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            ExplosionNT explosion = new ExplosionNT(bulletnt.field_70170_p, null, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, 4.0f);
            explosion.atttributes.add(ExplosionNT.ExAttrib.ALLDROP);
            explosion.atttributes.add(ExplosionNT.ExAttrib.NOHURT);
            explosion.func_77278_a();
            explosion.func_77279_a(false);
            ExplosionLarge.spawnParticles(bulletnt.field_70170_p, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, 15);
        };
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaSem").setColor(0x5C5C5C, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeBalefireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.BALEFIRE));
        bullet.velocity *= 2.0f;
        bullet.gravity *= 2.0;
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 65.0f;
        bullet.wear = 25;
        bullet.trail = 1;
        bullet.explosive = 0.0f;
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            ExplosionNT explosion = new ExplosionNT(bulletnt.field_70170_p, null, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, 6.0f);
            explosion.atttributes.add(ExplosionNT.ExAttrib.BALEFIRE);
            explosion.func_77278_a();
            explosion.func_77279_a(false);
            ExplosionLarge.spawnParticles(bulletnt.field_70170_p, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, 30);
        };
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaBale").setColor(8126276, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration getGrenadeKampfConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.KAMPF));
        bullet.spread = 0.0f;
        bullet.gravity = 0.0;
        bullet.wear = 15;
        bullet.explosive = 3.5f;
        bullet.style = 10;
        bullet.trail = 4;
        bullet.vPFX = "smoke";
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaKampf").setColor(15186504, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration getGrenadeCanisterConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.CANISTER));
        bullet.spread = 0.0f;
        bullet.gravity = 0.0;
        bullet.wear = 15;
        bullet.explosive = 1.0f;
        bullet.style = 10;
        bullet.trail = 4;
        bullet.vPFX = "smoke";
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K && bulletnt.field_70173_aa > 10) {
                bulletnt.func_70106_y();
                for (int i = 0; i < 50; ++i) {
                    EntityBulletBaseNT bolt = new EntityBulletBaseNT(bulletnt.field_70170_p, BulletConfigSyncingUtil.M44_AP);
                    bolt.func_70107_b(bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v);
                    bolt.func_70186_c(bulletnt.field_70159_w, bulletnt.field_70181_x, bulletnt.field_70179_y, 0.25f, 0.1f);
                    bolt.setThrower(bulletnt.getThrower());
                    bulletnt.field_70170_p.func_72838_d((Entity)bolt);
                }
            }
        };
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaCan").setColor(0xCACACA, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardAirstrikeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.SLEEK));
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaIF").setColor(0x1D1D1D, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeClawConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.CLAW));
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 9.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.leadChance = 100;
        bullet.bntHurt = (bulletnt, hit) -> {
            EntityLivingBase living;
            float f;
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            if (hit instanceof EntityLivingBase && (f = (living = (EntityLivingBase)hit).func_110143_aJ()) > 0.0f) {
                f = Math.max(0.0f, f - 2.0f);
                living.func_70606_j(f);
                if (f == 0.0f) {
                    living.func_70645_a(ModDamageSource.causeBulletDamage(bulletnt, hit));
                }
            }
        };
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaClaw").setColor(6174924, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeVampireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.VAMPIRE));
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 9.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.leadChance = 100;
        bullet.style = 2;
        bullet.bntHurt = (bulletnt, hit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            if (hit instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)hit;
                IExtendedEntityProperties prop = player.getExtendedProperties("WitcheryExtendedPlayer");
                NBTTagCompound blank = new NBTTagCompound();
                blank.func_74782_a("WitcheryExtendedPlayer", (NBTBase)new NBTTagCompound());
                if (prop != null) {
                    prop.loadNBTData(blank);
                }
            }
        };
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaVamp").setColor(2589696, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeVoidConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.VOID));
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 9.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.leadChance = 0;
        bullet.bntHurt = (bulletnt, hit) -> {
            if (bulletnt.field_70170_p.field_72995_K) {
                return;
            }
            if (hit instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)hit;
                player.field_71071_by.func_70436_m();
                player.field_70170_p.func_72885_a((Entity)bulletnt.getThrower(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 5.0f, true, true);
            }
        };
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaVoid").setColor(0x3F3F3F, 0xD8D8D8);
        return bullet;
    }

    public static BulletConfiguration get4GaugeQuackConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_4gauge.stackFromEnum(ItemAmmoEnums.Ammo4Gauge.QUACK));
        bullet.velocity = (float)((double)bullet.velocity * 2.0);
        bullet.spread = 0.0f;
        bullet.gravity = 0.0;
        bullet.wear = 10;
        bullet.explosive = 1.0f;
        bullet.style = 4;
        bullet.trail = 4;
        bullet.vPFX = "explode";
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K && bulletnt.field_70173_aa % 2 == 0) {
                List creatures = bulletnt.field_70170_p.func_72872_a(EntityCreature.class, bulletnt.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
                for (final EntityCreature creature : creatures) {
                    if (!creature.getClass().getCanonicalName().startsWith("net.minecraft.entity.titan")) continue;
                    BulletConfigFactory.nuclearExplosion((Entity)creature, 0, 0, 0, ExplosionNukeSmall.PARAMS_TOTS);
                    bulletnt.field_70170_p.func_72900_e((Entity)creature);
                    bulletnt.field_70170_p.func_72828_b((List)new ArrayList(){
                        {
                            this.add(creature);
                        }
                    });
                }
            }
        };
        bullet.spentCasing = CASING4GAUGE.clone().register("4GaDucc").setColor(0x1E1E1E, 0xD8D8D8);
        return bullet;
    }
}

