/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.particle.SpentCasing;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import java.util.ArrayList;

public class Gun45ACPFactory {
    private static final SpentCasing CASING45 = new SpentCasing(SpentCasing.CasingType.STRAIGHT).setBounceMotion(0.01f, 0.05f).setScale(1.25f, 1.25f, 1.0f).setColor(15450974).register("45ACP");
    static float inaccuracy = 5.0f;

    public static GunConfiguration getThompsonConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 2;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 30;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_SPLIT;
        config.durability = 5000;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:weapon.rifleShoot";
        config.reloadSoundEnd = false;
        config.name = "tommy";
        config.manufacturer = HbmCollection.EnumGunManufacturer.AUTO_ORDINANCE;
        config.config = new ArrayList<Integer>();
        config.config.addAll(HbmCollection.acp45);
        return config;
    }

    public static GunConfiguration getUACPistolConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 4;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 8;
        config.ammoCap = 16;
        config.durability = 10000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.hasSights = true;
        config.absoluteFOV = true;
        config.zoomFOV = 0.5f;
        config.crosshair = RenderScreenOverlay.Crosshair.CROSS;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:weapon.deagleShoot";
        config.reloadSoundEnd = true;
        config.name = "uacPistol";
        config.manufacturer = HbmCollection.EnumGunManufacturer.UAC;
        config.config.addAll(HbmCollection.acp45);
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("SLIDE", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 10)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, -3.5, 40)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 40))).addBus("HAMMER", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(15.0, 0.0, 0.0, 10)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 40))));
        return config;
    }

    public static GunConfiguration getUACSMGConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 10;
        config.firingDuration = 4;
        config.ammoCap = 40;
        config.durability = 40000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.hasSights = true;
        config.crosshair = RenderScreenOverlay.Crosshair.CROSS;
        config.reloadSound = "hbm:weapon.SMGMagInPB3";
        config.firingSound = "hbm:weapon.SMGFirePB3";
        config.firingPitch = 1.15f;
        config.reloadSoundEnd = true;
        config.name = "uacSMG";
        config.manufacturer = HbmCollection.EnumGunManufacturer.UAC;
        config.config.addAll(HbmCollection.acp45);
        return config;
    }

    public static BulletConfiguration get45AutoConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_45.stackFromEnum(ItemAmmoEnums.Ammo45ACP.STOCK));
        bullet.spread *= inaccuracy;
        bullet.dmgMax = 12.0f;
        bullet.dmgMin = 16.0f;
        bullet.spentCasing = CASING45;
        return bullet;
    }

    public static BulletConfiguration get45AutoAPConfig() {
        BulletConfiguration bullet = Gun45ACPFactory.get45AutoConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_45.stackFromEnum(ItemAmmoEnums.Ammo45ACP.AP));
        bullet.dmgMax = 18.0f;
        bullet.dmgMin = 26.0f;
        bullet.wear = 15;
        bullet.leadChance = 10;
        bullet.spentCasing = CASING45;
        return bullet;
    }

    public static BulletConfiguration get45AutoDUConfig() {
        BulletConfiguration bullet = Gun45ACPFactory.get45AutoConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_45.stackFromEnum(ItemAmmoEnums.Ammo45ACP.DU));
        bullet.dmgMax = 30.0f;
        bullet.dmgMin = 44.0f;
        bullet.wear = 25;
        bullet.leadChance = 50;
        bullet.spentCasing = CASING45;
        return bullet;
    }
}

