/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.particle.EntityBSmokeFX;
import com.hbm.entity.projectile.EntityBoxcar;
import com.hbm.entity.projectile.EntityBuilding;
import com.hbm.entity.projectile.EntityDuchessGambit;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.SpentCasing;
import com.hbm.potion.HbmPotion;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public class Gun44MagnumFactory {
    private static final CasingEjector EJECTOR_PIP = new CasingEjector().setMotion(Vec3.func_72443_a((double)0.0, (double)0.0, (double)-0.05)).setOffset(Vec3.func_72443_a((double)0.0, (double)-0.15, (double)0.0)).setAngleRange(0.01f, 0.05f).setAfterReload().setAmount(6);
    private static final SpentCasing CASING44 = new SpentCasing(SpentCasing.CasingType.STRAIGHT).setScale(1.5f, 1.0f, 1.5f).setBounceMotion(0.01f, 0.05f).setColor(0x3E3E3E);
    public static final ResourceLocation scope_lilmac = new ResourceLocation("hbm", "textures/misc/scope_44.png");

    public static GunConfiguration getBaseConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 10;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 6;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CLASSIC;
        config.reloadSound = "hbm:weapon.revolverReload";
        config.firingSound = "hbm:weapon.revolverShootAlt";
        config.reloadSoundEnd = false;
        config.config.addAll(HbmCollection.m44Normal);
        config.ejector = EJECTOR_PIP;
        return config;
    }

    public static GunConfiguration getNovacConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 2500;
        config.name = "ifHorseshoe";
        config.manufacturer = HbmCollection.EnumGunManufacturer.IF;
        config.comment.add("Fallout New Vegas wasn't THAT good.");
        return config;
    }

    public static GunConfiguration getMacintoshConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 4000;
        config.name = "ifScope";
        config.manufacturer = HbmCollection.EnumGunManufacturer.IF;
        config.comment.add("Poppin' mentats like tic tacs");
        config.allowsInfinity = false;
        config.hasSights = true;
        config.absoluteFOV = true;
        config.zoomFOV = 0.25f;
        config.scopeTexture = scope_lilmac;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.M44_PIP);
        config.config.addAll(HbmCollection.m44Normal);
        return config;
    }

    public static GunConfiguration getBlackjackConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 4000;
        config.ammoCap = 5;
        config.allowsInfinity = false;
        config.name = "ifVanity";
        config.manufacturer = HbmCollection.EnumGunManufacturer.IF;
        config.comment.add("Alcoholism is cool!");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.M44_BJ);
        config.config.addAll(HbmCollection.m44Normal);
        config.ejector = EJECTOR_PIP.clone().setAmount(5);
        return config;
    }

    public static GunConfiguration getSilverConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 4000;
        config.ammoCap = 6;
        config.allowsInfinity = false;
        config.name = "ifStorm";
        config.manufacturer = HbmCollection.EnumGunManufacturer.IF;
        config.comment.add("Our friendship is based on abusive behaviour");
        config.comment.add("and mutual hate. It's not that complicated.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.M44_SILVER);
        config.config.addAll(HbmCollection.m44Normal);
        return config;
    }

    public static GunConfiguration getRedConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 4000;
        config.ammoCap = 8;
        config.allowsInfinity = false;
        config.name = "ifPit";
        config.manufacturer = HbmCollection.EnumGunManufacturer.IF;
        config.comment.add("Explore the other side");
        config.comment.add("...from afar!");
        config.config = new ArrayList<Integer>();
        config.config.addAll(HbmCollection.m44All);
        config.ejector = EJECTOR_PIP.clone().setAmount(64);
        return config;
    }

    public static BulletConfiguration getNoPipConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.STOCK));
        bullet.dmgMin = 18.0f;
        bullet.dmgMax = 26.0f;
        bullet.spentCasing = CASING44.clone().register("44NoPip");
        return bullet;
    }

    public static BulletConfiguration getNoPipAPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.AP));
        bullet.dmgMin = 25.0f;
        bullet.dmgMax = 32.0f;
        bullet.wear = 15;
        bullet.leadChance = 10;
        bullet.spentCasing = CASING44.clone().register("44AP");
        return bullet;
    }

    public static BulletConfiguration getNoPipDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.DU));
        bullet.dmgMin = 28.0f;
        bullet.dmgMax = 40.0f;
        bullet.wear = 25;
        bullet.leadChance = 50;
        bullet.spentCasing = CASING44.clone().register("44DU");
        return bullet;
    }

    public static BulletConfiguration getPhosphorusConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.PHOSPHORUS));
        bullet.dmgMin = 18.0f;
        bullet.dmgMax = 26.0f;
        bullet.wear = 15;
        bullet.incendiary = 5;
        bullet.doesPenetrate = false;
        PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 400, 0, true);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "vanillaburst");
            data.func_74778_a("mode", "flame");
            data.func_74768_a("count", 15);
            data.func_74780_a("motion", 0.05);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v), new NetworkRegistry.TargetPoint(bulletnt.field_71093_bK, bulletnt.field_70165_t, bulletnt.field_70163_u, bulletnt.field_70161_v, 50.0));
        };
        bullet.spentCasing = CASING44.clone().register("44Phos");
        return bullet;
    }

    public static BulletConfiguration getNoPipStarConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.STAR));
        bullet.dmgMin = 42.0f;
        bullet.dmgMax = 50.0f;
        bullet.wear = 25;
        bullet.leadChance = 100;
        bullet.spentCasing = CASING44.clone().register("44Star");
        return bullet;
    }

    public static BulletConfiguration getPipConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.PIP));
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 36.0f;
        bullet.wear = 25;
        bullet.doesPenetrate = false;
        bullet.bntHit = (bulletnt, hit) -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                EntityBoxcar pippo = new EntityBoxcar(bulletnt.field_70170_p);
                pippo.field_70165_t = hit.field_70165_t;
                pippo.field_70163_u = hit.field_70163_u + 50.0;
                pippo.field_70161_v = hit.field_70161_v;
                for (int j = 0; j < 50; ++j) {
                    EntityBSmokeFX fx = new EntityBSmokeFX(bulletnt.field_70170_p, pippo.field_70165_t + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 4.0, pippo.field_70163_u + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 12.0, pippo.field_70161_v + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 4.0, 0.0, 0.0, 0.0);
                    bulletnt.field_70170_p.func_72838_d((Entity)fx);
                }
                bulletnt.field_70170_p.func_72838_d((Entity)pippo);
                bulletnt.field_70170_p.func_72908_a(pippo.field_70165_t, pippo.field_70163_u + 50.0, pippo.field_70161_v, "hbm:alarm.trainHorn", 100.0f, 1.0f);
            }
        };
        bullet.spentCasing = CASING44.clone().register("44Pip").setColor(5450852);
        return bullet;
    }

    public static BulletConfiguration getBJConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.BJ));
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 36.0f;
        bullet.wear = 25;
        bullet.doesPenetrate = false;
        bullet.bntHit = (bulletnt, hit) -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                EntityDuchessGambit pippo = new EntityDuchessGambit(bulletnt.field_70170_p);
                pippo.field_70165_t = hit.field_70165_t;
                pippo.field_70163_u = hit.field_70163_u + 50.0;
                pippo.field_70161_v = hit.field_70161_v;
                for (int j = 0; j < 150; ++j) {
                    EntityBSmokeFX fx = new EntityBSmokeFX(bulletnt.field_70170_p, pippo.field_70165_t + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 7.0, pippo.field_70163_u + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 8.0, pippo.field_70161_v + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 18.0, 0.0, 0.0, 0.0);
                    bulletnt.field_70170_p.func_72838_d((Entity)fx);
                }
                bulletnt.field_70170_p.func_72838_d((Entity)pippo);
                bulletnt.field_70170_p.func_72908_a(pippo.field_70165_t, pippo.field_70163_u + 50.0, pippo.field_70161_v, "hbm:weapon.boat", 100.0f, 1.0f);
            }
        };
        bullet.spentCasing = CASING44.clone().register("44BJ").setColor(6499116);
        return bullet;
    }

    public static BulletConfiguration getSilverStormConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.SILVER));
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 36.0f;
        bullet.wear = 25;
        bullet.doesPenetrate = false;
        bullet.bntHit = (bulletnt, hit) -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                EntityBuilding pippo = new EntityBuilding(bulletnt.field_70170_p);
                pippo.field_70165_t = hit.field_70165_t;
                pippo.field_70163_u = hit.field_70163_u + 50.0;
                pippo.field_70161_v = hit.field_70161_v;
                for (int j = 0; j < 150; ++j) {
                    EntityBSmokeFX fx = new EntityBSmokeFX(bulletnt.field_70170_p, pippo.field_70165_t + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 15.0, pippo.field_70163_u + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 15.0, pippo.field_70161_v + (bulletnt.field_70170_p.field_73012_v.nextDouble() - 0.5) * 15.0, 0.0, 0.0, 0.0);
                    bulletnt.field_70170_p.func_72838_d((Entity)fx);
                }
                bulletnt.field_70170_p.func_72838_d((Entity)pippo);
                bulletnt.field_70170_p.func_72908_a(pippo.field_70165_t, pippo.field_70163_u + 50.0, pippo.field_70161_v, "hbm:block.debris", 100.0f, 1.0f);
            }
        };
        bullet.spentCasing = CASING44.clone().register("44Silver").setColor(2840931);
        return bullet;
    }

    public static BulletConfiguration getRocketConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_44.stackFromEnum(ItemAmmoEnums.Ammo44Magnum.ROCKET));
        bullet.velocity = 5.0f;
        bullet.explosive = 15.0f;
        bullet.trail = 1;
        bullet.spentCasing = CASING44.clone().register("44Rocket");
        return bullet;
    }
}

