/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.particle.SpentCasing;
import com.hbm.render.util.RenderScreenOverlay;

public class Gun22LRFactory {
    private static final CasingEjector EJECTOR_22LR = new CasingEjector().setMotion(-0.4, 0.1, 0.0).setOffset(-0.35, -0.2, 0.35).setAngleRange(0.01f, 0.03f);
    private static final SpentCasing CASING22LR = new SpentCasing(SpentCasing.CasingType.STRAIGHT).setScale(0.8f).setBounceMotion(0.05f, 0.02f).setColor(15450974);
    static float inaccuracy = 5.0f;

    public static GunConfiguration getUziConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 32;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CROSS;
        config.durability = 3000;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:weapon.uziShoot";
        config.reloadSoundEnd = false;
        config.name = "uzi";
        config.manufacturer = HbmCollection.EnumGunManufacturer.IMI;
        config.comment.add("Mom, where are my mittens?");
        config.config = HbmCollection.lr22;
        config.ejector = EJECTOR_22LR;
        return config;
    }

    public static GunConfiguration getSaturniteConfig() {
        GunConfiguration config = Gun22LRFactory.getUziConfig();
        config.durability = 4500;
        config.name = "uziSatur";
        config.manufacturer = HbmCollection.EnumGunManufacturer.IMI_BIGMT;
        config.config = HbmCollection.lr22Inc;
        return config;
    }

    public static BulletConfiguration get22LRConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_22lr.stackFromEnum(ItemAmmoEnums.Ammo22LR.STOCK));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 8.0f;
        bullet.spentCasing = CASING22LR.clone().register("22LRStock");
        return bullet;
    }

    public static BulletConfiguration get22LRAPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardPistolConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_22lr.stackFromEnum(ItemAmmoEnums.Ammo22LR.AP));
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 12.0f;
        bullet.dmgMax = 16.0f;
        bullet.leadChance = 10;
        bullet.wear = 15;
        bullet.spentCasing = CASING22LR.clone().register("22LRAP");
        return bullet;
    }
}

