/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.particle.SpentCasing;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Vec3;

public class Gun20GaugeFactory {
    private static final CasingEjector EJECTOR_SHOTGUN = new CasingEjector().setMotion(Vec3.func_72443_a((double)-0.4, (double)0.95, (double)0.0)).setOffset(Vec3.func_72443_a((double)-0.55, (double)0.0, (double)0.5)).setAngleRange(0.01f, 0.05f);
    private static final SpentCasing CASING20GAUGE = new SpentCasing(SpentCasing.CasingType.SHOTGUN).setScale(1.25f).setBounceMotion(0.01f, 0.05f).setupSmoke(0.25f, 0.5, 60, 20);

    public static GunConfiguration getShotgunConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 25;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 6;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("LEVER_ROTATE", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 250)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 45.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 500))).addBus("LEVER_RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.5, 0.0, 0.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 150)).addKeyframe(new BusAnimationKeyframe(0.0, -0.5, 0.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 500))));
        config.config = HbmCollection.g20;
        config.ejector = EJECTOR_SHOTGUN;
        return config;
    }

    public static GunConfiguration getMareConfig() {
        GunConfiguration config = Gun20GaugeFactory.getShotgunConfig();
        config.durability = 2000;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.revolverShootAlt";
        config.firingPitch = 0.75f;
        config.hasSights = true;
        config.zoomFOV = 0.75f;
        config.name = "win1887";
        config.manufacturer = HbmCollection.EnumGunManufacturer.WINCHESTER;
        config.config = HbmCollection.g20;
        return config;
    }

    public static GunConfiguration getMareDarkConfig() {
        GunConfiguration config = Gun20GaugeFactory.getShotgunConfig();
        config.durability = 2500;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.revolverShootAlt";
        config.firingPitch = 0.75f;
        config.hasSights = true;
        config.zoomFOV = 0.75f;
        config.name = "win1887Inox";
        config.manufacturer = HbmCollection.EnumGunManufacturer.WINCHESTER;
        config.config = HbmCollection.g20;
        return config;
    }

    public static BulletConfiguration get20GaugeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.STOCK));
        bullet.dmgMin = 3.0f;
        bullet.dmgMax = 5.0f;
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaStock").setColor(0xB52B2B, 15450974);
        return bullet;
    }

    public static BulletConfiguration get20GaugeSlugConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.SLUG));
        bullet.dmgMin = 18.0f;
        bullet.dmgMax = 22.0f;
        bullet.wear = 7;
        bullet.style = 0;
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaSlug").setColor(0x2A2A2A, 15450974);
        return bullet;
    }

    public static BulletConfiguration get20GaugeFlechetteConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.FLECHETTE));
        bullet.dmgMin = 8.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 15;
        bullet.style = 2;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        BulletConfigFactory.makeFlechette(bullet);
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaFlech").setColor(2639871, 15450974);
        return bullet;
    }

    public static BulletConfiguration get20GaugeFireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.INCENDIARY));
        bullet.dmgMin = 3.0f;
        bullet.dmgMax = 6.0f;
        bullet.wear = 15;
        bullet.incendiary = 5;
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaInc").setColor(16737065, 15450974).setupSmoke(1.0f, 0.5, 60, 40);
        return bullet;
    }

    public static BulletConfiguration get20GaugeShrapnelConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.SHRAPNEL));
        bullet.wear = 15;
        bullet.dmgMin = 7.0f;
        bullet.dmgMax = 12.0f;
        bullet.ricochetAngle = 15.0;
        bullet.HBRC = 80;
        bullet.LBRC = 95;
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaShrap").setColor(15788032, 15450974);
        return bullet;
    }

    public static BulletConfiguration get20GaugeExplosiveConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.EXPLOSIVE));
        bullet.dmgMin = 7.0f;
        bullet.dmgMax = 12.0f;
        bullet.wear = 25;
        bullet.explosive = 0.5f;
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaExp").setColor(15788032, 15450974);
        return bullet;
    }

    public static BulletConfiguration get20GaugeCausticConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.CAUSTIC));
        bullet.dmgMin = 3.0f;
        bullet.dmgMax = 7.0f;
        bullet.wear = 25;
        bullet.caustic = 5;
        bullet.doesRicochet = false;
        bullet.HBRC = 0;
        bullet.LBRC = 0;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 1));
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaCaus").setColor(6612992, 15450974);
        return bullet;
    }

    public static BulletConfiguration get20GaugeShockConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.SHOCK));
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 8.0f;
        bullet.wear = 25;
        bullet.emp = 2;
        bullet.doesRicochet = false;
        bullet.HBRC = 0;
        bullet.LBRC = 0;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 1));
        bullet.effects.add(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 4));
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaShock").setColor(61423, 15450974);
        return bullet;
    }

    public static BulletConfiguration get20GaugeWitherConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.WITHER));
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 8.0f;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(Potion.field_82731_v.field_76415_H, 200, 2));
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaWith").setColor(3741463, 15450974);
        return bullet;
    }

    public static BulletConfiguration get20GaugeSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardAirstrikeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.SLEEK));
        bullet.spentCasing = CASING20GAUGE.clone().register("20GaIF").setColor(0x2A2A2A, 15450974);
        return bullet;
    }
}

