/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmCollection;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.SpentCasing;
import com.hbm.potion.HbmPotion;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class Gun12GaugeFactory {
    private static final CasingEjector EJECTOR_SPAS = new CasingEjector().setMotion(-0.4, 0.1, 0.0).setOffset(-0.35, 0.0, 0.5).setAngleRange(0.01f, 0.03f).setDelay(12);
    private static final CasingEjector EJECTOR_SPAS_ALT = new CasingEjector().setMotion(-0.4, 0.1, 0.0).setOffset(-0.35, 0.0, 0.5).setAngleRange(0.01f, 0.03f).setDelay(12).setAmount(2);
    private static final CasingEjector EJECTOR_BENELLI = new CasingEjector().setMotion(-0.4, 0.1, 0.0).setOffset(-0.3, 1.0, 0.0).setAngleRange(0.01f, 0.03f);
    private static final CasingEjector EJECTOR_UBOINIK = new CasingEjector().setMotion(-0.4, 0.1, 0.0).setOffset(-0.35, -0.3, 0.5).setAngleRange(0.01f, 0.03f);
    private static final CasingEjector EJECTOR_SSG = new CasingEjector().setMotion(0.2, 0.0, -0.2).setOffset(0.8, 0.0, 0.0).setAngleRange(0.05f, 0.02f).setDelay(20).setAmount(2);
    private static final SpentCasing CASING12GAUGE = new SpentCasing(SpentCasing.CasingType.SHOTGUN).setScale(1.5f).setBounceMotion(0.05f, 0.02f).setupSmoke(0.5f, 0.5, 60, 20);

    public static GunConfiguration getRemington870Config() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 25;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 5;
        config.ammoCap = 5;
        config.durability = 1000;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.CIRCLE;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.shotgunPump";
        config.name = "remington870";
        config.manufacturer = HbmCollection.EnumGunManufacturer.REMINGTON;
        config.config = HbmCollection.g12hs;
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("RECOIL_TRANSLATE", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, -2.0, 100)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))).addBus("PUMP", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 450)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, -1.8, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))));
        config.ejector = EJECTOR_SPAS;
        return config;
    }

    public static GunConfiguration getSpas12Config() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 25;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 5;
        config.ammoCap = 8;
        config.durability = 2500;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.CIRCLE;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.shotgunPump";
        config.name = "spas12";
        config.manufacturer = HbmCollection.EnumGunManufacturer.BLACK_MESA;
        config.comment.add("\"Here, I have a more suitable gun for you. You'll need it - Catch!\"");
        config.comment.add("Alt-fire with Mouse 2 (Right-click) to fire 2 shells at once");
        config.config = HbmCollection.g12;
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("SPAS_RECOIL_TRANSLATE", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, -2.0, 100)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))).addBus("SPAS_RECOIL_ROT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(-1.0, 0.0, 1.0, 100)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))).addBus("SPAS_PUMP", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 450)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, -1.8, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))));
        config.ejector = EJECTOR_SPAS;
        return config;
    }

    public static GunConfiguration getSpas12AltConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 35;
        config.roundsPerCycle = 2;
        config.gunMode = 0;
        config.firingMode = 0;
        config.firingDuration = 10;
        config.ammoCap = 8;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.shotgunPump";
        config.reloadType = 2;
        config.config = HbmCollection.g12hs;
        config.ejector = EJECTOR_SPAS_ALT;
        return config;
    }

    public static GunConfiguration getUboinikConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 8;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 6;
        config.durability = 1500;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.reloadSound = "hbm:weapon.revolverReload";
        config.firingSound = "hbm:weapon.shotgunShoot";
        config.name = "uboinik";
        config.manufacturer = HbmCollection.EnumGunManufacturer.METRO;
        config.config = HbmCollection.g12hs;
        config.ejector = EJECTOR_UBOINIK;
        return config;
    }

    public static GunConfiguration getShottyConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 2;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 0;
        config.durability = 3000;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.hasSights = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.reloadSound = "hbm:weapon.revolverReload";
        config.firingSound = "hbm:weapon.shottyShoot";
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("SHOTTY_RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.5, 0.0, 0.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 50))).addBus("SHOTTY_BREAK", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 100)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 60.0, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 60.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))).addBus("SHOTTY_EJECT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 700))).addBus("SHOTTY_INSERT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 1.0, 0)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 350)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 150))));
        config.name = "supershotty";
        config.manufacturer = HbmCollection.EnumGunManufacturer.UAC;
        config.comment.add("God-damned ARCH-VILES!");
        config.config = HbmCollection.g12hs;
        config.ejector = EJECTOR_SSG;
        return config;
    }

    public static GunConfiguration getBenelliConfig() {
        GunConfiguration config = Gun12GaugeFactory.getUboinikConfig();
        config.gunMode = 0;
        config.firingMode = 1;
        config.rateOfFire = 5;
        config.ammoCap = 8;
        config.reloadDuration = 8;
        config.crosshair = RenderScreenOverlay.Crosshair.CIRCLE;
        config.hasSights = true;
        config.durability = 250000;
        config.allowsInfinity = true;
        config.firingSound = "hbm:weapon.deagleShoot";
        config.firingPitch = 0.75f;
        config.reloadType = 2;
        config.reloadSoundEnd = true;
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(6.25, 0.25, 2.5, 55)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 55))).addBus("EJECT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 25)).addKeyframe(new BusAnimationKeyframe(25.0, 0.0, 0.0, 100))));
        config.animations.put(HbmAnimations.AnimType.RELOAD, new BusAnimation().addBus("RELOAD", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(60.0, 0.0, -10.0, 400)).addKeyframe(new BusAnimationKeyframe(60.0, 125.0, -10.0, 200)).addKeyframe(new BusAnimationKeyframe(60.0, 125.0, -10.0, 300)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300))).addBus("PUMP", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 900)).addKeyframe(new BusAnimationKeyframe(10.0, 0.0, 0.0, 200)).addKeyframe(new BusAnimationKeyframe())));
        config.name = "benelli";
        config.manufacturer = HbmCollection.EnumGunManufacturer.BENELLI;
        config.comment.add("Eat your heart out SPAS-12");
        config.config = HbmCollection.g12;
        config.ejector = EJECTOR_BENELLI;
        return config;
    }

    public static GunConfiguration getBenelliModConfig() {
        GunConfiguration config = Gun12GaugeFactory.getBenelliConfig();
        config.reloadType = 1;
        config.ammoCap = 24;
        config.reloadDuration = 20;
        config.reloadSound = "hbm:weapon.magReload";
        config.reloadSoundEnd = true;
        config.name = config.name + "Drum";
        return config;
    }

    public static BulletConfiguration get12GaugeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.STOCK));
        bullet.dmgMin = 5.0f;
        bullet.dmgMax = 7.0f;
        bullet.spentCasing = CASING12GAUGE.clone().register("12GaStock").setColor(2639871, 0x757575);
        return bullet;
    }

    public static BulletConfiguration get12GaugeFireConfig() {
        BulletConfiguration bullet = Gun12GaugeFactory.get12GaugeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.INCENDIARY));
        bullet.wear = 15;
        bullet.dmgMin = 5.0f;
        bullet.dmgMax = 7.0f;
        bullet.incendiary = 5;
        bullet.spentCasing = CASING12GAUGE.clone().register("12GaInc").setColor(16737065, 0x757575).setupSmoke(1.0f, 0.5, 60, 40);
        return bullet;
    }

    public static BulletConfiguration get12GaugeShrapnelConfig() {
        BulletConfiguration bullet = Gun12GaugeFactory.get12GaugeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.SHRAPNEL));
        bullet.wear = 15;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 17.0f;
        bullet.ricochetAngle = 15.0;
        bullet.HBRC = 80;
        bullet.LBRC = 95;
        bullet.spentCasing = CASING12GAUGE.clone().register("12GaShrap").setColor(15788032, 0x757575);
        return bullet;
    }

    public static BulletConfiguration get12GaugeDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.DU));
        bullet.wear = 20;
        bullet.dmgMin = 18.0f;
        bullet.dmgMax = 22.0f;
        bullet.doesPenetrate = true;
        bullet.leadChance = 50;
        bullet.spentCasing = CASING12GAUGE.clone().register("12GaDU").setColor(6464354, 0x757575);
        return bullet;
    }

    public static BulletConfiguration get12GaugeAMConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.MARAUDER));
        bullet.wear = 20;
        bullet.dmgMin = 100.0f;
        bullet.dmgMax = 500.0f;
        bullet.leadChance = 50;
        bullet.bntHurt = (bulletnt, hit) -> {
            if (hit instanceof EntityLivingBase) {
                ((EntityLivingBase)hit).func_70690_d(new PotionEffect(HbmPotion.bang.field_76415_H, 20, 0));
            }
        };
        bullet.spentCasing = CASING12GAUGE.clone().register("12GaAM").setColor(4286021, 0x757575);
        return bullet;
    }

    public static BulletConfiguration get12GaugeSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardAirstrikeConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.SLEEK));
        bullet.spentCasing = CASING12GAUGE.clone().register("12GaIF").setColor(0x2A2A2A, 0x757575);
        return bullet;
    }

    public static BulletConfiguration get12GaugePercussionConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.PERCUSSION));
        bullet.velocity = 2.0f;
        bullet.spread = 0.0f;
        bullet.wear = 10;
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 30.0f;
        bullet.maxAge = 0;
        bullet.spentCasing = CASING12GAUGE.clone().register("12GaPerc").setColor(10360342, 0x757575).setupSmoke(1.0f, 0.5, 60, 40);
        bullet.bntUpdate = bulletnt -> {
            if (!bulletnt.field_70170_p.field_72995_K) {
                Vec3 vec = Vec3.func_72443_a((double)bulletnt.field_70159_w, (double)bulletnt.field_70181_x, (double)bulletnt.field_70179_y);
                double radius = 4.0;
                double x = bulletnt.field_70165_t + vec.field_72450_a;
                double y = bulletnt.field_70163_u + vec.field_72448_b;
                double z = bulletnt.field_70161_v + vec.field_72449_c;
                AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(radius, radius, radius);
                List list = bulletnt.field_70170_p.func_72839_b((Entity)bulletnt.getThrower(), aabb);
                for (Entity e : list) {
                    DamageSource source = bulletnt.getThrower() instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)bulletnt.getThrower())) : DamageSource.field_76376_m;
                    e.func_70097_a(source, 30.0f);
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "plasmablast");
                data.func_74776_a("r", 0.75f);
                data.func_74776_a("g", 0.75f);
                data.func_74776_a("b", 0.75f);
                data.func_74776_a("pitch", -bulletnt.field_70125_A + 90.0f);
                data.func_74776_a("yaw", bulletnt.field_70177_z);
                data.func_74776_a("scale", 2.0f);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, x, y, z), new NetworkRegistry.TargetPoint(bulletnt.field_71093_bK, x, y, z, 100.0));
                bulletnt.func_70106_y();
            }
        };
        return bullet;
    }
}

