/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.particle.EntityBSmokeFX;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.BobMathUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class BulletConfigFactory {
    public static final float defaultSpread = 0.005f;

    public static BulletConfiguration getTestConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = new RecipesCommon.ComparableStack(ModItems.ammo_357.stackFromEnum(ItemAmmoEnums.Ammo357Magnum.LEAD));
        bullet.velocity = 5.0f;
        bullet.spread = 0.05f;
        bullet.wear = 10;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 17.0f;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 10.0;
        bullet.HBRC = 2;
        bullet.LBRC = 90;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = true;
        bullet.style = 0;
        bullet.plink = 1;
        return bullet;
    }

    public static BulletConfiguration standardBulletConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 5.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 5.0;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = true;
        bullet.destroysBlocks = false;
        bullet.style = 0;
        bullet.plink = 1;
        bullet.leadChance = 5;
        return bullet;
    }

    public static BulletConfiguration standardPistolConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.style = 1;
        bullet.plink = 1;
        return bullet;
    }

    public static BulletConfiguration standardBuckshotConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 5.0f;
        bullet.spread = 0.049999997f;
        bullet.wear = 10;
        bullet.bulletsMin = 6;
        bullet.bulletsMax = 8;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 5.0;
        bullet.HBRC = 10;
        bullet.LBRC = 95;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = true;
        bullet.style = 3;
        bullet.plink = 1;
        bullet.leadChance = 10;
        return bullet;
    }

    public static BulletConfiguration standardAirstrikeConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 5.0f;
        bullet.spread = 0.0f;
        bullet.wear = 50;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.style = 4;
        bullet.leadChance = 0;
        bullet.vPFX = "reddust";
        bullet.bntImpact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                Random rand = bullet.field_70170_p.field_73012_v;
                int count = rand.nextInt(11) + 95;
                for (int i = 0; i < count; ++i) {
                    double dx = bullet.field_70165_t + rand.nextGaussian() * 4.0;
                    double dy = bullet.field_70163_u + 25.0 + rand.nextGaussian() * 5.0;
                    double dz = bullet.field_70161_v + rand.nextGaussian() * 4.0;
                    Vec3 motion = Vec3.func_72443_a((double)(bullet.field_70165_t - dx), (double)(bullet.field_70163_u - dy), (double)(bullet.field_70161_v - dz));
                    motion = motion.func_72432_b();
                    EntityBulletBaseNT bolt = new EntityBulletBaseNT(bullet.field_70170_p, BulletConfigSyncingUtil.R556_FLECHETTE_DU);
                    bolt.func_70107_b(dx, dy, dz);
                    bolt.func_70186_c(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, 0.5f, 0.1f);
                    bolt.setThrower(bullet.getThrower());
                    bullet.field_70170_p.func_72838_d((Entity)bolt);
                    if (i >= 30) continue;
                    EntityBSmokeFX bsmoke = new EntityBSmokeFX(bullet.field_70170_p);
                    bsmoke.func_70107_b(dx, dy, dz);
                    bullet.field_70170_p.func_72838_d((Entity)bsmoke);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration standardRocketConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 2.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.005;
        bullet.maxAge = 300;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 10.0;
        bullet.HBRC = 2;
        bullet.LBRC = 100;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.explosive = 5.0f;
        bullet.style = 6;
        bullet.plink = 2;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static BulletConfiguration standardGrenadeConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 2.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.035;
        bullet.maxAge = 300;
        bullet.doesRicochet = false;
        bullet.ricochetAngle = 0.0;
        bullet.HBRC = 0;
        bullet.LBRC = 0;
        bullet.bounceMod = 1.0;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.explosive = 2.5f;
        bullet.style = 10;
        bullet.plink = 2;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static BulletConfiguration standardShellConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 3.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.005;
        bullet.maxAge = 300;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 10.0;
        bullet.HBRC = 2;
        bullet.LBRC = 100;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.style = 10;
        bullet.plink = 2;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static BulletConfiguration standardNukeConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 3.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 1000.0f;
        bullet.dmgMax = 1000.0f;
        bullet.gravity = 0.025;
        bullet.maxAge = 300;
        bullet.doesRicochet = false;
        bullet.ricochetAngle = 0.0;
        bullet.HBRC = 0;
        bullet.LBRC = 0;
        bullet.bounceMod = 1.0;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = 8;
        bullet.plink = 2;
        return bullet;
    }

    public static void nuclearExplosion(Entity entity, int x, int y, int z, ExplosionNukeSmall.MukeParams params) {
        if (!entity.field_70170_p.field_72995_K) {
            double posX = entity.field_70165_t;
            double posY = entity.field_70163_u + 0.5;
            double posZ = entity.field_70161_v;
            if (y >= 0) {
                posX = (double)x + 0.5;
                posY = (double)y + 1.5;
                posZ = (double)z + 0.5;
            }
            ExplosionNukeSmall.explode(entity.field_70170_p, posX, posY, posZ, params);
        }
    }

    public static void makeFlechette(BulletConfiguration bullet) {
        bullet.bntImpact = (bulletnt, x, y, z, sideHit) -> bulletnt.getStuck(x, y, z, sideHit);
    }

    public static EntityBulletBaseNT.IBulletImpactBehaviorNT getPhosphorousEffect(final int radius, final int duration, final int count, final double motion, final float hazeChance) {
        EntityBulletBaseNT.IBulletImpactBehaviorNT impact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                List hit = bullet.field_70170_p.func_72839_b((Entity)bullet, AxisAlignedBB.func_72330_a((double)(bullet.field_70165_t - (double)radius), (double)(bullet.field_70163_u - (double)radius), (double)(bullet.field_70161_v - (double)radius), (double)(bullet.field_70165_t + (double)radius), (double)(bullet.field_70163_u + (double)radius), (double)(bullet.field_70161_v + (double)radius)));
                for (Entity e : hit) {
                    if (Library.isObstructed(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) continue;
                    e.func_70015_d(5);
                    if (!(e instanceof EntityLivingBase)) continue;
                    PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, duration, 0, true);
                    eff.getCurativeItems().clear();
                    ((EntityLivingBase)e).func_70690_d(eff);
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", count);
                data.func_74780_a("motion", motion);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
                if (bullet.field_70170_p.field_73012_v.nextFloat() < hazeChance) {
                    NBTTagCompound haze = new NBTTagCompound();
                    haze.func_74778_a("type", "haze");
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(haze, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 150.0));
                }
            }
        };
        return impact;
    }

    public static EntityBulletBaseNT.IBulletImpactBehaviorNT getGasEffect(final int radius, final int duration) {
        EntityBulletBaseNT.IBulletImpactBehaviorNT impact = new EntityBulletBaseNT.IBulletImpactBehaviorNT(){

            @Override
            public void behaveBlockHit(EntityBulletBaseNT bullet, int x, int y, int z, int sideHit) {
                List hit = bullet.field_70170_p.func_72839_b((Entity)bullet, AxisAlignedBB.func_72330_a((double)(bullet.field_70165_t - (double)radius), (double)(bullet.field_70163_u - (double)radius), (double)(bullet.field_70161_v - (double)radius), (double)(bullet.field_70165_t + (double)radius), (double)(bullet.field_70163_u + (double)radius), (double)(bullet.field_70161_v + (double)radius)));
                for (Entity e : hit) {
                    EntityLivingBase entity;
                    if (Library.isObstructed(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v) || !(e instanceof EntityLivingBase) || ArmorRegistry.hasAllProtection(entity = (EntityLivingBase)e, 3, ArmorRegistry.HazardClass.GAS_CHLORINE)) continue;
                    PotionEffect eff0 = new PotionEffect(Potion.field_76436_u.field_76415_H, duration, 2, true);
                    PotionEffect eff1 = new PotionEffect(Potion.field_76419_f.field_76415_H, duration, 2, true);
                    PotionEffect eff2 = new PotionEffect(Potion.field_76437_t.field_76415_H, duration, 4, true);
                    PotionEffect eff3 = new PotionEffect(Potion.field_82731_v.field_76415_H, (int)Math.ceil((double)duration * 0.1), 0, true);
                    eff0.getCurativeItems().clear();
                    eff1.getCurativeItems().clear();
                    eff2.getCurativeItems().clear();
                    eff3.getCurativeItems().clear();
                    entity.func_70690_d(eff0);
                    entity.func_70690_d(eff1);
                    entity.func_70690_d(eff2);
                    entity.func_70690_d(eff3);
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "cloud");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.1);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return impact;
    }

    public static EntityBulletBaseNT.IBulletUpdateBehaviorNT getLaserSteering() {
        EntityBulletBaseNT.IBulletUpdateBehaviorNT onUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                if (bullet.getThrower() == null || !(bullet.getThrower() instanceof EntityPlayer)) {
                    return;
                }
                if (Vec3.func_72443_a((double)(bullet.field_70165_t - bullet.getThrower().field_70165_t), (double)(bullet.field_70163_u - bullet.getThrower().field_70163_u), (double)(bullet.field_70161_v - bullet.getThrower().field_70161_v)).func_72433_c() > 100.0) {
                    return;
                }
                MovingObjectPosition mop = Library.rayTrace((EntityPlayer)bullet.getThrower(), 200.0, 1.0f);
                if (mop == null || mop.field_72307_f == null) {
                    return;
                }
                Vec3 vec = Vec3.func_72443_a((double)(mop.field_72307_f.field_72450_a - bullet.field_70165_t), (double)(mop.field_72307_f.field_72448_b - bullet.field_70163_u), (double)(mop.field_72307_f.field_72449_c - bullet.field_70161_v));
                if (vec.func_72433_c() < 3.0) {
                    return;
                }
                vec = vec.func_72432_b();
                double speed = Vec3.func_72443_a((double)bullet.field_70159_w, (double)bullet.field_70181_x, (double)bullet.field_70179_y).func_72433_c();
                bullet.field_70159_w = vec.field_72450_a * speed;
                bullet.field_70181_x = vec.field_72448_b * speed;
                bullet.field_70179_y = vec.field_72449_c * speed;
            }
        };
        return onUpdate;
    }

    public static EntityBulletBaseNT.IBulletUpdateBehaviorNT getHomingBehavior(final double range, final double angle) {
        EntityBulletBaseNT.IBulletUpdateBehaviorNT onUpdate = new EntityBulletBaseNT.IBulletUpdateBehaviorNT(){

            @Override
            public void behaveUpdate(EntityBulletBaseNT bullet) {
                Entity target;
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70170_p.func_73045_a(bullet.getEntityData().func_74762_e("homingTarget")) == null) {
                    this.chooseTarget(bullet);
                }
                if ((target = bullet.field_70170_p.func_73045_a(bullet.getEntityData().func_74762_e("homingTarget"))) != null) {
                    Vec3 delta = Vec3.func_72443_a((double)(target.field_70165_t - bullet.field_70165_t), (double)(target.field_70163_u + (double)(target.field_70131_O / 2.0f) - bullet.field_70163_u), (double)(target.field_70161_v - bullet.field_70161_v));
                    delta = delta.func_72432_b();
                    double vel = Vec3.func_72443_a((double)bullet.field_70159_w, (double)bullet.field_70181_x, (double)bullet.field_70179_y).func_72433_c();
                    bullet.field_70159_w = delta.field_72450_a * vel;
                    bullet.field_70181_x = delta.field_72448_b * vel;
                    bullet.field_70179_y = delta.field_72449_c * vel;
                }
            }

            private void chooseTarget(EntityBulletBaseNT bullet) {
                List entities = bullet.field_70170_p.func_72872_a(EntityLivingBase.class, bullet.field_70121_D.func_72314_b(range, range, range));
                Vec3 mot = Vec3.func_72443_a((double)bullet.field_70159_w, (double)bullet.field_70181_x, (double)bullet.field_70179_y);
                EntityLivingBase target = null;
                double targetAngle = angle;
                for (EntityLivingBase e : entities) {
                    double deltaAngle;
                    double dist;
                    if (!e.func_70089_S() || e == bullet.getThrower()) continue;
                    Vec3 delta = Vec3.func_72443_a((double)(e.field_70165_t - bullet.field_70165_t), (double)(e.field_70163_u + (double)(e.field_70131_O / 2.0f) - bullet.field_70163_u), (double)(e.field_70161_v - bullet.field_70161_v));
                    if (bullet.field_70170_p.func_147447_a(Vec3.func_72443_a((double)bullet.field_70165_t, (double)bullet.field_70163_u, (double)bullet.field_70161_v), Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)(e.field_70131_O / 2.0f)), (double)e.field_70161_v), false, true, false) != null || !((dist = e.func_70068_e((Entity)bullet)) < range * range) || !((deltaAngle = BobMathUtil.getCrossAngle(mot, delta)) < targetAngle) || bullet.getConfig().doesPenetrate && bullet.field_70170_p.func_72872_a(EntityLivingBase.class, bullet.field_70121_D.func_72314_b(2.0, 2.0, 2.0)) == null) continue;
                    target = e;
                    targetAngle = deltaAngle;
                }
                if (target != null) {
                    bullet.getEntityData().func_74768_a("homingTarget", target.func_145782_y());
                }
            }
        };
        return onUpdate;
    }

    public static EntityBulletBaseNT.IBulletHurtBehaviorNT getPenHomingBehavior() {
        return (bullet, hit) -> bullet.getEntityData().func_74768_a("homingTarget", 0);
    }
}

