/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBobble;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.items.tool.IItemAbility;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.WeightedRandomObject;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public abstract class WeaponAbility {
    public abstract void onHit(World var1, EntityPlayer var2, Entity var3, IItemAbility var4);

    public abstract String getName();

    public abstract String getFullName();

    public static class BobbleAbility
    extends WeaponAbility {
        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityMob && ((EntityMob)victim).func_110143_aJ() <= 0.0f) {
                EntityMob mob = (EntityMob)victim;
                int chance = 1000;
                if (mob.func_110138_aP() > 20.0f) {
                    chance = 750;
                }
                if (world.field_73012_v.nextInt(chance) == 0) {
                    mob.func_70099_a(new ItemStack(ModBlocks.bobblehead, 1, world.field_73012_v.nextInt(BlockBobble.BobbleType.values().length - 1) + 1), 0.0f);
                }
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.bobble";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }
    }

    public static class BeheaderAbility
    extends WeaponAbility {
        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase && ((EntityLivingBase)victim).func_110143_aJ() <= 0.0f) {
                EntityLivingBase living = (EntityLivingBase)victim;
                if (living instanceof EntitySkeleton) {
                    if (((EntitySkeleton)living).func_82202_m() == 0) {
                        living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 0), 0.0f);
                    } else if (world.field_73012_v.nextInt(20) == 0) {
                        living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 1), 0.0f);
                    } else {
                        living.func_70099_a(new ItemStack(Items.field_151044_h, 3), 0.0f);
                    }
                } else if (living instanceof EntityZombie) {
                    living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 2), 0.0f);
                } else if (living instanceof EntityCreeper) {
                    living.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
                } else if (living instanceof EntityMagmaCube) {
                    living.func_70099_a(new ItemStack(Items.field_151064_bs, 3), 0.0f);
                } else if (living instanceof EntitySlime) {
                    living.func_70099_a(new ItemStack(Items.field_151123_aH, 3), 0.0f);
                } else if (living instanceof EntityPlayer) {
                    ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
                    head.field_77990_d = new NBTTagCompound();
                    head.field_77990_d.func_74778_a("SkullOwner", ((EntityPlayer)living).getDisplayName());
                    living.func_70099_a(head, 0.0f);
                } else {
                    living.func_70099_a(new ItemStack(Items.field_151078_bh, 3, 0), 0.0f);
                    living.func_70099_a(new ItemStack(Items.field_151103_aS, 2, 0), 0.0f);
                }
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.beheader";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }
    }

    public static class ChainsawAbility
    extends WeaponAbility {
        int divider;

        public ChainsawAbility(int divider) {
            this.divider = divider;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            EntityLivingBase living;
            if (victim instanceof EntityLivingBase && (living = (EntityLivingBase)victim).func_110143_aJ() <= 0.0f) {
                WeightedRandom.Item[] ammo = new WeightedRandomObject[]{new WeightedRandomObject(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.STOCK), 10), new WeightedRandomObject(ModItems.ammo_12gauge.stackFromEnum(ItemAmmoEnums.Ammo12Gauge.SHRAPNEL), 5), new WeightedRandomObject(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.STOCK), 10), new WeightedRandomObject(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.FLECHETTE), 5), new WeightedRandomObject(ModItems.ammo_20gauge.stackFromEnum(ItemAmmoEnums.Ammo20Gauge.SLUG), 5), new WeightedRandomObject(ModItems.ammo_9mm.stackFromEnum(ItemAmmoEnums.Ammo9mm.STOCK), 10), new WeightedRandomObject(ModItems.ammo_5mm.stackFromEnum(ItemAmmoEnums.Ammo5mm.STOCK), 10), new WeightedRandomObject(ModItems.ammo_556.stackFromEnum(ItemAmmoEnums.Ammo556mm.STOCK), 10), new WeightedRandomObject(ModItems.ammo_556.stackFromEnum(ItemAmmoEnums.Ammo556mm.FLECHETTE), 10), new WeightedRandomObject(ModItems.ammo_50bmg.stackFromEnum(ItemAmmoEnums.Ammo50BMG.STOCK), 3), new WeightedRandomObject(ModItems.ammo_grenade.stackFromEnum(ItemAmmoEnums.AmmoGrenade.STOCK), 3), new WeightedRandomObject(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.STOCK), 1), new WeightedRandomObject(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.GLARE), 1), new WeightedRandomObject(new ItemStack(ModItems.syringe_metal_stimpak), 20)};
                int count = Math.min((int)Math.ceil(living.func_110138_aP() / (float)this.divider), 250);
                for (int i = 0; i < count; ++i) {
                    living.func_70099_a(((WeightedRandomObject)WeightedRandom.func_76274_a((Random)living.func_70681_au(), (WeightedRandom.Item[])ammo)).asStack(), 1.0f);
                    world.func_72838_d((Entity)new EntityXPOrb(world, living.field_70165_t, living.field_70163_u, living.field_70161_v, 1));
                }
                if (player instanceof EntityPlayerMP) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaburst");
                    data.func_74768_a("count", count * 4);
                    data.func_74780_a("motion", 0.1);
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, living.field_70165_t, living.field_70163_u + (double)living.field_70131_O * 0.5, living.field_70161_v), new NetworkRegistry.TargetPoint(living.field_71093_bK, living.field_70165_t, living.field_70163_u, living.field_70161_v, 50.0));
                }
                world.func_72908_a(living.field_70165_t, living.field_70163_u + (double)living.field_70131_O * 0.5, living.field_70161_v, "hbm:weapon.chainsaw", 0.5f, 1.0f);
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.chainsaw";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (1:" + this.divider + ")";
        }
    }

    public static class FireAbility
    extends WeaponAbility {
        int duration;

        public FireAbility(int duration) {
            this.duration = duration;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                victim.func_70015_d(this.duration);
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.fire";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.duration + ")";
        }
    }

    public static class PhosphorusAbility
    extends WeaponAbility {
        int duration;

        public PhosphorusAbility(int duration) {
            this.duration = duration;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                living.func_70690_d(new PotionEffect(HbmPotion.phosphorus.field_76415_H, this.duration * 20, 4));
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.phosphorus";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.duration + ")";
        }
    }

    public static class StunAbility
    extends WeaponAbility {
        int duration;

        public StunAbility(int duration) {
            this.duration = duration;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                living.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, this.duration * 20, 4));
                living.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, this.duration * 20, 4));
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.stun";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.duration + ")";
        }
    }

    public static class VampireAbility
    extends WeaponAbility {
        float amount;

        public VampireAbility(float amount) {
            this.amount = amount;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                living.func_70606_j(living.func_110143_aJ() - this.amount);
                player.func_70691_i(this.amount);
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.vampire";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.amount + ")";
        }
    }

    public static class RadiationAbility
    extends WeaponAbility {
        float rad;

        public RadiationAbility(float rad) {
            this.rad = rad;
        }

        @Override
        public void onHit(World world, EntityPlayer player, Entity victim, IItemAbility tool) {
            if (victim instanceof EntityLivingBase) {
                ContaminationUtil.contaminate((EntityLivingBase)victim, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, this.rad);
            }
        }

        @Override
        public String getName() {
            return "weapon.ability.radiation";
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + " (" + this.rad + ")";
        }
    }
}

