/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.entity.missile.EntitySiegeDropship;
import com.hbm.entity.mob.siege.EntitySiegeCraft;
import com.hbm.entity.mob.siege.EntitySiegeSkeleton;
import com.hbm.entity.mob.siege.EntitySiegeTunneler;
import com.hbm.entity.mob.siege.EntitySiegeUFO;
import com.hbm.entity.mob.siege.EntitySiegeZombie;
import com.hbm.entity.mob.siege.SiegeTier;
import com.hbm.util.ChatBuilder;
import com.hbm.util.GameRuleHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class SiegeOrchestrator {
    public static boolean lastWave = false;
    public static int level = 0;
    public static int levelCounter = 0;
    public static int siegeMobCount = 0;
    public static final String KEY_SAVE_RULES = "siegeSaveRules";
    public static final String KEY_ENABLE_SIEGES = "siegeEnable";
    public static final String KEY_WAVE_DURATION = "siegeWaveDuration";
    public static final String KEY_PAUSE_DURATION = "siegePauseDuration";
    public static final String KEY_ENABLE_DROPS = "siegeEnableDropships";
    public static final String KEY_ENABLE_SPAWNS = "siegeEnableMobSpawning";
    public static final String KEY_ENABLE_BASES = "siegeEnableBases";
    public static final String KEY_ENABLE_MISSILES = "siegeEnableMissiles";
    public static final String KEY_SPAWN_DIST = "siegeSpawnDist";
    public static final String KEY_SPAWN_DELAY = "siegeSpawnDelay";
    public static final String KEY_TIER_DELAY = "siegeTierDuration";
    public static final String KEY_TIER_ADD_KILL = "siegeTierAddKill";
    public static final String KEY_TIER_ADD_DROP = "siegeTierAddDrop";
    public static final String KEY_TIER_SUB_DEATH = "siegeTierSubDeath";
    public static final String KEY_SPAWN_THRESHOLD = "siegeEnableSpawnThreshold";
    public static final String KEY_SPAWN_THRESHOLD_COUNT = "siegeSpawnThreshold";
    public static final String KEY_EXPANSION_THRESHOLD_COUNT = "siegeExpansionThreshold";

    public static void update(World world) {
        boolean wave;
        if (world.field_72995_K || !SiegeOrchestrator.siegeEnabled(world)) {
            return;
        }
        int waveTime = SiegeOrchestrator.getWaveDuration(world);
        int pauseTime = SiegeOrchestrator.getPauseDuration(world);
        int interval = waveTime + pauseTime;
        boolean bl = wave = (int)(world.func_82737_E() % (long)interval) >= pauseTime;
        if (!lastWave && wave) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)ChatBuilder.start("[SIEGE MODE] A new wave is starting!").color(EnumChatFormatting.RED).flush());
        } else if (lastWave && !wave) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)ChatBuilder.start("[SIEGE MODE] The wave has ended!").color(EnumChatFormatting.RED).flush());
        }
        lastWave = wave;
        if (!wave) {
            return;
        }
        int spawnDelay = SiegeOrchestrator.getSpawnDelay(world);
        boolean threshold = SiegeOrchestrator.spawnThresholdEnabled(world);
        int thresholdSize = SiegeOrchestrator.getSpawnThreshold(world);
        if (!threshold || siegeMobCount <= thresholdSize) {
            for (Object o : world.field_73010_i) {
                EntityPlayer player = (EntityPlayer)o;
                if ((world.func_82737_E() + (long)player.func_145782_y()) % (long)spawnDelay != 0L) continue;
                SiegeOrchestrator.perPlayerSpawn(player);
            }
        }
        int countCap = SiegeOrchestrator.getTierDelay(world);
        int prevLevel = level;
        ++levelCounter;
        while (levelCounter >= countCap) {
            levelCounter -= countCap;
            ++level;
        }
        while (levelCounter < 0) {
            levelCounter += countCap;
            --level;
        }
        if (prevLevel != level) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)ChatBuilder.start("[SIEGE MODE] The siege tier is now " + (level + 1) + "!").color(EnumChatFormatting.RED).flush());
        }
        if (world.func_82737_E() % 200L == 0L) {
            SiegeOrchestrator.refreshMobCount(world);
        }
    }

    public static void perPlayerSpawn(EntityPlayer player) {
        Vec3 vec = Vec3.func_72443_a((double)SiegeOrchestrator.getSpawnDist(player.field_70170_p), (double)0.0, (double)0.0);
        vec.func_72442_b((float)((double)player.func_70681_au().nextFloat() * Math.PI));
        double x = player.field_70165_t + vec.field_72450_a;
        double z = player.field_70161_v + vec.field_72449_c;
        if (SiegeOrchestrator.enableMissileSpawn(player.field_70170_p)) {
            EntitySiegeDropship ship = new EntitySiegeDropship(player.field_70170_p, x, 300.0, z);
            player.field_70170_p.func_72838_d((Entity)ship);
        }
    }

    public static void playerDeathHook(EntityPlayer player, DamageSource source) {
        if (!player.field_70170_p.field_72995_K && SiegeOrchestrator.isSiegeMob(source.func_76346_g())) {
            levelCounter -= SiegeOrchestrator.getTierSubDeath(player.field_70170_p);
        }
    }

    public static void mobDeathHook(EntityLivingBase entity, DamageSource source) {
        if (!entity.field_70170_p.field_72995_K && SiegeOrchestrator.isSiegeMob((Entity)entity)) {
            levelCounter += SiegeOrchestrator.getTierAddKill(entity.field_70170_p);
        }
    }

    public static void spawnRandomMob(World world, double x, double y, double z, EntityPlayer target) {
        Object entity;
        if (world.field_72995_K) {
            return;
        }
        SiegeTier tier = SiegeTier.tiers[level];
        if (tier == null) {
            tier = SiegeTier.DNT;
        }
        float f = world.field_73012_v.nextFloat();
        if (target != null && f < 0.25f && target.field_70163_u + 15.0 < y) {
            entity = new EntitySiegeTunneler(world);
            ((EntitySiegeTunneler)((Object)entity)).setTier(tier);
        } else if (f < 0.1f) {
            entity = new EntitySiegeUFO(world);
            entity.setTier(tier);
        } else if (f < 0.4f) {
            entity = new EntitySiegeSkeleton(world);
            ((EntitySiegeSkeleton)entity).setTier(tier);
        } else {
            entity = new EntitySiegeZombie(world);
            ((EntitySiegeZombie)entity).setTier(tier);
        }
        entity.func_70080_a(x, y, z, (float)Math.PI * 2, 0.0f);
        if (target != null) {
            entity.func_70624_b((EntityLivingBase)target);
        }
        world.func_72838_d((Entity)entity);
    }

    private static void refreshMobCount(World world) {
        siegeMobCount = 0;
        for (Object o : world.field_72996_f) {
            Entity entity = (Entity)o;
            if (!SiegeOrchestrator.isSiegeMob(entity)) continue;
            ++siegeMobCount;
        }
    }

    public static boolean isSiegeMob(Entity entity) {
        if (entity instanceof EntitySiegeZombie) {
            return true;
        }
        if (entity instanceof EntitySiegeSkeleton) {
            return true;
        }
        if (entity instanceof EntitySiegeUFO) {
            return true;
        }
        if (entity instanceof EntitySiegeTunneler) {
            return true;
        }
        return entity instanceof EntitySiegeCraft;
    }

    public static void createGameRules(World world) {
        GameRules rules = world.func_82736_K();
        if (!rules.func_82766_b(KEY_SAVE_RULES)) {
            rules.func_82764_b(KEY_SAVE_RULES, "true");
            rules.func_82764_b(KEY_ENABLE_SIEGES, "false");
            rules.func_82764_b(KEY_WAVE_DURATION, "24000");
            rules.func_82764_b(KEY_PAUSE_DURATION, "12000");
            rules.func_82764_b(KEY_ENABLE_DROPS, "true");
            rules.func_82764_b(KEY_ENABLE_SPAWNS, "false");
            rules.func_82764_b(KEY_ENABLE_BASES, "true");
            rules.func_82764_b(KEY_ENABLE_MISSILES, "true");
            rules.func_82764_b(KEY_SPAWN_DIST, "64");
            rules.func_82764_b(KEY_SPAWN_DELAY, "200");
            rules.func_82764_b(KEY_TIER_DELAY, "18000");
            rules.func_82764_b(KEY_TIER_ADD_KILL, "20");
            rules.func_82764_b(KEY_TIER_SUB_DEATH, "300");
            rules.func_82764_b(KEY_SPAWN_THRESHOLD, "true");
            rules.func_82764_b(KEY_SPAWN_THRESHOLD_COUNT, "50");
            rules.func_82764_b(KEY_EXPANSION_THRESHOLD_COUNT, "20");
        }
    }

    public static boolean siegeEnabled(World world) {
        return world.func_82736_K().func_82766_b(KEY_ENABLE_SIEGES);
    }

    public static int getWaveDuration(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_WAVE_DURATION, 12000, 1);
    }

    public static int getPauseDuration(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_PAUSE_DURATION, 6000, 0);
    }

    public static double getSpawnDist(World world) {
        return GameRuleHelper.getDoubleMinimum(world, KEY_SPAWN_DIST, 64.0, 0.0);
    }

    public static int getSpawnDelay(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_SPAWN_DELAY, 200, 1);
    }

    public static int getTierDelay(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_TIER_DELAY, 18000, 1);
    }

    public static int getTierAddKill(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_TIER_ADD_KILL, 20, 0);
    }

    public static int getTierAddDrop(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_TIER_ADD_DROP, 100, 0);
    }

    public static int getTierSubDeath(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_TIER_SUB_DEATH, 300, 0);
    }

    public static boolean spawnThresholdEnabled(World world) {
        return world.func_82736_K().func_82766_b(KEY_SPAWN_THRESHOLD);
    }

    public static int getSpawnThreshold(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_SPAWN_THRESHOLD_COUNT, 50, 1);
    }

    public static int getExpansionThreshold(World world) {
        return GameRuleHelper.getIntegerMinimum(world, KEY_EXPANSION_THRESHOLD_COUNT, 20, 1);
    }

    public static boolean enableBaseSpawning(World world) {
        return world.func_82736_K().func_82766_b(KEY_ENABLE_BASES);
    }

    public static boolean enableMobSpawning(World world) {
        return world.func_82736_K().func_82766_b(KEY_ENABLE_SPAWNS);
    }

    public static boolean enableMissileSpawn(World world) {
        return world.func_82736_K().func_82766_b(KEY_ENABLE_MISSILES);
    }
}

