/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ItemModCladding;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.potion.HbmPotion;
import com.hbm.util.Compat;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;

public class HazmatRegistry {
    private static HashMap<Item, Double> entries = new HashMap();
    public static final Gson gson = new Gson();

    public static void initDefault() {
        double helmet = 0.2;
        double chest = 0.4;
        double legs = 0.3;
        double boots = 0.1;
        double iron = 0.0225;
        double gold = 0.0225;
        double steel = 0.045;
        double titanium = 0.045;
        double alloy = 0.07;
        double cobalt = 0.125;
        double hazYellow = 0.6;
        double hazRed = 1.0;
        double hazGray = 2.0;
        double paa = 1.7;
        double liquidator = 2.4;
        double t45 = 1.0;
        double ajr = 1.3;
        double bj = 1.0;
        double env = 2.0;
        double hev = 2.3;
        double rpa = 2.0;
        double fau = 4.0;
        double dns = 5.0;
        double security = 0.825;
        double star = 1.0;
        double cmb = 1.3;
        double schrab = 3.0;
        double euph = 10.0;
        HazmatRegistry.registerHazmat(ModItems.hazmat_helmet, hazYellow * helmet);
        HazmatRegistry.registerHazmat(ModItems.hazmat_plate, hazYellow * chest);
        HazmatRegistry.registerHazmat(ModItems.hazmat_legs, hazYellow * legs);
        HazmatRegistry.registerHazmat(ModItems.hazmat_boots, hazYellow * boots);
        HazmatRegistry.registerHazmat(ModItems.hazmat_helmet_red, hazRed * helmet);
        HazmatRegistry.registerHazmat(ModItems.hazmat_plate_red, hazRed * chest);
        HazmatRegistry.registerHazmat(ModItems.hazmat_legs_red, hazRed * legs);
        HazmatRegistry.registerHazmat(ModItems.hazmat_boots_red, hazRed * boots);
        HazmatRegistry.registerHazmat(ModItems.hazmat_helmet_grey, hazGray * helmet);
        HazmatRegistry.registerHazmat(ModItems.hazmat_plate_grey, hazGray * chest);
        HazmatRegistry.registerHazmat(ModItems.hazmat_legs_grey, hazGray * legs);
        HazmatRegistry.registerHazmat(ModItems.hazmat_boots_grey, hazGray * boots);
        HazmatRegistry.registerHazmat(ModItems.liquidator_helmet, liquidator * helmet);
        HazmatRegistry.registerHazmat(ModItems.liquidator_plate, liquidator * chest);
        HazmatRegistry.registerHazmat(ModItems.liquidator_legs, liquidator * legs);
        HazmatRegistry.registerHazmat(ModItems.liquidator_boots, liquidator * boots);
        HazmatRegistry.registerHazmat(ModItems.t45_helmet, t45 * helmet);
        HazmatRegistry.registerHazmat(ModItems.t45_plate, t45 * chest);
        HazmatRegistry.registerHazmat(ModItems.t45_legs, t45 * legs);
        HazmatRegistry.registerHazmat(ModItems.t45_boots, t45 * boots);
        HazmatRegistry.registerHazmat(ModItems.ajr_helmet, ajr * helmet);
        HazmatRegistry.registerHazmat(ModItems.ajr_plate, ajr * chest);
        HazmatRegistry.registerHazmat(ModItems.ajr_legs, ajr * legs);
        HazmatRegistry.registerHazmat(ModItems.ajr_boots, ajr * boots);
        HazmatRegistry.registerHazmat(ModItems.ajro_helmet, ajr * helmet);
        HazmatRegistry.registerHazmat(ModItems.ajro_plate, ajr * chest);
        HazmatRegistry.registerHazmat(ModItems.ajro_legs, ajr * legs);
        HazmatRegistry.registerHazmat(ModItems.ajro_boots, ajr * boots);
        HazmatRegistry.registerHazmat(ModItems.bj_helmet, bj * helmet);
        HazmatRegistry.registerHazmat(ModItems.bj_plate, bj * chest);
        HazmatRegistry.registerHazmat(ModItems.bj_plate_jetpack, bj * chest);
        HazmatRegistry.registerHazmat(ModItems.bj_legs, bj * legs);
        HazmatRegistry.registerHazmat(ModItems.bj_boots, bj * boots);
        HazmatRegistry.registerHazmat(ModItems.steamsuit_helmet, 1.3 * helmet);
        HazmatRegistry.registerHazmat(ModItems.steamsuit_plate, 1.3 * chest);
        HazmatRegistry.registerHazmat(ModItems.steamsuit_legs, 1.3 * legs);
        HazmatRegistry.registerHazmat(ModItems.steamsuit_boots, 1.3 * boots);
        HazmatRegistry.registerHazmat(ModItems.envsuit_helmet, env * helmet);
        HazmatRegistry.registerHazmat(ModItems.envsuit_plate, env * chest);
        HazmatRegistry.registerHazmat(ModItems.envsuit_legs, env * legs);
        HazmatRegistry.registerHazmat(ModItems.envsuit_boots, env * boots);
        HazmatRegistry.registerHazmat(ModItems.hev_helmet, hev * helmet);
        HazmatRegistry.registerHazmat(ModItems.hev_plate, hev * chest);
        HazmatRegistry.registerHazmat(ModItems.hev_legs, hev * legs);
        HazmatRegistry.registerHazmat(ModItems.hev_boots, hev * boots);
        HazmatRegistry.registerHazmat(ModItems.rpa_helmet, rpa * helmet);
        HazmatRegistry.registerHazmat(ModItems.rpa_plate, rpa * chest);
        HazmatRegistry.registerHazmat(ModItems.rpa_legs, rpa * legs);
        HazmatRegistry.registerHazmat(ModItems.rpa_boots, rpa * boots);
        HazmatRegistry.registerHazmat(ModItems.fau_helmet, fau * helmet);
        HazmatRegistry.registerHazmat(ModItems.fau_plate, fau * chest);
        HazmatRegistry.registerHazmat(ModItems.fau_legs, fau * legs);
        HazmatRegistry.registerHazmat(ModItems.fau_boots, fau * boots);
        HazmatRegistry.registerHazmat(ModItems.dns_helmet, dns * helmet);
        HazmatRegistry.registerHazmat(ModItems.dns_plate, dns * chest);
        HazmatRegistry.registerHazmat(ModItems.dns_legs, dns * legs);
        HazmatRegistry.registerHazmat(ModItems.dns_boots, dns * boots);
        HazmatRegistry.registerHazmat(ModItems.paa_plate, paa * chest);
        HazmatRegistry.registerHazmat(ModItems.paa_legs, paa * legs);
        HazmatRegistry.registerHazmat(ModItems.paa_boots, paa * boots);
        HazmatRegistry.registerHazmat(ModItems.hazmat_paa_helmet, paa * helmet);
        HazmatRegistry.registerHazmat(ModItems.hazmat_paa_plate, paa * chest);
        HazmatRegistry.registerHazmat(ModItems.hazmat_paa_legs, paa * legs);
        HazmatRegistry.registerHazmat(ModItems.hazmat_paa_boots, paa * boots);
        HazmatRegistry.registerHazmat(ModItems.security_helmet, security * helmet);
        HazmatRegistry.registerHazmat(ModItems.security_plate, security * chest);
        HazmatRegistry.registerHazmat(ModItems.security_legs, security * legs);
        HazmatRegistry.registerHazmat(ModItems.security_boots, security * boots);
        HazmatRegistry.registerHazmat(ModItems.starmetal_helmet, star * helmet);
        HazmatRegistry.registerHazmat(ModItems.starmetal_plate, star * chest);
        HazmatRegistry.registerHazmat(ModItems.starmetal_legs, star * legs);
        HazmatRegistry.registerHazmat(ModItems.starmetal_boots, star * boots);
        HazmatRegistry.registerHazmat(ModItems.jackt, 0.1);
        HazmatRegistry.registerHazmat(ModItems.jackt2, 0.1);
        HazmatRegistry.registerHazmat(ModItems.gas_mask, 0.07);
        HazmatRegistry.registerHazmat(ModItems.gas_mask_m65, 0.095);
        HazmatRegistry.registerHazmat(ModItems.steel_helmet, steel * helmet);
        HazmatRegistry.registerHazmat(ModItems.steel_plate, steel * chest);
        HazmatRegistry.registerHazmat(ModItems.steel_legs, steel * legs);
        HazmatRegistry.registerHazmat(ModItems.steel_boots, steel * boots);
        HazmatRegistry.registerHazmat(ModItems.titanium_helmet, titanium * helmet);
        HazmatRegistry.registerHazmat(ModItems.titanium_plate, titanium * chest);
        HazmatRegistry.registerHazmat(ModItems.titanium_legs, titanium * legs);
        HazmatRegistry.registerHazmat(ModItems.titanium_boots, titanium * boots);
        HazmatRegistry.registerHazmat(ModItems.cobalt_helmet, cobalt * helmet);
        HazmatRegistry.registerHazmat(ModItems.cobalt_plate, cobalt * chest);
        HazmatRegistry.registerHazmat(ModItems.cobalt_legs, cobalt * legs);
        HazmatRegistry.registerHazmat(ModItems.cobalt_boots, cobalt * boots);
        HazmatRegistry.registerHazmat((Item)Items.field_151028_Y, iron * helmet);
        HazmatRegistry.registerHazmat((Item)Items.field_151030_Z, iron * chest);
        HazmatRegistry.registerHazmat((Item)Items.field_151165_aa, iron * legs);
        HazmatRegistry.registerHazmat((Item)Items.field_151167_ab, iron * boots);
        HazmatRegistry.registerHazmat((Item)Items.field_151169_ag, gold * helmet);
        HazmatRegistry.registerHazmat((Item)Items.field_151171_ah, gold * chest);
        HazmatRegistry.registerHazmat((Item)Items.field_151149_ai, gold * legs);
        HazmatRegistry.registerHazmat((Item)Items.field_151151_aj, gold * boots);
        HazmatRegistry.registerHazmat(ModItems.alloy_helmet, alloy * helmet);
        HazmatRegistry.registerHazmat(ModItems.alloy_plate, alloy * chest);
        HazmatRegistry.registerHazmat(ModItems.alloy_legs, alloy * legs);
        HazmatRegistry.registerHazmat(ModItems.alloy_boots, alloy * boots);
        HazmatRegistry.registerHazmat(ModItems.cmb_helmet, cmb * helmet);
        HazmatRegistry.registerHazmat(ModItems.cmb_plate, cmb * chest);
        HazmatRegistry.registerHazmat(ModItems.cmb_legs, cmb * legs);
        HazmatRegistry.registerHazmat(ModItems.cmb_boots, cmb * boots);
        HazmatRegistry.registerHazmat(ModItems.schrabidium_helmet, schrab * helmet);
        HazmatRegistry.registerHazmat(ModItems.schrabidium_plate, schrab * chest);
        HazmatRegistry.registerHazmat(ModItems.schrabidium_legs, schrab * legs);
        HazmatRegistry.registerHazmat(ModItems.schrabidium_boots, schrab * boots);
        HazmatRegistry.registerHazmat(ModItems.euphemium_helmet, euph * helmet);
        HazmatRegistry.registerHazmat(ModItems.euphemium_plate, euph * chest);
        HazmatRegistry.registerHazmat(ModItems.euphemium_legs, euph * legs);
        HazmatRegistry.registerHazmat(ModItems.euphemium_boots, euph * boots);
        Compat.registerCompatHazmat();
    }

    public static void registerHazmat(Item item, double resistance) {
        entries.put(item, resistance);
    }

    public static double getResistance(ItemStack stack) {
        if (stack == null) {
            return 0.0;
        }
        double cladding = HazmatRegistry.getCladding(stack);
        Double f = entries.get(stack.func_77973_b());
        if (f != null) {
            return f + cladding;
        }
        return cladding;
    }

    public static double getCladding(ItemStack stack) {
        ItemStack[] mods;
        ItemStack cladding;
        if (stack.func_77942_o() && stack.field_77990_d.func_74760_g("hfr_cladding") > 0.0f) {
            return stack.field_77990_d.func_74760_g("hfr_cladding");
        }
        if (ArmorModHandler.hasMods(stack) && (cladding = (mods = ArmorModHandler.pryMods(stack))[5]) != null && cladding.func_77973_b() instanceof ItemModCladding) {
            return ((ItemModCladding)cladding.func_77973_b()).rad;
        }
        return 0.0;
    }

    public static float getResistance(EntityPlayer player) {
        float res = 0.0f;
        if (player.func_110124_au().toString().equals(Library.Pu_238)) {
            res += 0.4f;
        }
        for (int i = 0; i < 4; ++i) {
            res = (float)((double)res + HazmatRegistry.getResistance(player.field_71071_by.field_70460_b[i]));
        }
        if (player.func_70644_a((Potion)HbmPotion.radx)) {
            res += 0.2f;
        }
        return res;
    }

    public static void registerHazmats() {
        File folder = MainRegistry.configHbmDir;
        File config = new File(folder.getAbsolutePath() + File.separatorChar + "hbmRadResist.json");
        File template = new File(folder.getAbsolutePath() + File.separatorChar + "_hbmRadResist.json");
        HazmatRegistry.initDefault();
        if (!config.exists()) {
            HazmatRegistry.writeDefault(template);
        } else {
            HashMap<Item, Double> conf = HazmatRegistry.readConfig(config);
            if (conf != null) {
                entries.clear();
                entries.putAll(conf);
            }
        }
    }

    private static void writeDefault(File file) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("comment").value("Template file, remove the underscore ('_') from the name to enable the config.");
            writer.name("entries").beginArray();
            for (Map.Entry<Item, Double> entry : entries.entrySet()) {
                writer.beginObject();
                writer.name("item").value(Item.field_150901_e.func_148750_c((Object)entry.getKey()));
                writer.name("resistance").value((Number)entry.getValue());
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static HashMap<Item, Double> readConfig(File config) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(config), JsonObject.class);
            JsonArray array = json.get("entries").getAsJsonArray();
            HashMap<Item, Double> conf = new HashMap<Item, Double>();
            for (JsonElement element : array) {
                JsonObject object = (JsonObject)element;
                try {
                    String name = object.get("item").getAsString();
                    Item item = (Item)Item.field_150901_e.func_82594_a(name);
                    double resistance = object.get("resistance").getAsDouble();
                    if (item != null) {
                        conf.put(item, resistance);
                        continue;
                    }
                    MainRegistry.logger.error("Tried loading unknown item " + name + " for hazmat entry.");
                }
                catch (Exception ex) {
                    MainRegistry.logger.error("Encountered " + ex + " trying to read hazmat entry " + element.toString());
                }
            }
            return conf;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

