/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.particle.ParticleSpentCasing;
import com.hbm.particle.SpentCasing;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class CasingEjector
implements Cloneable {
    public static HashMap<Integer, CasingEjector> mappings = new HashMap();
    public static final Random rand = new Random();
    private int id;
    private static int nextId = 0;
    private Vec3 posOffset = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private Vec3 initialMotion = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private int casingAmount = 1;
    private boolean afterReload = false;
    private int delay = 0;
    private float randomYaw = 0.0f;
    private float randomPitch = 0.0f;

    public CasingEjector() {
        this.id = nextId++;
        mappings.put(this.id, this);
    }

    public CasingEjector setOffset(double x, double y, double z) {
        return this.setOffset(Vec3.func_72443_a((double)x, (double)y, (double)z));
    }

    public CasingEjector setOffset(Vec3 vec) {
        this.posOffset = vec;
        return this;
    }

    public CasingEjector setMotion(double x, double y, double z) {
        return this.setMotion(Vec3.func_72443_a((double)x, (double)y, (double)z));
    }

    public CasingEjector setMotion(Vec3 vec) {
        this.initialMotion = vec;
        return this;
    }

    public CasingEjector setAmount(int am) {
        this.casingAmount = am;
        return this;
    }

    public CasingEjector setAfterReload() {
        this.afterReload = true;
        return this;
    }

    public CasingEjector setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public CasingEjector setAngleRange(float yaw, float pitch) {
        this.randomYaw = yaw;
        this.randomPitch = pitch;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public Vec3 getOffset() {
        return this.posOffset;
    }

    public Vec3 getMotion() {
        return this.initialMotion;
    }

    public int getAmount() {
        return this.casingAmount;
    }

    public boolean getAfterReload() {
        return this.afterReload;
    }

    public int getDelay() {
        return this.delay;
    }

    public float getYawFactor() {
        return this.randomYaw;
    }

    public float getPitchFactor() {
        return this.randomPitch;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnCasing(TextureManager textureManager, SpentCasing config, World world, double x, double y, double z, float pitch, float yaw, boolean crouched) {
        Vec3 rotatedMotionVec = CasingEjector.rotateVector(this.getMotion(), pitch + (float)rand.nextGaussian() * this.getPitchFactor(), yaw + (float)rand.nextGaussian() * this.getPitchFactor(), this.getPitchFactor(), this.getPitchFactor());
        ParticleSpentCasing casing = new ParticleSpentCasing(textureManager, world, x, y, z, rotatedMotionVec.field_72450_a, rotatedMotionVec.field_72448_b, rotatedMotionVec.field_72449_c, (float)((double)this.getPitchFactor() * rand.nextGaussian()), (float)((double)this.getYawFactor() * rand.nextGaussian()), config);
        CasingEjector.offsetCasing(casing, this.getOffset(), pitch, yaw, crouched);
        casing.field_70125_A = (float)Math.toDegrees(pitch);
        casing.field_70177_z = (float)Math.toDegrees(yaw);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)casing);
    }

    @SideOnly(value=Side.CLIENT)
    private static void offsetCasing(ParticleSpentCasing casing, Vec3 offset, float pitch, float yaw, boolean crouched) {
        float oX = (float)(crouched ? 0.0 : offset.field_72450_a);
        Matrix4f pitchMatrix = new Matrix4f();
        Matrix4f yawMatrix = new Matrix4f();
        pitchMatrix.rotate(pitch, new Vector3f(1.0f, 0.0f, 0.0f));
        yawMatrix.rotate(-yaw, new Vector3f(0.0f, 1.0f, 0.0f));
        Matrix4f rotMatrix = Matrix4f.mul((Matrix4f)yawMatrix, (Matrix4f)pitchMatrix, null);
        Vector4f offsetVector = new Vector4f(oX, (float)offset.field_72448_b, (float)offset.field_72449_c, 1.0f);
        Matrix4f.transform((Matrix4f)rotMatrix, (Vector4f)offsetVector, (Vector4f)offsetVector);
        Vector3f result = new Vector3f();
        result.set(offsetVector.x, offsetVector.y, offsetVector.z);
        casing.func_70107_b(casing.field_70165_t + (double)result.x, casing.field_70163_u + (double)result.y, casing.field_70161_v + (double)result.z);
    }

    private static Vec3 rotateVector(Vec3 vector, float pitch, float yaw, float pitchFactor, float yawFactor) {
        vector.field_72450_a += rand.nextGaussian() * (double)yawFactor;
        vector.field_72448_b += rand.nextGaussian() * (double)pitchFactor;
        vector.field_72449_c += rand.nextGaussian() * (double)yawFactor;
        Matrix4f pitchMatrix = new Matrix4f();
        Matrix4f yawMatrix = new Matrix4f();
        pitchMatrix.setIdentity();
        pitchMatrix.rotate(-pitch, new Vector3f(1.0f, 0.0f, 0.0f));
        yawMatrix.setIdentity();
        yawMatrix.rotate(-yaw, new Vector3f(0.0f, 1.0f, 0.0f));
        Vector4f vector4f = new Vector4f((float)vector.field_72450_a, (float)vector.field_72448_b, (float)vector.field_72449_c, 1.0f);
        Matrix4f.transform((Matrix4f)pitchMatrix, (Vector4f)vector4f, (Vector4f)vector4f);
        Matrix4f.transform((Matrix4f)yawMatrix, (Vector4f)vector4f, (Vector4f)vector4f);
        return Vec3.func_72443_a((double)vector4f.x, (double)vector4f.y, (double)vector4f.z);
    }

    public static CasingEjector fromId(int id) {
        return mappings.get(id);
    }

    public CasingEjector clone() {
        try {
            return (CasingEjector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new CasingEjector();
        }
    }
}

